<?php
/**
 *
 * Prepares list of all products
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

$pathToOriginalFile = dirname(__FILE__).MT_DS.'tpl_modules_products_all_listing_original.php';
if(!file_exists($pathToOriginalFile)) {
    $pathToOriginalFile = MT_FS_TEMPLATES.MT_DS.'template_default'.MT_DS.'templates'.MT_DS.'tpl_modules_products_all_listing.php';
}

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile('products_all');
    $isModuleEnabled = $toolObj->type == 'standard' && !$toolObj->params->checkValue('enable-effect', 'No');
    if($isModuleEnabled) break;
}

if(!$isModuleEnabled) {
    require_once($pathToOriginalFile);
    return;
}

ob_start();
require_once($pathToOriginalFile);
$products_listing_contents = ob_get_contents();
ob_end_clean();
$matches = array();
if(!preg_match_all('/<a\b[^>]*?\bhref="([^"]*)"[^>]*>[^<]*<img\b[^>]*?\bsrc="([^"]*)"[^>]*?\btitle="([^"]*)"[^>]*>[^<]*<\/a[^>]*>/is', $products_listing_contents, $matches, PREG_SET_ORDER)) {
    echo $products_listing_contents;
    return;
}

$getThumbFunc = $tool.'GetThumb';

foreach($matches as $match) {
    $productsId = preg_replace('/^.*?products_id=([0-9]+).*$/is', '$1', $match[1]);
    if($productsId == $match[1]) $productsId = null;
    $img = magictoolboxGetImagePath($match[2], $pid);
    $title = trim($match[3]);
    $link = '';
    if($toolObj->params->checkValue('link-to-product-page', 'Yes')) {
        $link = $match[1];
    }
    $html = $toolObj->getMainTemplate(array(
        'id' => 'products_all'.$productsId,
        'group' => 'products_all',
        'img' => DIR_WS_CATALOG.$getThumbFunc($img, 'original', $productsId),
        'thumb' => DIR_WS_CATALOG.$getThumbFunc($img, 'thumb', $productsId),
        'title' => $title,
        'alt' => $title,
        'description' => zen_clean_html(stripslashes(zen_get_products_description($productsId, $_SESSION['languages_id']))),
        'link' => $link,
    ));
    $products_listing_contents = str_replace($match[0], $html, $products_listing_contents);
}

echo $products_listing_contents;
