<?php
/**
 * Side Box Template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

$pathToOriginalFile = dirname(__FILE__).MT_DS.'tpl_whats_new_original.php';
if(!file_exists($pathToOriginalFile)) {
    $pathToOriginalFile = MT_FS_TEMPLATES.MT_DS.'template_default'.MT_DS.'sideboxes'.MT_DS.'tpl_whats_new.php';
}

if(!isset($GLOBALS['magictoolbox'])) {
    require_once($pathToOriginalFile);
    return;
}

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile('whats_new');
    $isModuleEnabled = ($toolObj->type == 'standard' || $toolObj->type == 'category') && !$toolObj->params->checkValue('enable-effect', 'No');
    if($isModuleEnabled) break;
}

if(!$isModuleEnabled) {
    require_once($pathToOriginalFile);
    return;
}

$sideboxId = 'whats_new';
$randomSideboxProduct = 'random_whats_new_sidebox_product';
$sideboxCounter = 'whats_new_box_counter';
$sideboxPrice = 'whats_new_price';

require(dirname(__FILE__).MT_DS.'tpl_magictoolbox_'.$tool.'.php');
