<?php
/**
 *
 * Prepares list of products to be displayed in template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

if(!defined('IS_ADMIN_FLAG')) die('Illegal Access');

$pathToOriginalFile = dirname(__FILE__).MT_DS.'product_listing_original.php';
if(!file_exists($pathToOriginalFile)) {
    //$pathToOriginalFile = dirname(dirname(__FILE__)).MT_DS.'product_listing.php';
    $pathToOriginalFile = MT_FS_MODULES.MT_DS.'product_listing.php';
}

require_once($pathToOriginalFile);

$mainPage = isset($_REQUEST['main_page']) ? $_REQUEST['main_page'] : $_GET['main_page'];
$currentPage = ($mainPage == 'advanced_search_result' ? 'search' : 'category');

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile($currentPage);
    $isModuleEnabled = $toolObj->type == 'standard' && !$toolObj->params->checkValue('enable-effect', 'No');
    if($isModuleEnabled) break;
}

if(!$isModuleEnabled) return;

if(($currentPage == 'category' &&
    //NOTE: ensure that current page is category (also works with friendly URLS - SEF) or search page
    ($GLOBALS['category_depth'] == 'products' && intval($GLOBALS['current_category_id']) > 0 || intval($_GET['manufacturers_id']) > 0) &&
    preg_match('/index\.php|-[cm]-[0-9_]+\.html/is', $GLOBALS['_SERVER']['REQUEST_URI'])
   ) ||
   ($currentPage == 'search')
  ) {

    $productsDescription = array();
    $rowNumber = 0;
    $rowCount = $listing->RecordCount();
    while($rowNumber < $rowCount) {
        $listing->Move($rowNumber);
        $productsDescription[$listing->fields['products_id']] = zen_clean_html(stripslashes(zen_get_products_description($listing->fields['products_id'], $_SESSION['languages_id'])));
        $rowNumber++;
    }

    $getThumbFunc = $tool.'GetThumb';

    foreach($list_box_contents as $rowkey => $row) {
        if(preg_match('/productListing-(row)?heading/is', $row[0]['params'])) {
            //NOTE: skip table header
            continue;
        }
        foreach($row as $key => $arr) {
            if(!is_int($key)) {
                continue;
            }
            $text = $arr['text'];

            $img = preg_replace("/^.*?<img[^>]*src=\"(.*?)\".*$/is", "$1", $text);
            if($img == $text || preg_match('/buy.now/is', $img)) {
                continue;
            }
            $imgOrig = $img;

            $aHref = preg_replace("/^.*?<a[^>]*href=\"(.*?)\".*$/is", "$1", $text);
            $pid = preg_replace("/^.*?products_id=(\d+)(?:\D.*)?$/is", "$1", $aHref);

            //NOTE: fix for 'Ceon URI Mapping' + 'Image Handler 4' (#59000)
            if(!is_numeric($pid) && defined('TABLE_CEON_URI_MAPPINGS')) {
                $result = $db->Execute('SELECT associated_db_id FROM '.TABLE_CEON_URI_MAPPINGS.' WHERE uri = "'.str_replace(HTTP_SERVER, '', str_replace(HTTPS_SERVER, '', $aHref)).'"');
                if(!$result->EOF) {
                    if(!empty($result->fields['associated_db_id'])) {
                        $pid = $result->fields['associated_db_id'];
                    }
                }
            }

            if($pid == $aHref) $pid = null;

            $img = magictoolboxGetImagePath($img, $pid);

            $thumb = DIR_WS_CATALOG.$getThumbFunc($img, 'thumb', $pid);
            $img = DIR_WS_CATALOG.$getThumbFunc($img, 'original', $pid);

            $link = '';

            if($toolObj->params->checkValue('link-to-product-page', 'Yes')) {
                $link = $aHref;
            }

            $_title = preg_replace("/^.*?<img[^>]*title=\"(.*?)\".*$/is", "$1", $text);
            if($_title == $text) $_title = preg_replace("/^.*?<img[^>]*alt=\"(.*?)\".*$/is", "$1", $text);
            if($_title == $text) $_title = '';

            $text = $toolObj->getMainTemplate(array(
                'id' => $currentPage.$pid,
                'group' => $currentPage,
                'img' => $img,
                'thumb' => $thumb,
                'title' => $_title,
                'description' => empty($productsDescription[$pid]) ? '' : $productsDescription[$pid],
                'link' => $link
            ));

            $arr['text'] = preg_replace('/<a[^>]+><img[^>]+?src=\"'.preg_quote($imgOrig, '/').'\"[^>]+><\/a>/is', $text, $arr['text']);

            $list_box_contents[$rowkey][$key] = $arr;

        }
    }
}
