<?php

    require('includes/application_top.php');

    ini_set('display_errors', true);
    error_reporting(E_ALL & ~E_NOTICE);

    $result = $db->Execute("SHOW TABLES LIKE '".DB_PREFIX."magiczoomplus_configuration'");
    if($result->EOF) {
        die('Magic Zoom Plus settings does not exist! Make sure that the module is installed correctly.');
    }

    defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);
    defined('MT_FS_ROOT') || define('MT_FS_ROOT', dirname(dirname(__FILE__)).MT_DS);//DIR_FS_CATALOG
    defined('MT_WS_ROOT') || define('MT_WS_ROOT', preg_replace('#[^/]+/$#', '', DIR_WS_ADMIN));//DIR_WS_CATALOG
    defined('MT_FS_ADMIN') || define('MT_FS_ADMIN', dirname(__FILE__).MT_DS);//DIR_FS_ADMIN
    defined('MT_FS_CATALOG_TEMPLATES') || define('MT_FS_CATALOG_TEMPLATES', MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS);//DIR_FS_CATALOG_TEMPLATES

    $action = isset($_POST['magiczoomplus-submit-action']) ? $_POST['magiczoomplus-submit-action'] : false;
    $activeTab = isset($_POST['magiczoomplus-active-tab']) ? $_POST['magiczoomplus-active-tab'] : false;

    if($_SERVER['REQUEST_METHOD'] == 'POST') {
        switch($action) {
            case 'save':
                if(isset($_POST['magictoolbox']) && is_array($_POST['magictoolbox'])) {
                    $db->Execute("UPDATE `".DB_PREFIX."magiczoomplus_configuration` SET `enabled` = 0 WHERE `block` != 'default'");
                    foreach($_POST['magictoolbox'] as $block => $params) {
                        if(!is_array($params)) continue;
                        foreach($params as $id => $value) {
                            $value = zen_db_input($value);
                            $db->Execute("UPDATE `".DB_PREFIX."magiczoomplus_configuration` SET `value` = '{$value}', `enabled` = 1 WHERE `block` = '{$block}' AND `name` = '{$id}'");
                        }
                    }
                }
                break;
            case 'reset':
                $db->Execute("UPDATE `".DB_PREFIX."magiczoomplus_configuration` SET `value` = `default_value`, `enabled`=`default_enabled` WHERE `block`='{$activeTab}'");
                break;
            case 'upload':
            default :
        }
    }

    require(MT_FS_ROOT.preg_replace('/\/|\\\\/', MT_DS, DIR_WS_MODULES).'magiczoomplus'.MT_DS.'functions.php');
    $tool = magiczoomplusGetTool();
    $params = $tool->params;

    $blocks = array(
		'default' => 'General',
		'product' => 'Product page',
		'category' => 'Category page',
		'products_new' => 'New Products page',
		'products_all' => 'All Products page',
		'search' => 'Search Results page',
		'new_products' => 'New Products block',
		'whats_new' => 'New Products sidebar',
		'specials' => 'Specials sidebar',
		'featured' => 'Featured sidebar',
	);
    $map = array(
		'default' => array(
			'Positioning and Geometry' => array(
				'thumb-max-width' => true,
				'thumb-max-height' => true,
				'zoomWidth' => true,
				'zoomHeight' => true,
				'zoomPosition' => true,
				'zoomDistance' => true,
				'square-images' => true,
			),
			'Miscellaneous' => array(
				'lazyZoom' => true,
				'rightClick' => true,
				'cssClass' => true,
				'link-to-product-page' => true,
				'show-message' => true,
				'message' => true,
				'imagemagick' => true,
				'image-quality' => true,
			),
			'Zoom mode' => array(
				'zoomMode' => true,
				'zoomOn' => true,
				'upscale' => true,
				'smoothing' => true,
				'variableZoom' => true,
				'zoomCaption' => true,
			),
			'Expand mode' => array(
				'expand' => true,
				'expandZoomMode' => true,
				'expandZoomOn' => true,
				'expandCaption' => true,
				'closeOnClickOutside' => true,
			),
			'Watermark' => array(
				'watermark' => true,
				'watermark-max-width' => true,
				'watermark-max-height' => true,
				'watermark-opacity' => true,
				'watermark-position' => true,
				'watermark-offset-x' => true,
				'watermark-offset-y' => true,
			),
			'Hint' => array(
				'hint' => true,
				'textHoverZoomHint' => true,
				'textClickZoomHint' => true,
				'textExpandHint' => true,
				'textBtnClose' => true,
				'textBtnNext' => true,
				'textBtnPrev' => true,
			),
			'Mobile' => array(
				'zoomModeForMobile' => true,
				'textHoverZoomHintForMobile' => true,
				'textClickZoomHintForMobile' => true,
				'textExpandHintForMobile' => true,
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect' => true,
				'template' => true,
				'magicscroll' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Multiple images' => array(
				'selectorTrigger' => true,
				'selector-max-width' => true,
				'selector-max-height' => true,
				'transitionEffect' => true,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'switch-attributes-images' => false,
				'options-names' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
			'Scroll' => array(
				'width' => true,
				'height' => true,
				'mode' => true,
				'items' => true,
				'speed' => true,
				'autoplay' => true,
				'loop' => true,
				'step' => true,
				'arrows' => true,
				'pagination' => true,
				'easing' => true,
				'scrollOnWheel' => true,
				'lazy-load' => true,
				'scroll-extra-styles' => true,
				'show-image-title' => true,
			),
		),
		'category' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'products_new' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'products_all' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'search' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'new_products' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'whats_new' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'specials' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
		'featured' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'zoomWidth' => false,
				'zoomHeight' => false,
				'zoomPosition' => false,
				'zoomDistance' => false,
			),
			'Miscellaneous' => array(
				'lazyZoom' => false,
				'rightClick' => false,
				'cssClass' => false,
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
			'Zoom mode' => array(
				'zoomMode' => false,
				'zoomOn' => false,
				'upscale' => false,
				'smoothing' => false,
				'variableZoom' => false,
				'zoomCaption' => false,
			),
			'Expand mode' => array(
				'expand' => false,
				'expandZoomMode' => false,
				'expandZoomOn' => false,
				'expandCaption' => false,
				'closeOnClickOutside' => false,
			),
			'Hint' => array(
				'hint' => false,
				'textHoverZoomHint' => false,
				'textClickZoomHint' => false,
				'textExpandHint' => false,
				'textBtnClose' => false,
				'textBtnNext' => false,
				'textBtnPrev' => false,
			),
			'Mobile' => array(
				'zoomModeForMobile' => false,
				'textHoverZoomHintForMobile' => false,
				'textClickZoomHintForMobile' => false,
				'textExpandHintForMobile' => false,
			),
		),
	);

    $template_mt = 'classic';
    $templates = array();
    //NOTE: used templates
    //$result = $db->Execute("SELECT * FROM ".TABLE_TEMPLATE_SELECT);
    //NOTE: all templates (with module installed)
    if(file_exists(MT_FS_CATALOG_TEMPLATES)) {
        $templatesDir = dir(MT_FS_CATALOG_TEMPLATES);
        if($templatesDir) {
            while($file = $templatesDir->read()) {
                if(file_exists(MT_FS_CATALOG_TEMPLATES.$file.MT_DS.'jscript'.MT_DS.'magiczoomplus.js')) {
                    $templates[] = $file;
                }
            }
            $templatesDir->close();
        }
    }
    //TODO: add support multiple templates
    if(count($templates) == 1) $template_mt = $templates[0];

    $paramData = $tool->params->getParam('magicscroll', 'product', false);
    $paramData['description'] = '<img id="magicscroll_icon" src="'.DIR_WS_ADMIN.'includes/magiczoomplus/resources/images/magicscroll.png" />'.$paramData['description'];
    $tool->params->appendParams(array('magicscroll' => $paramData), 'product');

    include(MT_FS_ADMIN.'includes'.MT_DS.'magiczoomplus'.MT_DS.'magictoolbox.settings.editor.class.php');
    $settings = new MagictoolboxSettingsEditorClass(MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript');
    $settings->paramsMap = &$map;
    $settings->core = &$tool;
    $settings->profiles = &$blocks;
    $settings->pathToJS = MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript';
    $settings->action = htmlentities($_SERVER['REQUEST_URI']);
    $settings->setResourcesURL(DIR_WS_ADMIN.'includes/magiczoomplus/resources/');
    $settings->jQueryNoConflictLevel(0);
    $settings->addJSFile(DIR_WS_ADMIN.'includes/magiczoomplus/resources/options.js');
    $html = $settings->getHTML();
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript">
<!--
function popupHelpWindow(url) {
    window.open(url,'popupImageWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
}
function init() {
    cssjsmenu('navbar');
    if(document.getElementById) {
        var kill = document.getElementById('hoverJS');
        kill.disabled = true;
    }
}
// -->
</script>
<style type="text/css"></style>
</head>
<body onLoad="init()" >
<?php require(DIR_WS_INCLUDES.'header.php'); ?>
<?php echo $settings->getHTML(); ?>
<?php require(DIR_WS_INCLUDES.'footer.php'); ?>
<script type="text/javascript">
//<![CDATA[
    initOptionsValidation('<?php echo $settings->getName('product', 'template'); ?>', '<?php echo $settings->getName('product', 'magicscroll'); ?>');
//]]>
</script>
</body>
</html>
<?php require(DIR_WS_INCLUDES.'application_bottom.php'); ?>
