<?php
    /**
     *  Zen-Cart module installer class
     */

    require_once(dirname(__FILE__).'/magictoolbox.installer.core.class.php');

    class MagicToolboxZencartModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        var $templateDir = '';
        var $newZenCart = false;
        var $adminFolders = array();
        var $modules = array();
        var $detectedModules = array();
        var $detectedOldModules = array();
        var $zenFiles = array();
        var $magictoolboxFiles = array();

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';
            $this->modules = array(
                'magiczoom' => array(
                    'name' => 'Magic Zoom',
                    'type' => 'standard',
                ),
                'magiczoomplus' => array(
                    'name' => 'Magic Zoom Plus',
                    'type' => 'standard',
                ),
                'magicthumb' => array(
                    'name' => 'Magic Thumb',
                    'type' => 'standard',
                ),
                'magicmagnify' => array(
                    'name' => 'Magic Magnify',
                    'type' => 'standard',
                ),
                'magicmagnifyplus' => array(
                    'name' => 'Magic Magnify Plus',
                    'type' => 'standard',
                ),
                'magictouch' => array(
                    'name' => 'Magic Touch',
                    'type' => 'standard',
                ),
                'magicslideshow' => array(
                    'name' => 'Magic Slideshow',
                    'type' => 'category',
                ),
                'magicscroll' => array(
                    'name' => 'Magic Scroll',
                    'type' => 'category',
                ),
                'magic360' => array(
                    'name' => 'Magic 360',
                    'type' => 'circle',
                ),
                'magic360flash' => array(
                    'name' => 'Magic 360 Flash',
                    'type' => 'circle',
                ),
            );
        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/includes/modules/magiczoom/magiczoom.module.core.class.php')) {
                return true;
            }
            return false;
        }

        function defineConfig() {
            static $defined = false;
            if(!$defined) {
                if(file_exists($this->dir.'/includes/configure.php')) {
                    require_once($this->dir.'/includes/configure.php');
                } else {
                    $this->setError('File includes/configure.php does not exist');
                    return false;
                }
                if(file_exists($this->dir.'/includes/database_tables.php')) {
                    require_once($this->dir.'/includes/database_tables.php');
                } else {
                    $this->setError('File includes/database_tables.php does not exist');
                    return false;
                }
                $defined = true;
            }
            return true;
        }

        function getTemplateDir() {
            static $templateDir = '';
            if(!$templateDir) {
                if($this->defineConfig()) {
                    $link = mysqli_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE);
                    if($link) {
                        $query = "select * from ".TABLE_TEMPLATE_SELECT;
                        $result = mysqli_query($link, $query);
                        if(/*!$result || */$row = mysqli_fetch_assoc($result)) {
                            if(!empty($row['template_dir'])) {
                                $templateDir = $row['template_dir'];
                            } else {
                                //$templateDir = 'template_default';
                                $this->setError('Can\'t determine template directory. The field \'template_dir\' in database is empty');
                            }
                        } else {
                            $this->setError('Error while trying execute query.<br/>Query: '.$query.'<br/>Mysql Error: '.mysqli_error($link));
                        }
                        //if($result) mysqli_free_result($link);
                        mysqli_close($link);
                    } else {
                        $this->setError('Could not connect: '.mysqli_error($link));
                    }
                }
            }
            return $templateDir;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');

            //NOTE: to include includes/version.php
            $this->getPlatformVersion();

            //if(!file_exists($this->dir.'/includes/initsystem.php')) {
            if(!defined('PROJECT_VERSION_NAME') || PROJECT_VERSION_NAME != 'Zen Cart') {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the Zen-Cart store directory.');
                return false;
            }
            return true;
        }

        function prepare() {

            foreach($this->modules as $id => $module) {
                if(file_exists($this->dir.'/includes/modules/'.$id.'/functions.php')) {
                    $this->detectedModules[] = $id;
                } else {
                    if(file_exists($this->dir.'/includes/modules/'.$id.'/'.$id.'_addons.php') ||
                       file_exists($this->dir.'/includes/modules/magictoolbox/'.$id.'_addons.php')) {
                            $this->detectedOldModules[] = $id;
                    }
                }
            }

            if($this->installMode == 'install' && !empty($this->detectedOldModules)) {
                $id = $this->detectedOldModules[0];
                $this->setError('You have installed an old version of the '.$this->modules[$id]['name'].' module!');
                $this->setError('Please, uninstall it before installing this one.');
                return false;
            }

            $this->templateDir = $this->getTemplateDir();
            if(empty($this->templateDir)) return false;

            if(defined('TABLE_ADMIN_PAGES')) {
                $this->newZenCart = true;
            }

            //NOTE: find admin folders
            $list = glob($this->dir.'/*');
            for($i = 0, $l=count($list); $i < $l; $i++) {
                if(is_dir($list[$i]) && file_exists($list[$i].'/includes/configure.php')
                                     && file_exists($list[$i].'/alt_nav.php')) {
                    $this->adminFolders[] = preg_replace('/^.*?([^\\/]*)$/is', '$1', $list[$i]);
                }
            }

            $this->zenFiles = array(
                array(
                    'path' => 'includes/modules/'.$this->templateDir.'/additional_images.php',
                    'mod-path' => 'includes/modules/YOUR-TEMPLATE-FOLDER/additional_images.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/modules/'.$this->templateDir.'/product_listing.php',
                    'mod-path' => 'includes/modules/YOUR-TEMPLATE-FOLDER/product_listing.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/modules/'.$this->templateDir.'/new_products.php',
                    'mod-path' => 'includes/modules/YOUR-TEMPLATE-FOLDER/new_products.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/sideboxes/tpl_featured.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/sideboxes/tpl_featured.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/sideboxes/tpl_specials.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/sideboxes/tpl_specials.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/sideboxes/tpl_whats_new.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/sideboxes/tpl_whats_new.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_index_default.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_index_default.php',
                    'need-be-installed' => false,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_index_categories.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_index_categories.php',
                    'need-be-installed' => false,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_modules_main_product_image.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_modules_main_product_image.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_modules_products_all_listing.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_modules_products_all_listing.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_modules_products_new_listing.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_modules_products_new_listing.php',
                    'need-be-installed' => true,
                    'replaced' => false,
                    'backup-exists' => false,
                ),
            );

            foreach($this->zenFiles as $index => $file) {
                if(file_exists($this->dir.'/'.$file['path'])) {
                    $contents = file_get_contents($this->dir.'/'.$file['path']);
                    if(preg_match('/magictoolbox|mod->template/', $contents)) {
                        $this->zenFiles[$index]['replaced'] = true;
                    }
                    $backupPath = preg_replace('#^(.*?/[^/]+)(\.[^\./]+)$#i', '$1'.$this->backupSufix.'$2', $file['path']);
                    if(file_exists($this->dir.'/'.$backupPath)) {
                        $this->zenFiles[$index]['backup-exists'] = true;
                    }
                }
            }

            $this->magictoolboxFiles = array(
                array(
                    'path' => 'includes/auto_loaders/config.magiczoom.php',
                    'mod-path' => 'includes/auto_loaders/config.magiczoom.php',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/extra_configures/magiczoom_extra_configure.php',
                    'mod-path' => 'includes/extra_configures/magiczoom_extra_configure.php',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/languages/english/extra_definitions/magiczoom.php',
                    'mod-path' => 'includes/languages/english/extra_definitions/magiczoom.php',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/modules/magiczoom',
                    'mod-path' => 'includes/modules/magiczoom',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/css/magiczoom',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/css/magiczoom',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/jscript/jscript_zen_magictoolbox.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/jscript/jscript_zen_magictoolbox.php',
                    'shared' => true,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/jscript/magiczoom.js',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/jscript/magiczoom.js',
                    'shared' => false,
                ),
                //NOTE: magiczoom, magiczoomplus
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/jscript/magictoolbox.utils.js',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/jscript/magictoolbox.utils.js',
                    'shared' => true,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/jscript/magicscroll.js',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/jscript/magicscroll.js',
                    'shared' => true,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/magiczoom',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/magiczoom',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/sideboxes/tpl_magictoolbox_magiczoom.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/sideboxes/tpl_magictoolbox_magiczoom.php',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_index_magiczoom.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_index_magiczoom.php',
                    'shared' => false,
                ),
                array(
                    'path' => 'includes/templates/'.$this->templateDir.'/templates/tpl_modules_magiczoom.php',
                    'mod-path' => 'includes/templates/YOUR-TEMPLATE-FOLDER/templates/tpl_modules_magiczoom.php',
                    'shared' => false,
                ),
            );

            foreach($this->adminFolders as $adminFolder) {
                $this->magictoolboxFiles[] = array(
                    'path' => $adminFolder.'/magiczoom.php',
                    'mod-path' => 'YOUR-ADMIN-FOLDER/magiczoom.php',
                    'shared' => false,
                );
                $this->magictoolboxFiles[] = array(
                    'path' => $adminFolder.'/includes/boxes/extra_boxes/magiczoom_extras_dhtml.php',
                    'mod-path' => 'YOUR-ADMIN-FOLDER/includes/boxes/extra_boxes/magiczoom_extras_dhtml.php',
                    'shared' => false,
                );
                $this->magictoolboxFiles[] = array(
                    'path' => $adminFolder.'/includes/extra_datafiles/magiczoom.php',
                    'mod-path' => 'YOUR-ADMIN-FOLDER/includes/extra_datafiles/magiczoom.php',
                    'shared' => false,
                );
                $this->magictoolboxFiles[] = array(
                    'path' => $adminFolder.'/includes/magiczoom',
                    'mod-path' => 'YOUR-ADMIN-FOLDER/includes/magiczoom',
                    'shared' => false,
                );
            }

            foreach($this->getAdminLanguagesDirs() as $adminLanguageDir) {
                $this->magictoolboxFiles[] = array(
                    'path' => $adminLanguageDir.'/extra_definitions/magiczoom.php',
                    'mod-path' => 'YOUR-ADMIN-FOLDER/includes/languages/english/extra_definitions/magiczoom.php',
                    'shared' => false,
                );
            }

            //for fix url's in css files
            $this->resDir = preg_replace('/^(.*?\/)[^\/]+\/[^\/]+$/is', '$1', $_SERVER['SCRIPT_NAME']).'includes/templates/'.$this->templateDir.'/css/magiczoom';

            return true;

        }

        function getExistsFilesRecursive($files) {
            $ret = array();
            foreach($files as $f) {
                while(!file_exists($this->dir.$f) && strlen($f) > 0 && strpos($f, '/') !== false) {
                    $f = substr($f, 0, strrpos($f, '/'));
                }
                $ret[] = $f;
            }
            return array_unique($ret);
        }

        function getAdminLanguagesDirs() {
            static $adminLanguagesDirs = array();
            if(empty($adminLanguagesDirs) && !empty($this->adminFolders)) {
                foreach($this->adminFolders as $adminFolder) {
                    $list = glob($this->dir.'/'.$adminFolder.'/includes/languages/*');
                    if($list !== false) {
                        $list_count = count($list);
                        for($i = 0; $i < $list_count; $i++) {
                            if(is_dir($list[$i])) {
                                $adminLanguagesDirs[] = $adminFolder.'/includes/languages/'.basename($list[$i]);
                            }
                        }
                    }
                }
            }
            return $adminLanguagesDirs;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $status = true;

            $backend = array();
            if(!empty($this->adminFolders)) {
                foreach($this->adminFolders as $adminFolder) {
                    $backend[] = '/'.$adminFolder;
                    $backend[] = '/'.$adminFolder.'/magiczoom.php';
                    $backend[] = '/'.$adminFolder.'/includes';
                    $backend[] = '/'.$adminFolder.'/includes/magiczoom';
                    $backend[] = '/'.$adminFolder.'/includes/boxes/extra_boxes';
                    $backend[] = '/'.$adminFolder.'/includes/boxes/extra_boxes/magiczoom_extras_dhtml.php';
                    $backend[] = '/'.$adminFolder.'/includes/extra_datafiles';
                    $backend[] = '/'.$adminFolder.'/includes/extra_datafiles/magiczoom.php';
                }
                foreach($this->getAdminLanguagesDirs() as $adminLanguageDir) {
                    $backend[] = '/'.$adminLanguageDir.'/extra_definitions';
                    $backend[] = '/'.$adminLanguageDir.'/extra_definitions/magiczoom.php';
                }
            }

            $frontend = array(
                '/includes/auto_loaders',
                '/includes/auto_loaders/config.magiczoom.php',
                '/includes/extra_configures',
                '/includes/extra_configures/magiczoom_extra_configure.php',
                '/includes/languages/english/extra_definitions',
                '/includes/languages/english/extra_definitions/magiczoom.php',
                '/includes/modules',
                '/includes/modules/magiczoom',
                '/includes/modules/'.$this->templateDir,
                '/includes/modules/'.$this->templateDir.'/additional_images.php',
                '/includes/modules/'.$this->templateDir.'/product_listing.php',
                '/includes/modules/'.$this->templateDir.'/new_products.php',
                '/includes/templates/'.$this->templateDir,
                '/includes/templates/'.$this->templateDir.'/magiczoom',
                '/includes/templates/'.$this->templateDir.'/css',
                '/includes/templates/'.$this->templateDir.'/css/magiczoom',
                '/includes/templates/'.$this->templateDir.'/jscript',
                '/includes/templates/'.$this->templateDir.'/jscript/jscript_zen_magictoolbox.php',
                '/includes/templates/'.$this->templateDir.'/jscript/magiczoom.js',
                '/includes/templates/'.$this->templateDir.'/jscript/magictoolbox.utils.js',
                '/includes/templates/'.$this->templateDir.'/jscript/magicscroll.js',
                '/includes/templates/'.$this->templateDir.'/sideboxes',
                '/includes/templates/'.$this->templateDir.'/sideboxes/tpl_featured.php',
                '/includes/templates/'.$this->templateDir.'/sideboxes/tpl_specials.php',
                '/includes/templates/'.$this->templateDir.'/sideboxes/tpl_whats_new.php',
                '/includes/templates/'.$this->templateDir.'/sideboxes/tpl_magictoolbox_magiczoom.php',
                '/includes/templates/'.$this->templateDir.'/templates',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_index_default.php',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_index_categories.php',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_modules_main_product_image.php',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_modules_products_all_listing.php',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_modules_products_new_listing.php',
                '/includes/templates/'.$this->templateDir.'/templates/tpl_modules_magiczoom.php',
            );

            if($this->installMode == 'uninstall' && !empty($this->detectedOldModules)) {
                $frontend = array_merge($frontend, array(
                    '/includes/modules/pages/advanced_search_result',
                    '/includes/modules/pages/document_general_info',
                    '/includes/modules/pages/document_product_info',
                    '/includes/modules/pages/index',
                    '/includes/modules/pages/product_free_shipping_info',
                    '/includes/modules/pages/product_info',
                    '/includes/modules/pages/product_music_info',
                    '/includes/modules/pages/product_reviews',
                    '/includes/modules/pages/product_reviews_info',
                    '/includes/modules/pages/product_reviews_write',
                    '/includes/modules/pages/products_all',
                    '/includes/modules/pages/products_new',
                    '/includes/modules/magictoolbox',
                    '/includes/templates/'.$this->templateDir.'/magictoolbox',
                ));
            }

            $files = array_merge($backend, $frontend);
            $files = $this->getExistsFilesRecursive($files);
            list($result, $wrang) = $this->checkFilesPerm($files);

            if(!$result) {
                $this->setError('This installer need to modify some Zen-Cart store files.');
                $this->setError('Please check write access for following files of your Zen-Cart store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $status = false;
            }

            $files = array(
                '/includes/configure.php',
                '/includes/database_tables.php'
            );
            list($result, $wrang) = $this->checkFilesPerm(array_unique($files), 'read');
            if(!$result) {
                $this->setError('This installer need to read some Zen-Cart store files.');
                $this->setError('Please check read access for following files of your Zen-Cart store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $status = false;
            }

            return $status;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            $backup = array();
            foreach($this->zenFiles as $index => $file) {
                if($file['need-be-installed'] && !$file['backup-exists'] && !$file['replaced'] && file_exists($this->dir.'/'.$file['path'])) {
                    $backup[] = '/'.$file['path'];
                }
            }
            list($result, $wrang) = $this->createBackups($backup);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            $remove = array();

            if((count($this->detectedModules) == 1 && $this->detectedModules[0] == 'magiczoom') ||
               (count($this->detectedOldModules) == 1 && $this->detectedOldModules[0] == 'magiczoom')) {
                foreach($this->zenFiles as $index => $file) {
                    //NOTE: update 'replaced' status after restoreStep_installFiles()
                    if(file_exists($this->dir.'/'.$file['path'])) {
                        $contents = file_get_contents($this->dir.'/'.$file['path']);
                        if(preg_match('/magictoolbox|mod->template/', $contents)) {
                            $this->zenFiles[$index]['replaced'] = $file['replaced'] = true;
                        } else {
                            $this->zenFiles[$index]['replaced'] = $file['replaced'] = false;
                        }
                    }

                    if(!$file['replaced'] /*&& $file['need-be-installed'] */&& $file['backup-exists']) {
                        $remove[] = '/'.$file['path'];
                    }
                }
            }
            $this->removeBackups($remove);
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            $modTemplateDir = 'includes/modules/'.$this->templateDir;
            $tplTemplateDir = 'includes/templates/'.$this->templateDir.'/templates';
            $tplSideboxesDir = 'includes/templates/'.$this->templateDir.'/sideboxes';

            //trying to create folders
            if(!file_exists($this->dir.'/'.$modTemplateDir)) {
                if(@mkdir($this->dir.'/'.$modTemplateDir)) {
                    $this->log('CREATE DIR '.$modTemplateDir);
                }
            }
            if(!file_exists($this->dir.'/'.$tplTemplateDir)) {
                if(@mkdir($this->dir.'/'.$tplTemplateDir)) {
                    $this->log('CREATE DIR '.$tplTemplateDir);
                }
            }
            if(!file_exists($this->dir.'/'.$tplSideboxesDir)) {
                if(@mkdir($this->dir.'/'.$tplSideboxesDir)) {
                    $this->log('CREATE DIR '.$tplSideboxesDir);
                }
            }

            foreach($this->zenFiles as $index => $file) {
                if($file['need-be-installed'] && !$file['replaced']) {
                    if(file_exists($this->dir.'/'.$file['path'])) {
                        $copyPath = preg_replace('#^(.*?/[^/]+)(\.[^\./]+)$#i', '$1_original$2', $file['path']);
                        if(!file_exists($this->dir.'/'.$copyPath) &&
                            rename($this->dir.'/'.$file['path'], $this->dir.'/'.$copyPath)) {
                            $this->log('CREATE FILE '.$copyPath);
                        }
                    }
                    $this->copyFile($this->modDir.'/'.$file['mod-path'], $this->dir.'/'.$file['path']);
                } else if(basename($file['path']) == 'tpl_modules_main_product_image.php' && $file['replaced']) {
                    //NOTE: need to update because it was changed
                    $this->copyFile($this->modDir.'/'.$file['mod-path'], $this->dir.'/'.$file['path']);
                }
            }

            foreach($this->magictoolboxFiles as $index => $file) {
                if(file_exists($this->modDir.'/'.$file['mod-path'])) {
                    if(is_dir($this->modDir.'/'.$file['mod-path'])) {
                        $this->createDirRecursive($this->dir.'/'.$file['path']);
                        $this->copyDir($this->modDir.'/'.$file['mod-path'], $this->dir.'/'.$file['path']);
                    } else {
                        $this->copyFile($this->modDir.'/'.$file['mod-path'], $this->dir.'/'.$file['path']);
                    }
                }
            }

            return true;
        }

        function uninstall_from_logFile($exclude = array()) {

            $this->restoreStep_installFiles();
            if(file_exists($this->dir.'/magiczoom_install.log')) {
                $this->removeFiles('/magiczoom_install.log');
            }
            return;

        }

        function restoreStep_installFiles() {

            $filesToRemove = array();

            if(!empty($this->detectedOldModules)) {
                $pages = array(
                    'advanced_search_result',
                    'document_general_info',
                    'document_product_info',
                    'index',
                    'product_free_shipping_info',
                    'product_info',
                    'product_music_info',
                    'product_reviews',
                    'product_reviews_info',
                    'product_reviews_write',
                    'products_all',
                    'products_new',
                );
                foreach($pages as $page) {
                    $filesToRemove[] = 'includes/modules/pages/'.$page.'/jscript_zen_magiczoom.php';
                    $filesToRemove[] = 'includes/modules/pages/'.$page.'/jscript_zen3_magiczoom.php';
                    $filesToRemove[] = 'includes/modules/pages/'.$page.'/jscript_zen2_magiczoom.php';
                    $filesToRemove[] = 'includes/modules/pages/'.$page.'/jscript_zen1_magiczoom.php';
                }
                $filesToRemove[] = 'includes/templates/'.$this->templateDir.'/magictoolbox';
            }

            foreach($this->magictoolboxFiles as $index => $file) {
                if(!$file['shared']) {
                    $filesToRemove[] = $file['path'];
                }
            }

            $remove = true;
            foreach(array_merge($this->detectedOldModules, $this->detectedModules) as $id) {
                if(!in_array($id, array('magicslideshow', 'magic360', 'magiczoom'))) {
                    $remove = false;
                }
            }
            if($remove) {
                $filesToRemove[] = 'includes/templates/'.$this->templateDir.'/jscript/magicscroll.js';
                $filesToRemove[] = 'includes/templates/'.$this->templateDir.'/jscript/magictoolbox.utils.js';
            }
            if(count($this->detectedModules) == 1 && $this->detectedModules[0] == 'magiczoom') {
                $filesToRemove[] = 'includes/templates/'.$this->templateDir.'/jscript/jscript_zen_magictoolbox.php';
            }

            foreach($filesToRemove as $file) {
                if(file_exists($this->dir.'/'.$file)) {
                    if(is_dir($this->dir.'/'.$file)) {
                        $this->removeDir($this->dir.'/'.$file);
                    } else {
                        $this->removeFiles('/'.$file);
                    }
                }
            }

            $restore = array();
            if((count($this->detectedModules) == 1 && $this->detectedModules[0] == 'magiczoom') ||
               (count($this->detectedOldModules) == 1 && $this->detectedOldModules[0] == 'magiczoom')) {
                foreach($this->zenFiles as $index => $file) {
                    if(/*$file['need-be-installed'] &&*/ $file['replaced']) {
                        $pathToOriginalCopy = preg_replace('#^(.*?/[^/]+)(\.[^\./]+)$#i', '$1_original$2', $file['path']);
                        if(file_exists($this->dir.'/'.$pathToOriginalCopy)) {
                            @unlink($this->dir.'/'.$file['path']);
                            rename($this->dir.'/'.$pathToOriginalCopy, $this->dir.'/'.$file['path']);
                        } else if($file['backup-exists']) {
                            $restore[] = '/'.$file['path'];
                        } else {
                            @unlink($this->dir.'/'.$file['path']);
                        }
                    }
                }
            }

            //NOTE: old cooperative mode (360 + standard)
            if(count($this->detectedOldModules) == 2 && in_array('magic360', $this->detectedOldModules)) {
                $modTemplateDir = $this->dir.'/includes/modules/'.$this->templateDir;
                $tplTemplateDir = $this->dir.'/includes/templates/'.$this->templateDir.'/templates';
                if(file_exists($modTemplateDir.'/additional_images_magictoolbox_cooperative_mode_backup.php')) {
                    @unlink($modTemplateDir.'/additional_images.php');
                    rename($modTemplateDir.'/additional_images_magictoolbox_cooperative_mode_backup.php', $modTemplateDir.'/additional_images.php');
                }
                if(file_exists($tplTemplateDir.'/tpl_modules_main_product_image_magictoolbox_cooperative_mode_backup.php')) {
                    @unlink($tplTemplateDir.'/tpl_modules_main_product_image.php');
                    rename($tplTemplateDir.'/tpl_modules_main_product_image_magictoolbox_cooperative_mode_backup.php', $tplTemplateDir.'/tpl_modules_main_product_image.php');
                }
            }

            $this->restoreFromBackups($restore);

            return true;

        }

        function installDB() {
            $queries = file($this->modDir.'/install.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if(!$this->executeQueries($queries)) return false;
            if($this->newZenCart) {
                $queries = file($this->modDir.'/install_menu.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                if(!$this->executeQueries($queries)) return false;
            }
            return true;
        }

        function restoreStep_installDB() {
            $queries = file($this->modDir.'/uninstall.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            if(!$this->executeQueries($queries)) return false;
            if($this->newZenCart) {
                $queries = file($this->modDir.'/uninstall_menu.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                if(!$this->executeQueries($queries)) return false;
            }
            return true;
        }

        function executeQueries($queries) {
            if(DB_PREFIX != '') {
                $pattern = '(magiczoom_(?:configuration|images)|admin_(?:menus|pages)|configuration_group|configuration)(\s|;)';
                $queries = preg_replace('/'.$pattern.'/is', DB_PREFIX.'$1$2', $queries);
                //$queries = preg_replace('/configuration /is', DB_PREFIX.'configuration ', $queries);
            }
            $link = mysqli_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE);
            if(!$link) {
                $this->setError('Could not connect: '.mysqli_error($link));
                return false;
            }
            $sql = '';
            $result = null;
            foreach($queries as $query) {
                $query = trim($query);
                if(substr($query, 0, 2) == '--') continue;
                $sql .= $query;
                if(substr($query, -1) != ';') continue;
                $result = mysqli_query($link, $sql);
                if(!$result) {
                    $this->setError('Error while trying execute query.<br/>Query: '.$sql.'<br/>Mysql Error: '.mysqli_error($link));
                    mysqli_close($link);
                    return false;
                }
                $sql = '';
            }
            //if($result) mysqli_free_result($link);
            mysqli_close($link);
            return true;
        }

        function upgrade($files) {
            $path = $this->dir.'/includes/templates/'.$this->templateDir.'/jscript/';
            foreach($files as $name => $file) {
                if(file_exists($path.$name)) {
                    unlink($path.$name);
                }
                file_put_contents($path.$name, $file);
                chmod($path.$name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            static $version = null;
            if($version === null) {
                if(file_exists($this->dir.'/includes/version.php')) {
                    require_once($this->dir.'/includes/version.php');
                    if(defined('PROJECT_VERSION_MAJOR')) {
                        $version = PROJECT_VERSION_MAJOR;
                        if(defined('PROJECT_VERSION_MINOR')) {
                            $version = $version.'.'.preg_replace('/^(\d+(?:\.\d+)+).*$/', '$1', PROJECT_VERSION_MINOR);
                        }
                    } else {
                        $version = '';
                    }
                } else {
                    $version = '';
                }
            }
            return $version;
        }

    }
