<?php
/**
 * Main Product Image Template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

$magic360HTML = $magictoolboxHTML;
$magictoolboxHTML = $toolObj->getMainTemplate(array(
    'id' => 'product'.$productsId,
    'group' => 'product',
    'img' => DIR_WS_CATALOG.magicthumbGetThumb($image, 'original', $productsId),
    'thumb' => DIR_WS_CATALOG.magicthumbGetThumb($image, 'thumb', $productsId),
    'title' => $productsTitle,
    'alt' => $productsTitle,
    'description' => $products_description,
));
if($cooperativeMode) {
    $magictoolboxHTML =
        '<div style="position: relative;">'.
            '<div id="mainImageContainer'.$productsId.'" style="position: absolute; left: -5000px;">'.
                //NOTE: we need this div because of MZP clones the parent node
                '<div>'.$magictoolboxHTML.'</div>'.
            '</div>'.
            '<div id="magic360Container'.$productsId.'">'.$magic360HTML.'</div>'.
        '</div>';
    $magictoolboxHTML .= "
<script type=\"text/javascript\">
    var magictoolboxEvent = '".$toolObj->params->getValue('selectorTrigger', 'product')."';

    //NOTE: in order to have time to switch the picture
    var switchDelay = 350;

    var magicJSAddEventMethod = 'jAddEvent';

    \$mjs(window)[magicJSAddEventMethod]('load', function() {
        magictoolboxBindSelectors();
    });

    function magictoolboxBindSelectors() {
        var magic360Container = document.getElementById('magic360Container{$productsId}');
        var mainImageContainer = document.getElementById('mainImageContainer{$productsId}');
        if(magic360Container) {
            var magicToolboxSelectors = \$mjs(document).byClass('magicToolboxSelector');
            var switchFunction = function(e) {
                var objThis = e.target || e.srcElement;
                if(objThis.tagName.toLowerCase() == 'img') {
                    objThis = objThis.parentNode;
                }
                var isMagic360Visible = magic360Container.style.display != 'none';
                var isThisMagic360Selector = objThis.className.match(new RegExp('(?:\\\\s|^)m360-selector(?:\\\\s|$)'));
                if(isThisMagic360Selector && !isMagic360Visible) {
                    mainImageContainer.style.display = 'none';
                    magic360Container.style.display = 'block';
                } else if(isMagic360Visible && !isThisMagic360Selector) {
                    //NOTE: only on page load (first time)
                    if(mainImageContainer.style.position == 'absolute') {
                        mainImageContainer.style.width = 'auto';
                        mainImageContainer.style.height = 'auto';
                        mainImageContainer.style.position = 'static';
                    }
                    magic360Container.style.display = 'none';
                    mainImageContainer.style.display = 'block';
                }
                return false;
            };
            for(var j = 0; j < magicToolboxSelectors.length; j++) {
                \$mjs(magicToolboxSelectors[j])[magicJSAddEventMethod](magictoolboxEvent, switchFunction);
                \$mjs(magicToolboxSelectors[j])[magicJSAddEventMethod]('touchstart', switchFunction);
            }
        }
    }
</script>
";
}

if(!$toolObj->params->checkValue('template', 'original')) {
    $additionalImages = magictoolboxGetAdditionalImages($products_image, $productsId);
    foreach($additionalImages as $index => $img) {
        $additionalImages[$index] = $toolObj->getSelectorTemplate(array(
            'id' => 'product'.$productsId,
            'img' => DIR_WS_CATALOG.magicthumbGetThumb($img['path'], 'original', $productsId),
            'medium' => DIR_WS_CATALOG.magicthumbGetThumb($img['path'], 'thumb', $productsId),
            'thumb' => DIR_WS_CATALOG.magicthumbGetThumb($img['path'], 'selector', $productsId),
            'title' => $productsTitle,
            'alt' => $productsTitle,
        ));
        $additionalImages[$index] = str_replace('<a ', '<a class="magicToolboxSelector" ', $additionalImages[$index]);
    }
    if($cooperativeMode && !empty($magic360Icon) && file_exists(DIR_FS_CATALOG.$magic360Icon)) {
        $magic360Icon = DIR_WS_CATALOG.magicthumbGetThumb($magic360Icon, 'selector', 'magic360icon');
        array_unshift(
            $additionalImages,
            '<a class="magicToolboxSelector m360-selector active-selector" title="360" href="#" onclick="return false;"><img src="'.$magic360Icon.'" alt="360" /></a>'
        );
    }
    require_once(MT_FS_MODULES.MT_DS.'magicthumb'.MT_DS.'magictoolbox.templatehelper.class.php');
    MagicToolboxTemplateHelperClass::setPath(dirname(dirname(__FILE__)).MT_DS.'magicthumb');
    MagicToolboxTemplateHelperClass::setOptions($toolObj->params);
    $scrollToolObj = $getToolFunc(true);
    $magictoolboxHTML = MagicToolboxTemplateHelperClass::render(array(
        'main' => $magictoolboxHTML,
        'thumbs' => $additionalImages,
        'magicscrollOptions' => $scrollToolObj ? $scrollToolObj->params->serialize(false, '', 'product-magicscroll-options') : '',
        'pid' => $productsId,
    ));
}


if(empty($magictoolboxHTML)) {
    return false;
}

$magictoolboxAdditionalImagesView = $tool;

if($toolObj->params->checkValue('switch-attributes-images', 'Yes') && isset($products_options_names)) {

    $mt_product_options_images = array();
    $mt_default_option_image = array();
    $mt_options_names = htmlspecialchars_decode($toolObj->params->getValue('options-names'));
    $mt_options_names = preg_replace('#\s*,\s*+#', ',', trim($mt_options_names));
    $mt_options_names = explode(',', $mt_options_names);

    $mt_row_number = 0;
    $mt_row_count = $products_options_names->RecordCount();
    while($mt_row_number < $mt_row_count) {
        $products_options_names->Move($mt_row_number);
        switch($products_options_names->fields['products_options_type']) {
            case PRODUCTS_OPTIONS_TYPE_TEXT:
            case PRODUCTS_OPTIONS_TYPE_FILE:
            case PRODUCTS_OPTIONS_TYPE_CHECKBOX:
                break;
            case PRODUCTS_OPTIONS_TYPE_RADIO:
            default://DROPDOWN
                if(!in_array($products_options_names->fields['products_options_name'], $mt_options_names)) break;
                $mt_product_options_images[$products_options_names->fields['products_options_id']] = array();
                $mt_product_options = $db->Execute(
                    "select pov.products_options_values_id, pov.products_options_values_name, ".
                    "pa.attributes_default, pa.attributes_image ".
                    "from ".TABLE_PRODUCTS_ATTRIBUTES." as pa, ".TABLE_PRODUCTS_OPTIONS_VALUES." as pov ".
                    "where pa.products_id = '".$productsId."' ".
                    "and pa.options_id = '".(int)$products_options_names->fields['products_options_id']."' ".
                    "and pa.options_values_id = pov.products_options_values_id ".
                    "and pov.language_id = '".(int)$_SESSION['languages_id']."' "
                );
                while(!$mt_product_options->EOF) {
                    if(!empty($mt_product_options->fields['attributes_image'])) {
                        $mt_attribute_image = DIR_WS_IMAGES.$mt_product_options->fields['attributes_image'];
                        $mt_product_options_images[$products_options_names->fields['products_options_id']][$mt_product_options->fields['products_options_values_id']] = array(
                            //'name' => $mt_product_options->fields['products_options_values_name'],
                            'img' => DIR_WS_CATALOG.magicthumbGetThumb($mt_attribute_image, 'original', $productsId.'attributes'),
                            'thumb' => DIR_WS_CATALOG.magicthumbGetThumb($mt_attribute_image, 'thumb', $productsId.'attributes'),
                        );
                        //if($mt_product_options->fields['attributes_default']) {
                        //    $mt_default_option_image = $mt_product_options_images[$products_options_names->fields['products_options_id']][$mt_product_options->fields['products_options_values_id']];
                        //}
                    } else if($mt_product_options->fields['attributes_default']) {
                        $mt_product_options_images[$products_options_names->fields['products_options_id']][$mt_product_options->fields['products_options_values_id']] = array(
                            //'name' => $mt_product_options->fields['products_options_values_name'],
                            'img' => DIR_WS_CATALOG.magicthumbGetThumb($image, 'original', $productsId),
                            'thumb' => DIR_WS_CATALOG.magicthumbGetThumb($image, 'thumb', $productsId),
                        );
                    }
                    $mt_product_options->MoveNext();
                }
                break;
        }
        $mt_row_number++;
    }

    if(!empty($mt_product_options_images)) {

        //NOTE: cut images
        foreach($options_name as $mt_index => $mt_option_name) {
            $mt_option_name = preg_replace('#<label\b[^>]*>([^<]*)</label>#', '$1', $mt_option_name);
            if(in_array($mt_option_name, $mt_options_names)) {
                unset($options_attributes_image[$mt_index]);
            }
        }

        $magictoolboxHTML .= "
<script type=\"text/javascript\">
var tool_id = 'MagicThumbImageproduct{$productsId}';
var product_options_images = ".json_encode($mt_product_options_images).";
//var default_option_image = ".json_encode($mt_default_option_image).";
var magicAddEventMethod = 'jAddEvent';
\$mjs(window)[magicAddEventMethod]('load', function() {
    for(var x in product_options_images) {
        var elements = document.getElementsByName('id['+x+']');
        for(var i = 0; i < elements.length; i++) {
            \$mjs(elements[i])[magicAddEventMethod]('change', function(e) {
                var objThis = e.target || e.srcElement;
                var options_id = objThis.name.replace(/id\[|\]/g, '');
                if(typeof(product_options_images[options_id]) != 'undefined' && typeof(product_options_images[options_id][objThis.value]) != 'undefined') {
                    MagicThumb.update(tool_id, product_options_images[options_id][objThis.value]['img'], product_options_images[options_id][objThis.value]['thumb']);
                    //product_options_images[options_id][objThis.value]['name']
                    var magic360Container = document.getElementById('magic360Container{$productsId}');
                    if(magic360Container && magic360Container.style.display != 'none') {
                        var mainImageContainer = document.getElementById('mainImageContainer{$productsId}');
                        setTimeout(function() {
                            //NOTE: only on page load (first time)
                            if(mainImageContainer.style.position == 'absolute') {
                                mainImageContainer.style.width = 'auto';
                                mainImageContainer.style.height = 'auto';
                                mainImageContainer.style.position = 'static';
                            }
                            magic360Container.style.display = 'none';
                            mainImageContainer.style.display = 'block';
                        }, switchDelay);
                    }
                }
            });
        }
    }
    //if(typeof(default_option_image['img']) != 'undefined') {
    //    MagicThumb.update(tool_id, default_option_image['img'], default_option_image['thumb']);
    //}
});
</script>
";
    }

}
