<?php
/**
 * Main Product Image Template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

$pathToOriginalFile = dirname(__FILE__).MT_DS.'tpl_modules_main_product_image_original.php';
if(!file_exists($pathToOriginalFile)) {
    $pathToOriginalFile = MT_FS_TEMPLATES.MT_DS.'template_default'.MT_DS.'templates'.MT_DS.'tpl_modules_main_product_image.php';
}

$productsId = isset($_REQUEST['products_id']) ? $_REQUEST['products_id'] : $_GET['products_id'];
if(empty($productsId)) $productsId = null;

$image = magictoolboxGetImagePath($products_image, $productsId);
if(empty($image) || !file_exists(DIR_FS_CATALOG.$image)) {
    define('ADDITIONAL_IMAGES_DEFAULT_VIEW', true);
    include($pathToOriginalFile);
    return;
}

$productsTitle = $current_page_base == 'product_reviews' ? $products_name_reviews_page : $products_name;


if(isset($magictoolbox['magic360'])) {
    unset($magictoolbox['magic360']);
    $magictoolbox = array_reverse($magictoolbox);
    $magictoolbox['magic360'] = 'Magic360';
    $magictoolbox = array_reverse($magictoolbox);
}

$magictoolboxHTML = '';
$cooperativeMode = false;
$magic360Icon = '';
$productHasImage = ($products_image != PRODUCTS_IMAGE_NO_IMAGE);
$magictoolboxAdditionalImagesView = '';

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile('product');
    $isModuleEnabled = !$toolObj->params->checkValue('enable-effect', 'No');
    if($isModuleEnabled && ($productHasImage || $toolObj->type == 'circle') && (empty($magictoolboxHTML) || $cooperativeMode && $toolObj->type == 'standard')) {
        $isModuleEnabled = include(dirname(__FILE__).MT_DS.'tpl_modules_'.$tool.'.php');
        //if($cooperativeMode) continue;
        if($isModuleEnabled && !$cooperativeMode) break;
    }
}

//if(!$isModuleEnabled) {
if(empty($magictoolboxHTML)) {
    define('ADDITIONAL_IMAGES_DEFAULT_VIEW', true);
    include($pathToOriginalFile);
} else {
    require(DIR_WS_MODULES.zen_get_module_directory(FILENAME_MAIN_PRODUCT_IMAGE));
    echo '<div id="productMainImage" class="centeredContent back">'.$magictoolboxHTML.'</div>';
    define('ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW', $magictoolboxAdditionalImagesView);
}
