<?php
/**
 *
 * Prepares list of new products to be displayed in template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

if(!defined('IS_ADMIN_FLAG')) die('Illegal Access');

$pathToOriginalFile = dirname(__FILE__).MT_DS.'new_products_original.php';
if(!file_exists($pathToOriginalFile)) {
    $pathToOriginalFile = MT_FS_MODULES.MT_DS.'new_products.php';
}

require_once($pathToOriginalFile);

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile('new_products');
    $isModuleEnabled = in_array($toolObj->type, array('standard', 'category')) && !$toolObj->params->checkValue('enable-effect', 'No');
    if($isModuleEnabled) break;
}

if(!($isModuleEnabled && $num_products_count)) return;

$productsDescription = array();
$rowNumber = 0;
while($rowNumber < $num_products_count) {
    $new_products->Move($rowNumber);
    $productsDescription[$new_products->fields['products_id']] = zen_clean_html(stripslashes(zen_get_products_description($new_products->fields['products_id'], $_SESSION['languages_id'])));
    $rowNumber++;
}

$getThumbFunc = $tool.'GetThumb';
$magictoolboxItems = array();//NOTE: for magicslideshow/magicscroll

foreach($list_box_contents as $rowkey => $row) {

    foreach($row as $key => $arr) {

        $text = $arr['text'];

        $imgOrig = preg_replace("/^.*?<img[^>]*src=\"(.*?)\".*$/is", "$1", $text);
        if($imgOrig == $text || preg_match('/buy.now/is', $imgOrig)) {
            continue;
        }

        $aHref = preg_replace("/^.*?<a[^>]*href=\"(.*?)\".*$/is", "$1", $text);
        $pid = preg_replace("/^.*?products_id=(\d+)(?:\D.*)?$/is", "$1", $aHref);

        //NOTE: fix for 'Ceon URI Mapping' + 'Image Handler 4' (#59000)
        if(!is_numeric($pid) && defined('TABLE_CEON_URI_MAPPINGS')) {
            $result = $db->Execute('SELECT associated_db_id FROM '.TABLE_CEON_URI_MAPPINGS.' WHERE uri = "'.str_replace(HTTP_SERVER, '', str_replace(HTTPS_SERVER, '', $aHref)).'"');
            if(!$result->EOF) {
                if(!empty($result->fields['associated_db_id'])) {
                    $pid = $result->fields['associated_db_id'];
                }
            }
        }

        $link = '';
        if($toolObj->params->checkValue('link-to-product-page', 'Yes')) {
            $link = $aHref;
        }

        $_title = preg_replace("/^.*?<img[^>]*title=\"(.*?)\".*$/is", "$1", $text);
        if($_title == $text) $_title = preg_replace("/^.*?<img[^>]*alt=\"(.*?)\".*$/is", "$1", $text);
        if($_title == $text) $_title = '';

        if($pid == $aHref) $pid = null;

        $img = magictoolboxGetImagePath($imgOrig, $pid);

        $thumb = DIR_WS_CATALOG.$getThumbFunc($img, 'thumb', $pid);

        switch($toolObj->type) {
            case 'standard':
                $img = DIR_WS_CATALOG.$getThumbFunc($img, 'original', $pid);
                $text = $toolObj->getMainTemplate(array(
                    'id' => 'new_products'.$pid,
                    'group' => 'new_products',
                    'img' => $img,
                    'thumb' => $thumb,
                    'title' => $_title,
                    'description' => empty($productsDescription[$pid]) ? '' : $productsDescription[$pid],
                    'link' => $link
                ));
                $arr['text'] = preg_replace('/<a[^>]+><img[^>]+?src=\"'.preg_quote($imgOrig, '/').'\"[^>]+><\/a>/is', $text, $arr['text']);
                $list_box_contents[$rowkey][$key] = $arr;
                break;
            case 'category':
                switch($tool) {
                    case 'magicslideshow':
                        $selector = DIR_WS_CATALOG.$getThumbFunc($img, 'selector', $pid);
                        $img = DIR_WS_CATALOG.$getThumbFunc($img, 'original', $pid);
                        $magictoolboxItems[] = array(
                            'img' => $thumb,
                            'thumb' => $selector,
                            'fullscreen' => $img,
                            'title' => $_title,
                            'link' => $link
                        );
                        break;
                    case 'magicscroll':
                        $magictoolboxItems[] = array(
                            'img' => $thumb,
                            'title' => $_title,
                            'alt' => $_title,
                            'link' => $link
                        );
                        break;
                }
            break;
        }

    }

}

/* NOTE: for magicslideshow/magicscroll */
if(count($magictoolboxItems)) {
    $list_box_contents = array(array(array(
        'params' => 'class="centeredContent" style="width:100%;"',
        'text' => $toolObj->getMainTemplate($magictoolboxItems, array('id' => 'new_products'.$toolId))
    )));
}
