<?php

    require('includes/application_top.php');

    ini_set('display_errors', true);
    error_reporting(E_ALL & ~E_NOTICE);

    $result = $db->Execute("SHOW TABLES LIKE '".DB_PREFIX."magicslideshow_configuration'");
    if($result->EOF) {
        die('Magic Slideshow settings does not exist! Make sure that the module is installed correctly.');
    }

    defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);
    defined('MT_FS_ROOT') || define('MT_FS_ROOT', dirname(dirname(__FILE__)).MT_DS);//DIR_FS_CATALOG
    defined('MT_WS_ROOT') || define('MT_WS_ROOT', preg_replace('#[^/]+/$#', '', DIR_WS_ADMIN));//DIR_WS_CATALOG
    defined('MT_FS_ADMIN') || define('MT_FS_ADMIN', dirname(__FILE__).MT_DS);//DIR_FS_ADMIN
    defined('MT_FS_CATALOG_TEMPLATES') || define('MT_FS_CATALOG_TEMPLATES', MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS);//DIR_FS_CATALOG_TEMPLATES

    $imageBasePath = MT_FS_ROOT.'images'.MT_DS.'magicslideshow'.MT_DS;

    $action = isset($_POST['magicslideshow-submit-action']) ? $_POST['magicslideshow-submit-action'] : false;
    $activeTab = isset($_POST['magicslideshow-active-tab']) ? $_POST['magicslideshow-active-tab'] : false;

    if($_SERVER['REQUEST_METHOD'] == 'POST') {
        switch($action) {
            case 'save':
                if(isset($_POST['magictoolbox']) && is_array($_POST['magictoolbox'])) {
                    $db->Execute("UPDATE `".DB_PREFIX."magicslideshow_configuration` SET `enabled` = 0 WHERE `block` != 'default'");
                    foreach($_POST['magictoolbox'] as $block => $params) {
                        if(!is_array($params)) continue;
                        foreach($params as $id => $value) {
                            $value = zen_db_input($value);
                            $db->Execute("UPDATE `".DB_PREFIX."magicslideshow_configuration` SET `value` = '{$value}', `enabled` = 1 WHERE `block` = '{$block}' AND `name` = '{$id}'");
                        }
                    }
                }
                if(isset($_POST['images-update-data']) && is_array($_POST['images-update-data'])) {
                    is_dir($imageBasePath) || mkdir($imageBasePath);
                    foreach($_POST['images-update-data'] as $imageId => $imageData) {
                        if((int)$imageData['delete']) {
                            if(!empty($imageData['name'])) @unlink($imageBasePath.$imageData['name']);
                            $db->Execute("DELETE FROM `".DB_PREFIX."magicslideshow_images` WHERE `id` = {$imageId}");
                        } else {
                            $imageData['title'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['title']);
                            $imageData['description'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['description']);
                            //$imageData['description'] = addslashes($imageData['description']);
                            $imageData['link'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['link']);
                            $imageData['order'] = intval($imageData['order']);
                            $imageData['exclude'] = isset($imageData['exclude']) ? 1 : 0;
                            $db->Execute("UPDATE `".DB_PREFIX."magicslideshow_images` SET `title` = '{$imageData['title']}', `description` = '{$imageData['description']}', `link` = '{$imageData['link']}', `image_order` = {$imageData['order']}, `exclude` = {$imageData['exclude']} WHERE `id` = {$imageId}");
                        }
                    }
                }
                break;
            case 'reset':
                $db->Execute("UPDATE `".DB_PREFIX."magicslideshow_configuration` SET `value` = `default_value`, `enabled`=`default_enabled` WHERE `block`='{$activeTab}'");
                break;
            case 'upload':
                if(isset($_FILES['magicslideshow-image-files']['tmp_name']) && is_array($_FILES['magicslideshow-image-files']['tmp_name'])) {
                    is_dir($imageBasePath) || mkdir($imageBasePath);
                    foreach($_FILES['magicslideshow-image-files']['tmp_name'] as $key => $tempName) {
                        if(!empty($tempName) && file_exists($tempName)) {
                            $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicslideshow-image-files']['name'][$key]);
                            $ext = substr($name, strrpos($name, '.'));
                            $name = substr($name, 0, -strlen($ext));
                            $index = 0;
                            $suffix = '';
                            while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                                $suffix = "({$index})";
                                $index++;
                            }
                            if(move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                                $db->Execute("INSERT INTO `".DB_PREFIX."magicslideshow_images` (`name`, `title`, `description`, `link`, `image_order`, `exclude`) VALUES ('{$name}{$suffix}{$ext}', '', '', '', 0, 0)");
                            }
                        }
                    }
                }
            default :
        }
    }

    require(MT_FS_ROOT.preg_replace('/\/|\\\\/', MT_DS, DIR_WS_MODULES).'magicslideshow'.MT_DS.'functions.php');
    $tool = magicslideshowGetTool();
    $params = $tool->params;
    $homeslideshowData = array();
    $result = $db->Execute("SELECT * FROM `".DB_PREFIX."magicslideshow_images` ORDER BY `image_order`");
    while(!$result->EOF) {
        $homeslideshowData[] = array(
            'id' => $result->fields['id'],
            'name' => $result->fields['name'],
            'title' => $result->fields['title'],
            'description' => $result->fields['description'],
            'link' => $result->fields['link'],
            'order' => $result->fields['image_order'],
            'exclude' => $result->fields['exclude'],
        );
        $result->MoveNext();
    }

    $blocks = array(
		'default' => 'General',
		'homeslideshow' => 'Home page Slideshow',
		'product' => 'Product page',
		'new_products' => 'New Products block',
		'whats_new' => 'New Products sidebar',
		'specials' => 'Specials sidebar',
		'featured' => 'Featured sidebar',
	);
    $map = array(
		'default' => array(
			'Positioning and Geometry' => array(
				'thumb-max-width' => true,
				'thumb-max-height' => true,
				'selector-max-width' => true,
				'selector-max-height' => true,
				'square-images' => true,
			),
			'Common settings' => array(
				'width' => true,
				'height' => true,
				'orientation' => true,
				'arrows' => true,
				'loop' => true,
				'effect' => true,
				'effect-speed' => true,
				'effect-easing' => true,
			),
			'Autoplay' => array(
				'autoplay' => true,
				'slide-duration' => true,
				'shuffle' => true,
				'kenburns' => true,
				'pause' => true,
			),
			'Selectors' => array(
				'selectors-style' => true,
				'selectors' => true,
				'selectors-eye' => true,
				'bullets-preview' => true,
				'selectors-fill' => true,
			),
			'Caption' => array(
				'caption' => true,
			),
			'Other settings' => array(
				'fullscreen' => true,
				'preload' => true,
				'keyboard' => true,
				'show-loader' => true,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => true,
				'show-message' => true,
				'message' => true,
				'imagemagick' => true,
				'image-quality' => true,
			),
			'Watermark' => array(
				'watermark' => true,
				'watermark-max-width' => true,
				'watermark-max-height' => true,
				'watermark-opacity' => true,
				'watermark-position' => true,
				'watermark-offset-x' => true,
				'watermark-offset-y' => true,
			),
		),
		'homeslideshow' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Setup slideshow for home page' => array(
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'show-message' => false,
				'message' => false,
			),
		),
		'new_products' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
		),
		'whats_new' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
		),
		'specials' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
		),
		'featured' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
				'selector-max-width' => false,
				'selector-max-height' => false,
			),
			'Common settings' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'arrows' => false,
				'loop' => false,
				'effect' => false,
				'effect-speed' => false,
				'effect-easing' => false,
			),
			'Autoplay' => array(
				'autoplay' => false,
				'slide-duration' => false,
				'shuffle' => false,
				'kenburns' => false,
				'pause' => false,
			),
			'Selectors' => array(
				'selectors-style' => false,
				'selectors' => false,
				'selectors-eye' => false,
				'bullets-preview' => false,
				'selectors-fill' => false,
			),
			'Caption' => array(
				'caption' => false,
			),
			'Other settings' => array(
				'fullscreen' => false,
				'preload' => false,
				'keyboard' => false,
				'show-loader' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
				'show-message' => false,
				'message' => false,
			),
		),
	);

    $template_mt = 'classic';
    $templates = array();
    //NOTE: used templates
    //$result = $db->Execute("SELECT * FROM ".TABLE_TEMPLATE_SELECT);
    //NOTE: all templates (with module installed)
    if(file_exists(MT_FS_CATALOG_TEMPLATES)) {
        $templatesDir = dir(MT_FS_CATALOG_TEMPLATES);
        if($templatesDir) {
            while($file = $templatesDir->read()) {
                if(file_exists(MT_FS_CATALOG_TEMPLATES.$file.MT_DS.'jscript'.MT_DS.'magicslideshow.js')) {
                    $templates[] = $file;
                }
            }
            $templatesDir->close();
        }
    }
    //TODO: add support multiple templates
    if(count($templates) == 1) $template_mt = $templates[0];

    include(MT_FS_ADMIN.'includes'.MT_DS.'magicslideshow'.MT_DS.'magictoolbox.settings.editor.class.php');
    $settings = new MagictoolboxSettingsEditorClass(MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript');
    $settings->paramsMap = &$map;
    $settings->core = &$tool;
    $settings->profiles = &$blocks;
    $settings->pathToJS = MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript';
    $settings->action = htmlentities($_SERVER['REQUEST_URI']);
    $settings->setResourcesURL(DIR_WS_ADMIN.'includes/magicslideshow/resources/');
    $settings->jQueryNoConflictLevel(0);
    $settings->customSlideshowProfileId = 'homeslideshow';
    $settings->customSlideshowGroupTitle = 'Setup slideshow for home page';
    $settings->imageBaseUrl = MT_WS_ROOT.'images/magicslideshow/';
    $settings->customSlideshowImagesData = &$homeslideshowData;
    $html = $settings->getHTML();
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript">
<!--
function popupHelpWindow(url) {
    window.open(url,'popupImageWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
}
function init() {
    cssjsmenu('navbar');
    if(document.getElementById) {
        var kill = document.getElementById('hoverJS');
        kill.disabled = true;
    }
}
// -->
</script>
<style type="text/css"></style>
</head>
<body onLoad="init()" >
<?php require(DIR_WS_INCLUDES.'header.php'); ?>
<?php echo $settings->getHTML(); ?>
<?php require(DIR_WS_INCLUDES.'footer.php'); ?>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>
<?php require(DIR_WS_INCLUDES.'application_bottom.php'); ?>
