<?php
/**
 *
 * Display headers
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

if(!isset($GLOBALS['magictoolbox'])) return;

$currentPage = isset($_REQUEST['main_page']) ? $_REQUEST['main_page'] : ( isset($_GET['main_page']) ? $_GET['main_page'] : '');
switch($currentPage) {
    case 'index':
        $cPath = isset($_REQUEST['cPath']) ? $_REQUEST['cPath'] : ( isset($_GET['cPath']) ? $_GET['cPath'] : '' );
        $currentPage = empty($cPath) ? 'homeslideshow' : 'category';
        break;
    case 'product_info':
    case 'product_reviews':
    case 'product_reviews_info':
    case 'product_reviews_write':    
        //$productsId = isset($_REQUEST['products_id']) ? $_REQUEST['products_id'] : $_GET['products_id'];
        $currentPage = 'product';
        break;
    case 'advanced_search_result':
        $currentPage = 'search';
        break;
}

$magictoolboxHeaders = array(
    'magicthumb' => '',
    'magic360' => '',
    'magiczoom' => '',
    'magiczoomplus' => '',
    'magicscroll' => '',
    'magicslideshow' => '',
);

foreach($GLOBALS['magictoolbox'] as $tool => $toolId) {
    $getToolFunc = $tool.'GetTool';
    $toolObj = $getToolFunc();
    $toolObj->params->setProfile('default');
    $isModuleEnabled = $toolObj->params->profileExists($currentPage) && !$toolObj->params->checkValue('enable-effect', 'No', $currentPage) ||
                       $toolObj->params->profileExists('whats_new') && !$toolObj->params->checkValue('enable-effect', 'No', 'whats_new') ||
                       $toolObj->params->profileExists('featured') && !$toolObj->params->checkValue('enable-effect', 'No', 'featured') ||
                       $toolObj->params->profileExists('specials') && !$toolObj->params->checkValue('enable-effect', 'No', 'specials') ||
                       $toolObj->params->profileExists('new_products') && !$toolObj->params->checkValue('enable-effect', 'No', 'new_products');
    if(!$isModuleEnabled) continue;
    if(empty($magictoolboxHeaders[$tool])) {//NOTE: to not replace magicscroll headers with separate magicscroll module
        $magictoolboxHeaders[$tool] = $toolObj->getHeadersTemplate(DIR_WS_CATALOG.DIR_WS_TEMPLATE.'jscript', DIR_WS_CATALOG.DIR_WS_TEMPLATE.'css/'.$tool);
    }
    if($currentPage == 'product' && $toolObj->type == 'standard' && $toolObj->params->checkValue('magicscroll', 'Yes', 'product') && !$toolObj->params->checkValue('template', 'original', 'product')) {
        $scrollToolObj = $getToolFunc(true);
        $scrollToolObj->params->resetProfile();
        $magictoolboxHeaders['magicscroll'] = $scrollToolObj->getHeadersTemplate(DIR_WS_CATALOG.DIR_WS_TEMPLATE.'jscript', DIR_WS_CATALOG.DIR_WS_TEMPLATE.'css/'.$tool, false);
    }
}

echo implode("\n", $magictoolboxHeaders);
