<?php

//ini_set('display_errors', false);
//error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);

function magicscrollGetTool($scroll = false) {
    static $mainTool = null;
    static $scrollTool = null;
    if($mainTool == null) {
        require_once(dirname(__FILE__).MT_DS.'magicscroll.module.core.class.php');
        $mainTool = new MagicScrollModuleCoreClass();
        global $db;
        $result = $db->Execute('SHOW TABLES LIKE \''.DB_PREFIX.'magicscroll_configuration\'');
        if(!$result->EOF) {
            $result = $db->Execute('SELECT * FROM `'.DB_PREFIX.'magicscroll_configuration` WHERE `enabled` = 1');
            while(!$result->EOF) {
                $mainTool->params->setValue($result->fields['name'], $result->fields['value'], $result->fields['block']);
                $result->MoveNext();
            }
        }

    }
    return $scroll ? $scrollTool: $mainTool;
}

function magicscrollGetThumb($image, $type, $pid = null) {
    static $imagehelper = null;
    if($imagehelper == null) {
        $tool = magicscrollGetTool();
        require_once(dirname(__FILE__).MT_DS.'magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_FS_CATALOG, '/'.DIR_WS_IMAGES.'magictoolbox_cache', $tool->params);
    }
    return preg_replace('/^\//is', '', $imagehelper->create('/'.$image, $type, $pid));
}

if(!function_exists('magictoolboxGetImagePath')) {
    function magictoolboxGetImagePath($image, $pid = null) {

        //Image Handler 2, 3
        if(strpos($image, 'bmz_cache') !== false) {
            if($pid !== null) {
                global $db;
                //$result = $db->Execute('SELECT products_image FROM '.DB_PREFIX.'products WHERE products_id = '.$pid);
                $result = $db->Execute('SELECT products_image FROM '.TABLE_PRODUCTS.' WHERE products_id = '.$pid);
                if(!$result->EOF) {
                    $image = $result->fields['products_image'];
                } else {
                    return $image;
                }
            } else {
                return $image;
            }
        }

        if(empty($image)) return '';
        $image = str_replace('%20', ' ', $image);
        $image = str_replace(DIR_FS_CATALOG.DIR_WS_IMAGES, '', $image);
        $image = preg_replace('/^\/?'.preg_quote(DIR_WS_IMAGES, '/').'/is', '', $image);
        $info = pathinfo($image);
        if(intval(phpversion()) < 5 || !isset($info['filename'])) {
            $info['filename'] = basename($info['basename'], '.'.$info['extension']);
        }
        if($info['dirname'] == '.') $info['dirname'] = '';
        if(!empty($info['dirname'])) $info['dirname'] .= '/';
        $large_image = 'large/'.$info['dirname'].$info['filename'].IMAGE_SUFFIX_LARGE.'.'.$info['extension'];
        if(!file_exists(DIR_FS_CATALOG.DIR_WS_IMAGES.$large_image)) {
            $large_image = 'medium/'.$info['dirname'].$info['filename'].IMAGE_SUFFIX_MEDIUM.'.'.$info['extension'];
            if(!file_exists(DIR_FS_CATALOG.DIR_WS_IMAGES.$large_image)) {
                $large_image = $info['dirname'].$info['filename'].'.'.$info['extension'];
            }
        }
        return DIR_WS_IMAGES.$large_image;
    }

    function magictoolboxGetAdditionalImages($productsImage, $productsId) {
        static $additionalImages = null;
        /*
            images/
                .....
                imageName.extension - base
                imageName**.extension - additional
                large/imageName**_LRG.extension - large images
                medium/imageName**_MED.extension - medium images

                subdir/
                    ......
                    imageName.extension - base
                    imageName_**.extension - additional

        */
        if($additionalImages == null) {
            $additionalImages = array();
            $info = pathinfo(str_replace('%20', ' ', $productsImage));
            if(intval(phpversion()) < 5 || !isset($info['filename'])) {
                $info['filename'] = basename($info['basename'], '.'.$info['extension']);
            }
            if($info['dirname'] == '.') {
                $info['dirname'] = '';
                $delimiter = '';
            } else {
                //NOTICE: if using SUBDIRECTORIES such as /images/mystuff then you need the underscore ( _ )
                $delimiter = '_';
            }
            if(!empty($info['dirname'])) $info['dirname'] .= '/';
            $images = glob(DIR_FS_CATALOG.DIR_WS_IMAGES.$info['dirname'].$info['filename'].$delimiter.'*.'.$info['extension']);
            if($delimiter) {
                //NOTE: add main image
                if(is_array($images)) {
                    array_unshift($images, DIR_FS_CATALOG.DIR_WS_IMAGES.$info['dirname'].$info['filename'].'.'.$info['extension']);
                } else {
                    $images = array(DIR_FS_CATALOG.DIR_WS_IMAGES.$info['dirname'].$info['filename'].'.'.$info['extension']);
                }
            }
            if($images !== false && count($images) > 0) {
                sort($images);
                foreach($images as $image) {
                    $additionalImages[] = array(
                        'main' => $image == DIR_FS_CATALOG.DIR_WS_IMAGES.$info['dirname'].$info['filename'].'.'.$info['extension'],
                        'path' => magictoolboxGetImagePath($image, $productsId),
                    );
                }
            }
        }
        return $additionalImages;
    }
}
