-- create config table
DROP TABLE IF EXISTS magic360_configuration;
CREATE TABLE magic360_configuration (
    `id` int unsigned NOT NULL auto_increment,
    `block` varchar(32) NOT NULL,
    `name` varchar(32) NOT NULL,
    `value` text,
    `default_value` text,
    `enabled` tinyint(1) unsigned NOT NULL,
    `default_enabled` tinyint(1) unsigned NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- defaut config
INSERT INTO magic360_configuration (`block`, `name`, `value`, `default_value`, `enabled`, `default_enabled`) VALUES 
 ('default', 'magnify', 'Yes', 'Yes', 1, 1),
 ('default', 'magnifier-width', '80%', '80%', 1, 1),
 ('default', 'magnifier-shape', 'inner', 'inner', 1, 1),
 ('default', 'fullscreen', 'Yes', 'Yes', 1, 1),
 ('default', 'spin', 'drag', 'drag', 1, 1),
 ('default', 'autospin-direction', 'clockwise', 'clockwise', 1, 1),
 ('default', 'sensitivityX', '50', '50', 1, 1),
 ('default', 'sensitivityY', '50', '50', 1, 1),
 ('default', 'mousewheel-step', '1', '1', 1, 1),
 ('default', 'autospin-speed', '3600', '3600', 1, 1),
 ('default', 'smoothing', 'Yes', 'Yes', 1, 1),
 ('default', 'autospin', 'once', 'once', 1, 1),
 ('default', 'autospin-start', 'load,hover', 'load,hover', 1, 1),
 ('default', 'autospin-stop', 'click', 'click', 1, 1),
 ('default', 'initialize-on', 'load', 'load', 1, 1),
 ('default', 'start-column', '1', '1', 1, 1),
 ('default', 'start-row', 'auto', 'auto', 1, 1),
 ('default', 'loop-column', 'Yes', 'Yes', 1, 1),
 ('default', 'loop-row', 'No', 'No', 1, 1),
 ('default', 'reverse-column', 'No', 'No', 1, 1),
 ('default', 'reverse-row', 'No', 'No', 1, 1),
 ('default', 'column-increment', '1', '1', 1, 1),
 ('default', 'row-increment', '1', '1', 1, 1),
 ('default', 'thumb-max-width', '250', '250', 1, 1),
 ('default', 'thumb-max-height', '250', '250', 1, 1),
 ('default', 'square-images', 'disable', 'disable', 1, 1),
 ('default', 'show-message', 'Yes', 'Yes', 1, 1),
 ('default', 'message', 'Drag image to spin', 'Drag image to spin', 1, 1),
 ('default', 'loading-text', 'Loading...', 'Loading...', 1, 1),
 ('default', 'fullscreen-loading-text', 'Loading large spin...', 'Loading large spin...', 1, 1),
 ('default', 'hint', 'Yes', 'Yes', 1, 1),
 ('default', 'hint-text', 'Drag to spin', 'Drag to spin', 1, 1),
 ('default', 'mobile-hint-text', 'Swipe to spin', 'Swipe to spin', 1, 1),
 ('default', 'imagemagick', 'off', 'off', 1, 1),
 ('default', 'image-quality', '75', '75', 1, 1),
 ('default', 'icon', 'images/360icon.png', 'images/360icon.png', 1, 1),
 ('default', 'watermark', '', '', 1, 1),
 ('default', 'watermark-max-width', '30%', '30%', 1, 1),
 ('default', 'watermark-max-height', '30%', '30%', 1, 1),
 ('default', 'watermark-opacity', '50', '50', 1, 1),
 ('default', 'watermark-position', 'center', 'center', 1, 1),
 ('default', 'watermark-offset-x', '0', '0', 1, 1),
 ('default', 'watermark-offset-y', '0', '0', 1, 1),
 ('product', 'enable-effect', 'Yes', 'Yes', 1, 1),
 ('product', 'magnify', 'Yes', 'Yes', 0, 0),
 ('product', 'magnifier-width', '80%', '80%', 0, 0),
 ('product', 'magnifier-shape', 'inner', 'inner', 0, 0),
 ('product', 'fullscreen', 'Yes', 'Yes', 0, 0),
 ('product', 'spin', 'drag', 'drag', 0, 0),
 ('product', 'autospin-direction', 'clockwise', 'clockwise', 0, 0),
 ('product', 'sensitivityX', '50', '50', 0, 0),
 ('product', 'sensitivityY', '50', '50', 0, 0),
 ('product', 'mousewheel-step', '1', '1', 0, 0),
 ('product', 'autospin-speed', '3600', '3600', 0, 0),
 ('product', 'smoothing', 'Yes', 'Yes', 0, 0),
 ('product', 'autospin', 'once', 'once', 0, 0),
 ('product', 'autospin-start', 'load,hover', 'load,hover', 0, 0),
 ('product', 'autospin-stop', 'click', 'click', 0, 0),
 ('product', 'initialize-on', 'load', 'load', 0, 0),
 ('product', 'start-column', '1', '1', 0, 0),
 ('product', 'start-row', 'auto', 'auto', 0, 0),
 ('product', 'loop-column', 'Yes', 'Yes', 0, 0),
 ('product', 'loop-row', 'No', 'No', 0, 0),
 ('product', 'reverse-column', 'No', 'No', 0, 0),
 ('product', 'reverse-row', 'No', 'No', 0, 0),
 ('product', 'column-increment', '1', '1', 0, 0),
 ('product', 'row-increment', '1', '1', 0, 0),
 ('product', 'thumb-max-width', '200', '200', 1, 1),
 ('product', 'thumb-max-height', '200', '200', 1, 1),
 ('product', 'show-message', 'Yes', 'Yes', 0, 0),
 ('product', 'message', 'Drag image to spin', 'Drag image to spin', 0, 0),
 ('product', 'loading-text', 'Loading...', 'Loading...', 0, 0),
 ('product', 'fullscreen-loading-text', 'Loading large spin...', 'Loading large spin...', 0, 0),
 ('product', 'hint', 'Yes', 'Yes', 0, 0),
 ('product', 'hint-text', 'Drag to spin', 'Drag to spin', 0, 0),
 ('product', 'mobile-hint-text', 'Swipe to spin', 'Swipe to spin', 0, 0),
 ('product', 'icon', 'images/360icon.png', 'images/360icon.png', 0, 0),
 ('default', 'version', '4.6.17', '4.6.17', 1, 1);

-- create images table
CREATE TABLE IF NOT EXISTS magic360_images (
    `id` int(11) NOT NULL,
    `gallery` mediumtext,
    `columns` tinyint unsigned NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
