<?php
/**
 *
 * Prepares list of additional product images to be displayed in template
 *
 * @copyright Copyright 2013 Magic Toolbox <support@magictoolbox.com>.
 */

if(!defined('IS_ADMIN_FLAG')) die('Illegal Access');

$pathToOriginalFile = dirname(__FILE__).MT_DS.'additional_images_original.php';
if(!file_exists($pathToOriginalFile)) {
    $pathToOriginalFile = MT_FS_MODULES.MT_DS.'additional_images.php';
}

if(empty($products_image) || defined('ADDITIONAL_IMAGES_DEFAULT_VIEW') || !defined('ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW')) {
    require_once($pathToOriginalFile);
    return;
}

$productsId = isset($_REQUEST['products_id']) ? $_REQUEST['products_id'] : $_GET['products_id'];
if(empty($productsId)) $productsId = null;

$additionalImages = magictoolboxGetAdditionalImages($products_image, $productsId);
$additionalImagesCount = count($additionalImages);
if(!$additionalImagesCount) {
    require_once($pathToOriginalFile);
    return;
}

if(in_array(ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW, array('magicscroll', 'magicslideshow', 'magic360'))) {
    return;
}

$getToolFunc = ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW.'GetTool';
$toolObj = $getToolFunc();
$toolObj->params->setProfile('product');

if(!$toolObj->params->checkValue('template', 'original')) {
    return;
}

$productsTitle = empty($products_name) ? '' : $products_name;

$list_box_contents = array();
$num_images = $additionalImagesCount;
$title = '';
$selectorClasses = 'magicToolboxSelector';

if($additionalImagesCount > ($cooperativeMode ? 0 : 1)) {
    $row = $col = 0;
    if($additionalImagesCount < IMAGES_AUTO_ADDED || IMAGES_AUTO_ADDED == 0 ) {
        $col_width = floor(100/$additionalImagesCount);
    } else {
        $col_width = floor(100/IMAGES_AUTO_ADDED);
    }
    $getThumbFunc = ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW.'GetThumb';
    if($cooperativeMode && !empty($magic360Icon) && file_exists(DIR_FS_CATALOG.$magic360Icon)) {
        $magic360Icon = DIR_WS_CATALOG.$getThumbFunc($magic360Icon, 'selector', 'magic360icon');
        if(in_array(ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW, array('magiczoom', 'magiczoomplus'))) {
            $selectorClasses = 'magicToolboxSelector zoom-with-360';
        }
        $list_box_contents[$row][$col] = array(
            'params' => 'class="additionalImages centeredContent back" style="width:'.$col_width.'%;"',
            'text' => "\n      ".
                      '<a class="'.$selectorClasses.' m360-selector active-selector" title="360" href="#" onclick="return false;"><img src="'.$magic360Icon.'" alt="360" /></a>'
        );
        $col++;
        if($col > (IMAGES_AUTO_ADDED -1)) {
            $col = 0;
            $row++;
        }
    }
    foreach($additionalImages as $img) {
        if(ADDITIONAL_IMAGES_MAGICTOOLBOX_VIEW == 'magicthumb' && $img['main'] && $toolObj->params->checkValue('use-selectors', 'No')) continue;
        $link = $toolObj->getSelectorTemplate(array(
            'id' => 'product'.$productsId,
            'img' => DIR_WS_CATALOG.$getThumbFunc($img['path'], 'original', $productsId),
            'medium' => DIR_WS_CATALOG.$getThumbFunc($img['path'], 'thumb', $productsId),
            'thumb' => DIR_WS_CATALOG.$getThumbFunc($img['path'], 'selector', $productsId),
            'title' => $productsTitle
        ));
        $link = str_replace('<a ', '<a class="'.$selectorClasses.'" ', $link);
        $list_box_contents[$row][$col] = array(
            'params' => 'class="additionalImages centeredContent back" style="width:'.$col_width.'%;"',
            'text' => "\n      ".$link
        );
        $col++;
        if($col > (IMAGES_AUTO_ADDED -1)) {
            $col = 0;
            $row++;
        }
    }
}
