<?php

    require('includes/application_top.php');

    ini_set('display_errors', true);
    error_reporting(E_ALL & ~E_NOTICE);

    $result = $db->Execute("SHOW TABLES LIKE '".DB_PREFIX."magic360_images'");
    if($result->EOF) {
        die('Magic 360 images table does not exist! Make sure that the module is installed correctly.');
    }

    defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);
    defined('MT_FS_ROOT') || define('MT_FS_ROOT', dirname(dirname(__FILE__)).MT_DS);//DIR_FS_CATALOG
    defined('MT_WS_ROOT') || define('MT_WS_ROOT', preg_replace('#[^/]+/$#', '', DIR_WS_ADMIN));//DIR_WS_CATALOG

    $current_category_id = isset($_REQUEST['current_category_id']) ? (int)$_REQUEST['current_category_id'] : 0;
    $current_product_id = isset($_REQUEST['current_product_id']) ? (int)$_REQUEST['current_product_id'] : 0;

    $sql = 'select c.categories_id, c.parent_id, cd.categories_name from '.TABLE_CATEGORIES.' as c '.
           'left join '.TABLE_CATEGORIES_DESCRIPTION.' as cd on c.categories_id = cd.categories_id '.
           'where cd.language_id = \''.(int)$_SESSION['languages_id'].'\' '.
           'order by c.sort_order, cd.categories_name';
    $result = $db->Execute($sql);
    $categories_data = array();
    while(!$result->EOF) {
        $categories_data[$result->fields['categories_id']] = array(
            'parent_id' => $result->fields['parent_id'],
            'name' => $result->fields['categories_name'],
        );
        $result->MoveNext();
    }
    unset($categories_data['0']);
    $categories_menu = implode("\n", get_categories_menu_options('0', (string)$current_category_id));

    function get_categories_menu_options($parent_id = '0', $selected_id = '0', $indent = '') {
        global $categories_data;
        $categories_menu = array();
        foreach($categories_data as $id => $category) {
            //if($category['parent_id'] == $parent_id) {
            if(!empty($categories_data[$id]) && $category['parent_id'] == $parent_id) {
                //unset($categories_data[$id]);
                $categories_data[$id] = array();
                $menu = get_categories_menu_options($id, $selected_id, $indent.'&nbsp;&nbsp;');
                if(empty($menu)) {
                    $categories_menu[] = '<option value="'.$id.'"'.($selected_id == $id ? ' selected="selected"' : '').'>'.$indent.$category['name'].'</option>';
                } else {
                    $categories_menu[] = '<optgroup label="'.$indent.$category['name'].'"></optgroup>';
                }
                $categories_menu = array_merge($categories_menu, $menu);
            }
        }
        return $categories_menu;
    }

    $sql = 'select p.products_id, pd.products_name from '.TABLE_PRODUCTS.' as p '.
           'left join '.TABLE_PRODUCTS_TO_CATEGORIES.' as ptc on ptc.products_id = p.products_id, '.
           TABLE_PRODUCTS_DESCRIPTION.' as pd '.
           'where p.products_id = pd.products_id '.
           'and pd.language_id = \''.(int)$_SESSION['languages_id'].'\' '.
           'and ptc.categories_id = \''.$current_category_id.'\' '.
           'order by products_name';
    $result = $db->Execute($sql);
    $products_menu = array();
    while(!$result->EOF) {
        $products_menu[] = '<option value="'.$result->fields['products_id'].'"'.($current_product_id == (int)$result->fields['products_id'] ? ' selected="selected"' : '').'>'.$result->fields['products_name'].'</option>';
        $result->MoveNext();
    }
    $products_menu = implode("\n", $products_menu);

    $magic360Images = array();
    $magic360Columns = 0;
    $magic360Rows = 0;
    $multiRows = false;
    $insert = true;
    if($current_product_id) {
        $result = $db->Execute("SELECT * FROM `".DB_PREFIX."magic360_images` WHERE `id`={$current_product_id}");
        if(!$result->EOF) {
            if(!empty($result->fields['gallery'])) {
                $magic360Images = explode(';', $result->fields['gallery']);
                $magic360Columns = (int)$result->fields['columns'];
            }
            $insert = false;
        }
    }

    $imageBasePath = MT_FS_ROOT.'images'.MT_DS.'magic360'.MT_DS;
    $imageBaseUrl = MT_WS_ROOT.'images/magic360/';

    $updateDB = false;

    if($_SERVER['REQUEST_METHOD'] == 'POST') {
        switch($_POST['magictoolboxSubmitAction']) {
            case 'select':
                break;
            case 'upload':
                if(!empty($_FILES['magic360images']) && (is_dir($imageBasePath) || mkdir($imageBasePath))) {
                    $_magic360Columns = $magic360Columns;
                    $magic360ImagesCount = count($magic360Images);
                    foreach($_FILES['magic360images']['tmp_name'] as $key => $tempName) {
                        if(!empty($tempName) && file_exists($tempName)) {
                            $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magic360images']['name'][$key]);
                            $ext = substr($name, strrpos($name, '.'));
                            $name = substr($name, 0, -strlen($ext));
                            $index = 0;
                            $suffix = '';
                            while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                                $suffix = "({$index})";
                                $index++;
                            }
                            if(move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                                $magic360Images[] = $name.$suffix.$ext;
                                $_magic360Columns++;
                            }
                        }
                    }
                    if(!$magic360Columns || $magic360Columns == $magic360ImagesCount) {
                        $magic360Columns = $_magic360Columns;
                    }
                    $updateDB = true;
                }
                break;
            case 'delete':
                if(is_numeric($_POST['magictoolboxImageId'])) {
                    $_POST['magictoolboxImageId'] = (int)$_POST['magictoolboxImageId'];
                    if(isset($magic360Images[$_POST['magictoolboxImageId']]) &&
                       file_exists($imageBasePath.$magic360Images[$_POST['magictoolboxImageId']]) &&
                       unlink($imageBasePath.$magic360Images[$_POST['magictoolboxImageId']])
                      ) {
                        $magic360ImagesCount = count($magic360Images);
                        unset($magic360Images[$_POST['magictoolboxImageId']]);
                        $magic360Images = array_values($magic360Images);
                        if($magic360Columns == $magic360ImagesCount) {
                            $magic360Columns--;
                        }
                        $updateDB = true;
                     }
                } else if($_POST['magictoolboxImageId'] == '') {
                    $_magic360Columns = $magic360Columns;
                    $magic360ImagesCount = count($magic360Images);
                    foreach($magic360Images as $index => $magic360Image) {
                        if(file_exists($imageBasePath.$magic360Image) && unlink($imageBasePath.$magic360Image)) {
                            unset($magic360Images[$index]);
                            $_magic360Columns--;
                         }
                    }
                    $magic360Images = array_values($magic360Images);
                    if($magic360Columns == $magic360ImagesCount) {
                        $magic360Columns = $_magic360Columns;
                    }
                    $updateDB = true;
                }
                break;
            case 'save':
                if(isset($_POST['magic360-columns']) && is_numeric($_POST['magic360-columns'])) {
                    $magic360Columns = (int)$_POST['magic360-columns'];
                    $updateDB = true;
                }
                if(!isset($_POST['magic360-multi-rows']) && $magic360Columns != count($magic360Images)) {
                    $magic360Columns = count($magic360Images);
                    $updateDB = true;
                }
                break;
            default :
        }
    }

    $magic360ImagesCount = count($magic360Images);
    if($magic360Columns) {
        if($magic360Columns < $magic360ImagesCount) {
            $magic360Rows = floor($magic360ImagesCount/$magic360Columns);
            $multiRows = true;
        } else {
            $magic360Rows = 1;
        }
    }

    if($updateDB) {
        $gallery = implode(';', $magic360Images);
        if($insert) {
            $db->Execute("INSERT INTO `".DB_PREFIX."magic360_images` (`id`, `gallery`, `columns`) VALUES ({$current_product_id}, '{$gallery}', {$magic360Columns})");
        } else {
            $db->Execute("UPDATE `".DB_PREFIX."magic360_images` SET `gallery`='{$gallery}', `columns`={$magic360Columns} WHERE `id`={$current_product_id}");
        }
    }

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript">
<!--
function popupHelpWindow(url) {
    window.open(url,'popupImageWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
}
function init() {
    cssjsmenu('navbar');
    if(document.getElementById) {
        var kill = document.getElementById('hoverJS');
        kill.disabled = true;
    }
}
// -->
</script>
<link rel="stylesheet" href="includes/magic360/resources/mt-form-font.css">
<style type="text/css">
.mt-settings-form {
    font-size: 14px;
    font-family: 'Open Sans', sans-serif, "Helvetica Neue", Helvetica, Arial, sans-serif;
}
.mt-settings-form {
    margin: 20px; 
    background: #fff;
    padding: 20px; 
    -moz-box-shadow: 0px 0px 10px 2px #ddd; 
    -webkit-box-shadow: 0px 0px 10px 2px #ddd; 
    box-shadow: 0px 0px 10px 2px #aaa; 
    border-collapse: separate; 
    color: rgb(51, 51, 51) !important;
}
.mt-border-r-4px {
    -webkit-border-radius: 4px;
    -moz-border-radius: 4px;
    border-radius: 4px;
}
.mt-settings-form h1 {
    font-size: 18px !important;
    padding: 0 0 10px 0px;
    margin: 0 0 20px 0;
    border-bottom: 1px solid #ddd;
}
.mt-settings-form fieldset {
    border: 1px solid #ddd !important;
    padding: 0 20px 10px 20px !important;
    margin: 0 0 1.5em 0 !important;
    background: #fff;
}
.mt-settings-form legend {
    font-size: 14px;
    font-weight: bold;
    background: #efefef;
    padding: 4px 8px 6px 8px;
    border: none;
}
.mt-settings-form select, .mt-settings-form input[type=text] {
    -webkit-border-radius: 4px;
    -moz-border-radius: 4px;
    border-radius: 4px;
    border: 1px solid #ccc;
    padding: 4px 6px;
    font-size: 14px;
    width: 210px;
    background-color: #fff;
    color: black;
}
.mt-settings-form select:disabled, .mt-settings-form input[type=text]:disabled {
    -moz-user-input: disabled;
    background-color: #f3f3f3;
    color: graytext;
    cursor: inherit;
}
.mt-buttons {
    text-align: center;
    margin: 0 0 20px 0;
}
.mt-button {
    cursor: pointer;
    padding: 8px;
    color: #fff;
    font-size: 15px;
    background: #83c611;
    border: none;
    margin: 0 5px 0 0;
    height: 38px;
    vertical-align: middle;
}
.mt-button:hover, .mt-upload-button-hover {
    background: #77AC1C;
}
.mt-border-r-4px {
    -webkit-border-radius: 4px;
    -moz-border-radius: 4px;
    border-radius: 4px;
}
div.mt-upload-container {
    text-align: center;
    overflow: hidden;
    width: 119px;
    height: 38px;
    margin: 0 5px 0 0;
    display: inline-block;
    vertical-align: middle;
}
input.mt-upload-button {
    margin: 0;
    width: 119px;
    z-index: 1;
}
input.mt-upload-file {
    margin: 0;
    padding: 0;
    border: none;
    margin-top: -38px;
    margin-left: -410px;
    -moz-opacity: 0;
    filter: alpha(opacity=0);
    opacity: 0;
    font-size: 150px;
    height: 100px;
    cursor: pointer;
    z-index: 2;
}
input.mt-upload-file::-webkit-file-upload-button {
    cursor: pointer;
}
div.buttons-container {
    text-align: center;
}
div.buttons-container-fixed {
    position: fixed;
    left: 0;
    top: 0;
    background: rgba(255,255,255,1);
    -webkit-box-shadow: 0px 2px 16px 0px rgba(158,158,158,0.3);
    -moz-box-shadow: 0px 2px 16px 0px rgba(158,158,158,0.3);
    box-shadow: 0px 2px 16px 0px rgba(158,158,158,0.3);
    width: 100%;
    z-index: 10000;
}
div.buttons-container-fixed .mt-buttons {
    margin: 5px 0;
}

div.magictoolboxContent {
    margin: 0 auto;
    width: 100%;
}
div.magictoolboxContent fieldset > div {
    margin: 10px 0;
}
div.magictoolboxContent fieldset > div > label {
    width: 300px;
    float: left;
}
select.categories_menu option, select.products_menu option {
    padding: 0;
}

.mt-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
.mt-table a { text-decoration: none; font-size: 18px; color: inherit !important; }
.mt-table span.mt-icon-trash { color: red !important; }
.mt-table, .mt-table td , .mt-table th { border: 1px solid #ddd;}
.mt-table td , .mt-table th { padding: 6px 12px; }
.mt-table th { background: #efefef; }
.mt-table, .mt-table thead, .mt-table th { font-size: inherit !important; }
.mt-table td { vertical-align: top; text-align: center; }
.mt-table td img {
    max-width: 60px;
    max-height: 60px;
}

</style>
</head>
<body onLoad="init()" >
<?php require(DIR_WS_INCLUDES.'header.php'); ?>


<div class="mt-settings-form mt-border-r-4px">

<form id="magic360form" name="magic360form" action="<?php echo zen_href_link(FILENAME_MAGIC360_IMAGES); ?>" method="post" enctype="multipart/form-data">
    <input type="hidden" value="select" id="magictoolboxSubmitAction" name="magictoolboxSubmitAction" />
    <input type="hidden" value="" id="magictoolboxImageId" name="magictoolboxImageId" />
    <div class="magictoolboxContent">
        <h1><?php echo BOX_MAGICTOOLBOX_MAGIC360_IMAGES; ?></h1>
        <?php if($current_product_id) { ?>
        <div id="buttons-container-wrapper">            
            <div id="buttons-container" class="buttons-container">
                <div class="mt-buttons">
                    <div class="mt-upload-container">
                        <input type="button" class="mt-button mt-border-r-4px mt-upload-button" id="mt-upload-button" value="Upload images"/>
                        <input class="mt-upload-file" type="file" name="magic360images[]" id="mt-upload-file" multiple="multiple" accept="image/*" size="1" />
                    </div>
                    <?php if($magic360ImagesCount) { ?>
                    <input type="button" class="mt-button mt-border-r-4px" data-submit-action="delete" value="Delete all images"/>
                    <input type="button" class="mt-button mt-border-r-4px" data-submit-action="save" value="Save"/>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php } ?>
        <fieldset class="mt-border-r-4px">
            <legend>Products selector</legend>
            <div>
                <label for="default-message">Category<?php if($current_category_id && empty($products_menu)) { echo '&nbsp;&nbsp;(<span style="color: red;">this category has no products</span>)'; } ?></label>
                <span>
                    <select name="current_category_id" class="categories_menu" onchange="this.form.current_product_id.selectedIndex = 0;this.form.submit();">
                        <option value="0">-- Please select category --</option>
                        <?php echo $categories_menu; ?>
                    </select>
                </span>
            </div>
            <div style="clear: both;"></div>
            <div>
                <label for="default-message">Product</label>
                <span>
                    <select name="current_product_id" class="products_menu" <?php echo $current_category_id ? '' : 'disabled="disabled"'; ?> onchange="this.form.submit();">
                        <option value="0">-- Please select product --</option>
                        <?php echo $products_menu; ?>
                    </select>
                </span>
            </div>
            <div style="clear: both;"></div>
        </fieldset>
        <?php if($magic360ImagesCount) { ?>
        <fieldset class="mt-border-r-4px">
            <legend>Multi-row spin options</legend>
            <div>
                <label for="default-message">Multi-row spin</label>
                <span>
                    <input type="checkbox" id="magic360-multi-rows" name="magic360-multi-rows"<?php echo $multiRows ? ' checked="checked"' : ''; ?> onclick="switchMultiRows()" />
                </span>
            </div>
            <div style="clear: both;"></div>
            <div>
                <label for="default-message">Number of images on X-axis</label>
                <span>
                    <input type="text" id="magic360-columns" name="magic360-columns" size="10"<?php echo $multiRows ? '' : ' disabled="disabled"'; ?> value="<?php echo $magic360Columns; ?>" />
                </span>
            </div>
            <div style="clear: both;"></div>
            <div>
                <label for="default-message">Number of images on Y-axis</label>
                <span>
                    <input type="text" id="magic360-rows" name="magic360-rows" size="10"<?php echo $multiRows ? '' : ' disabled="disabled"'; ?> value="<?php echo $magic360Rows; ?>" />
                </span>
            </div>
            <div style="clear: both;"></div>
        </fieldset>
        <fieldset class="mt-border-r-4px">
            <legend>Images</legend>
            <table id="magic360_images" cellspacing="0" cellpadding="0" class="mt-table">
            <thead>
                <tr>
                    <th>Number</th>
                    <th>Image</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($magic360Images as $index => $imageName) { ?>
                <tr id="row-<?php echo $index; ?>">
                    <td>#<?php echo $index+1; ?></td>
                    <td>
                        <img src="<?php echo $imageBaseUrl.$imageName; ?>" alt="<?php echo $imageName; ?>" title="<?php echo $imageName; ?>" />
                    </td>
                    <td>
                        <a class="mt-delete-image-link" href="#" onclick="return false;" data-image-id="<?php echo $index; ?>" title="Delete image"><span class="mt-icon-trash"></span></a>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
            </table>
        </fieldset>
        <?php } ?>
    </div>
    <div style="clear: both;"></div>
</form>

</div>

<?php require(DIR_WS_INCLUDES.'footer.php'); ?>

<script type="text/javascript">
//<![CDATA[

    function switchMultiRows() {
        if(document.getElementById('magic360-multi-rows').checked) {
            document.getElementById('magic360-columns').removeAttribute('disabled');
            document.getElementById('magic360-rows').removeAttribute('disabled');
        } else {
            document.getElementById('magic360-columns').setAttribute('disabled', true);
            document.getElementById('magic360-rows').setAttribute('disabled', true);
        }
    }

    function mouseoverHandler() {
        magicToolboxAddClass(document.getElementById('mt-upload-button'), 'mt-upload-button-hover');
    }
    function mouseoutHandler() {
        magicToolboxRemoveClass(document.getElementById('mt-upload-button'), 'mt-upload-button-hover');
    }
    var fileInput = document.getElementById('mt-upload-file');
    if(fileInput) {
        magicToolboxAddEvent(fileInput, 'mouseover', mouseoverHandler);
        magicToolboxAddEvent(fileInput, 'mouseout', mouseoutHandler);
        magicToolboxAddEvent(fileInput, 'change', function() {
            document.getElementById('magictoolboxSubmitAction').value = 'upload';
            document.getElementById('magic360form').submit();
        });
    }

    function scrollHandler() {
        var buttonsContainer = document.getElementById('buttons-container');
        if(!buttonsContainer) return;
        var buttonsContainerWrapper = buttonsContainer.parentNode;
        if(typeof(buttonsContainerWrapper.getBoundingClientRect) == 'undefined') return;
        var buttonsContainerWrapperBox = buttonsContainerWrapper.getBoundingClientRect();
        if(buttonsContainerWrapperBox.top < 0) {
            magicToolboxAddClass(buttonsContainer, 'buttons-container-fixed');
        } else {
            magicToolboxRemoveClass(buttonsContainer, 'buttons-container-fixed');
        }
    }
    magicToolboxAddEvent(window, 'scroll', scrollHandler);
    magicToolboxAddEvent(window, 'resize', scrollHandler);

    var mtButtons = magicToolboxGetElementsByClass('mt-button');
    for(var i = 0; i < mtButtons.length; i++) {
        magicToolboxAddEvent(mtButtons[i], 'click', function() {
            var action = this.getAttribute('data-submit-action');
            if(action) {
                document.getElementById('magictoolboxSubmitAction').value = action;
                document.getElementById('magic360form').submit();
            }
        });
    }

    var mtLinks = magicToolboxGetElementsByClass('mt-delete-image-link');
    for(var i = 0; i < mtLinks.length; i++) {
        magicToolboxAddEvent(mtLinks[i], 'click', function() {
            var id = this.getAttribute('data-image-id');
            if(id) {
                var form = document.getElementById('magic360form');
                form.magictoolboxImageId.value = id;
                form.magictoolboxSubmitAction.value = 'delete';
                console.log(id);
                form.submit();
            }
            return false;
        });
    }

    function magicToolboxHasClass(element, className) {
        return element.className.match(new RegExp('(\\s|^)'+className+'(\\s|$)'));
    }
    function magicToolboxAddClass(element, className) {
        if(!this.magicToolboxHasClass(element, className)) element.className += " "+className;
    }
    function magicToolboxRemoveClass(element, className) {
        if(magicToolboxHasClass(element, className)) {
            var reg = new RegExp('(\\s|^)'+className+'(\\s|$)');
            element.className = element.className.replace(reg, ' ');
        }
    }
    function magicToolboxGetElementsByClass(classList, node) {
        var node = node || document;
        if(node.getElementsByClassName) {
            return node.getElementsByClassName(classList);
        } else {
            var nodes = node.getElementsByTagName("*"),
            nodesLength = nodes.length,
            classes = classList.split(/\s+/),
            classesLength = classes.length,
            result = [], i,j;
            for(i = 0; i < nodesLength; i++) {
                for(j = 0; j < classesLength; j++)  {
                    if(nodes[i].className.search("\\\\b" + classes[j] + "\\\\b") != -1) {
                        result.push(nodes[i]);
                        break;
                    }
                }
            }
            return result;
        }
    }
    function magicToolboxAddEvent(element, eventType, handler) {
        if(element.addEventListener) {
            element.addEventListener(eventType, handler, false);
        } else {
            element.attachEvent(eventType, handler);
        }
    }

//]]>
</script>

</body>
</html>
<?php require(DIR_WS_INCLUDES.'application_bottom.php'); ?>
