<?php

    require('includes/application_top.php');

    ini_set('display_errors', true);
    error_reporting(E_ALL & ~E_NOTICE);

    $result = $db->Execute("SHOW TABLES LIKE '".DB_PREFIX."magic360_configuration'");
    if($result->EOF) {
        die('Magic 360 settings does not exist! Make sure that the module is installed correctly.');
    }

    defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);
    defined('MT_FS_ROOT') || define('MT_FS_ROOT', dirname(dirname(__FILE__)).MT_DS);//DIR_FS_CATALOG
    defined('MT_WS_ROOT') || define('MT_WS_ROOT', preg_replace('#[^/]+/$#', '', DIR_WS_ADMIN));//DIR_WS_CATALOG
    defined('MT_FS_ADMIN') || define('MT_FS_ADMIN', dirname(__FILE__).MT_DS);//DIR_FS_ADMIN
    defined('MT_FS_CATALOG_TEMPLATES') || define('MT_FS_CATALOG_TEMPLATES', MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS);//DIR_FS_CATALOG_TEMPLATES

    $action = isset($_POST['magic360-submit-action']) ? $_POST['magic360-submit-action'] : false;
    $activeTab = isset($_POST['magic360-active-tab']) ? $_POST['magic360-active-tab'] : false;

    if($_SERVER['REQUEST_METHOD'] == 'POST') {
        switch($action) {
            case 'save':
                if(isset($_POST['magictoolbox']) && is_array($_POST['magictoolbox'])) {
                    $db->Execute("UPDATE `".DB_PREFIX."magic360_configuration` SET `enabled` = 0 WHERE `block` != 'default'");
                    foreach($_POST['magictoolbox'] as $block => $params) {
                        if(!is_array($params)) continue;
                        foreach($params as $id => $value) {
                            $value = zen_db_input($value);
                            $db->Execute("UPDATE `".DB_PREFIX."magic360_configuration` SET `value` = '{$value}', `enabled` = 1 WHERE `block` = '{$block}' AND `name` = '{$id}'");
                        }
                    }
                }
                break;
            case 'reset':
                $db->Execute("UPDATE `".DB_PREFIX."magic360_configuration` SET `value` = `default_value`, `enabled`=`default_enabled` WHERE `block`='{$activeTab}'");
                break;
            case 'upload':
            default :
        }
    }

    require(MT_FS_ROOT.preg_replace('/\/|\\\\/', MT_DS, DIR_WS_MODULES).'magic360'.MT_DS.'functions.php');
    $tool = magic360GetTool();
    $params = $tool->params;

    $blocks = array(
		'default' => 'General',
		'product' => 'Product page',
	);
    $map = array(
		'default' => array(
			'Magic 360' => array(
				'magnify' => true,
				'magnifier-width' => true,
				'magnifier-shape' => true,
				'fullscreen' => true,
				'spin' => true,
				'autospin-direction' => true,
				'sensitivityX' => true,
				'sensitivityY' => true,
				'mousewheel-step' => true,
				'autospin-speed' => true,
				'smoothing' => true,
				'autospin' => true,
				'autospin-start' => true,
				'autospin-stop' => true,
				'initialize-on' => true,
				'start-column' => true,
				'start-row' => true,
				'loop-column' => true,
				'loop-row' => true,
				'reverse-column' => true,
				'reverse-row' => true,
				'column-increment' => true,
				'row-increment' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => true,
				'thumb-max-height' => true,
				'square-images' => true,
			),
			'Miscellaneous' => array(
				'show-message' => true,
				'message' => true,
				'loading-text' => true,
				'fullscreen-loading-text' => true,
				'hint' => true,
				'hint-text' => true,
				'mobile-hint-text' => true,
				'imagemagick' => true,
				'image-quality' => true,
				'icon' => true,
			),
			'Watermark' => array(
				'watermark' => true,
				'watermark-max-width' => true,
				'watermark-max-height' => true,
				'watermark-opacity' => true,
				'watermark-position' => true,
				'watermark-offset-x' => true,
				'watermark-offset-y' => true,
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Magic 360' => array(
				'magnify' => false,
				'magnifier-width' => false,
				'magnifier-shape' => false,
				'fullscreen' => false,
				'spin' => false,
				'autospin-direction' => false,
				'sensitivityX' => false,
				'sensitivityY' => false,
				'mousewheel-step' => false,
				'autospin-speed' => false,
				'smoothing' => false,
				'autospin' => false,
				'autospin-start' => false,
				'autospin-stop' => false,
				'initialize-on' => false,
				'start-column' => false,
				'start-row' => false,
				'loop-column' => false,
				'loop-row' => false,
				'reverse-column' => false,
				'reverse-row' => false,
				'column-increment' => false,
				'row-increment' => false,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Miscellaneous' => array(
				'show-message' => false,
				'message' => false,
				'loading-text' => false,
				'fullscreen-loading-text' => false,
				'hint' => false,
				'hint-text' => false,
				'mobile-hint-text' => false,
				'icon' => false,
			),
		),
	);

    $template_mt = 'classic';
    $templates = array();
    //NOTE: used templates
    //$result = $db->Execute("SELECT * FROM ".TABLE_TEMPLATE_SELECT);
    //NOTE: all templates (with module installed)
    if(file_exists(MT_FS_CATALOG_TEMPLATES)) {
        $templatesDir = dir(MT_FS_CATALOG_TEMPLATES);
        if($templatesDir) {
            while($file = $templatesDir->read()) {
                if(file_exists(MT_FS_CATALOG_TEMPLATES.$file.MT_DS.'jscript'.MT_DS.'magic360.js')) {
                    $templates[] = $file;
                }
            }
            $templatesDir->close();
        }
    }
    //TODO: add support multiple templates
    if(count($templates) == 1) $template_mt = $templates[0];

    include(MT_FS_ADMIN.'includes'.MT_DS.'magic360'.MT_DS.'magictoolbox.settings.editor.class.php');
    $settings = new MagictoolboxSettingsEditorClass(MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript');
    $settings->paramsMap = &$map;
    $settings->core = &$tool;
    $settings->profiles = &$blocks;
    $settings->pathToJS = MT_FS_ROOT.'includes'.MT_DS.'templates'.MT_DS.$template_mt.MT_DS.'jscript';
    $settings->action = htmlentities($_SERVER['REQUEST_URI']);
    $settings->setResourcesURL(DIR_WS_ADMIN.'includes/magic360/resources/');
    $settings->jQueryNoConflictLevel(0);
    $html = $settings->getHTML();
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript">
<!--
function popupHelpWindow(url) {
    window.open(url,'popupImageWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
}
function init() {
    cssjsmenu('navbar');
    if(document.getElementById) {
        var kill = document.getElementById('hoverJS');
        kill.disabled = true;
    }
}
// -->
</script>
<style type="text/css"></style>
</head>
<body onLoad="init()" >
<?php require(DIR_WS_INCLUDES.'header.php'); ?>
<?php echo $settings->getHTML(); ?>
<?php require(DIR_WS_INCLUDES.'footer.php'); ?>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>
<?php require(DIR_WS_INCLUDES.'application_bottom.php'); ?>
