<?php
/**
* Magic Zoom Plus XT-Commerce Module
*
* @version v3.4.4 [v1.6.103:v5.3.7]
* @author Magic Toolbox
* @copyright (C) 2008 Magic Toolbox. All rights reserved.
* @link http://www.magictoolbox.com/magiczoomplus/
* @license http://www.magictoolbox.com/license/
* *
* Magic Zoom Plus XT-Commerce Module comes with absolute no warranty.
*
*/

    ob_start();

    function MagicZoomPlus() {
        $content = ob_get_contents();
        ob_clean();

        /* load module */
        require_once(dirname(__FILE__) . '/magiczoomplus.module.core.class.php');
        $tool = new MagicZoomPlusModuleCoreClass();
        $tool->params->loadINI(dirname(dirname(__FILE__)) . '/magiczoomplus.settings.ini');
        $GLOBALS["magictoolbox"]["magiczoomplus"] = & $tool;

        if (!defined( '_MAGICZOOMPLUS_MODULE_LOADED' )) {

            define( '_MAGICZOOMPLUS_MODULE_LOADED', 1 );

            if ($content) {

                if (!$tool->params->checkValue('use-effect-on-product-page','No')) {

                    /* load JS/CSS */
                    $pattern = '/<\/head>/is';
                    $content = preg_replace_callback($pattern, "callback_MagicZoomPlus_head", $content, 1);

                    $tool->params->setProfile('product');

                    /* cut 'more images' from content */
                    $moreImagesContent = preg_replace('/^(.*?)\<\!-- more images --\>(.*?)\<\!-- more images eof --\>(.*)$/is', '$2', $content);
                    if($moreImagesContent == $content) {
                        $moreImagesContent = '';
                    } else {
                        $content = preg_replace('/^(.*?)\<\!-- more images --\>(.*?)\<\!-- more images eof --\>(.*)$/is', '$1$3', $content);
                    }

                    /* create selectors */
                    $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] = '';
                    $GLOBALS['magictoolbox']['MagicZoomPlus']['selectorsCount'] = 0;
                    //old variant for selector
                    //$GLOBALS['magictoolbox']['MagicZoomPlus']['parceSelectors'] = true;
                    //$moreImagesContent = preg_replace_callback('/<a[^>]*><img[^>*]src=\"([^"]*?\/product_images\/info_images\/[^"]*?\.(jpg|jpeg|gif|png))\"[^>]*alt=\"([^"]*?)\"[^>]*>.*?<\/a>/is', "callback_MagicZoomPlus", $moreImagesContent);
                    $GLOBALS['magictoolbox']['MagicZoomPlus']['parceSelectors'] = false;

                    //new variant for selector
                    global $product;//$product is set in application_top.php
                    if(isset($product)) {
                        if(is_object($product) && $product->pID) {
                            $mo_sel_images = xtc_get_products_mo_images((int) $product->pID);
                            if($mo_sel_images) {
                                $imagePath = constant('DIR_WS_' . strtoupper($tool->params->getValue('big-image')) . '_IMAGES');
                                $selectorPath = constant('DIR_WS_THUMBNAIL_IMAGES');
                                $thumbPath = constant('DIR_WS_INFO_IMAGES');
                                $id = 'magiczoomplusMainImage';
                                $title = $product->data['products_name'];
                                $description = $product->data['products_description'];
                                $shortDescription = $product->data['products_short_description'];
                                $alt = $title;
                                $width = $tool->params->getValue('selectors-size');
                                if($width == -1) {$width = false;}
                                //$selectors = array();
                                foreach($mo_sel_images as $sel_image) {
                                    $img = $imagePath . $sel_image['image_name'];
                                    $thumb = $selectorPath . $sel_image['image_name'];
                                    $medium = $thumbPath . $sel_image['image_name'];
                                    $GLOBALS['magictoolbox']['MagicZoomPlus']['selectorsCount']++;
                                    $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] .= $tool->getSelectorTemplate(compact("img", "thumb", "title", "shortDescription" ,"description", 'id', 'medium', "alt", "width"));
                                }
                                //die(print_r($selectors, true));
                            }
                        }

                    }

                    /* replace images with MagicZoom and selectors */
                    $origContent = $content;
                    $content = preg_replace_callback('/<a[^>]*?href=[\"\']javascript[^>]*><img[^>*]src=\"([^"]*?\/product_images\/(?:(?:info)|(?:thumbnail))_images\/[^"]*?\.(jpg|jpeg|gif|png))\"[^>]*(?:alt=\"([^"]*?)\")?[^>]*>.*?<\/a>/is', "callback_MagicZoomPlus", $content);
                    if ($origContent == $content) {
                        $content = preg_replace_callback('/<a[^>]*?class="fancy"[^>]*><img[^>*]src=\"([^"]*?\/product_images\/(?:(?:info)|(?:thumbnail))_images\/[^"]*?\.(jpg|jpeg|gif|png))\"[^>]*(?:alt=\"([^"]*?)\")?[^>]*>.*?<\/a>/is', "callback_MagicZoomPlus", $content);
                    }

                    //$pattern = '/<\s*(script)\s*([^>]*)(?:>(.*?)<\/\1>|\/>)/s';
                    //$content = preg_replace_callback($pattern, "callback_MagicZoomPlus", $content);
                }
                print_r($content);

            } else { /*category page*/

                if (!$tool->params->checkValue('use-effect-on-category-page','No')) {
                    $GLOBALS["magictoolbox"]["magiczoomplus"]->params->resetProfile();
                    $headers = $GLOBALS["magictoolbox"]["magiczoomplus"]->getHeadersTemplate(DIR_WS_CATALOG . 'includes/modules/magictoolbox/core');
                    $GLOBALS['smarty']->_tpl_vars['main_content'] = $headers.$GLOBALS['smarty']->_tpl_vars['main_content'];

                    $tool->params->setProfile('category');

                    if(!$tool->params->checkValue('use-effect-on-category-image','No')) { //enable effect to category image
                        $category_image = $GLOBALS['module_smarty']->_tpl_vars['CATEGORIES_IMAGE'];
                        $category_image = preg_replace('/\//is','\/',$category_image);
                        $GLOBALS['smarty']->_tpl_vars['main_content'] = preg_replace_callback('/<img[^<]*src=\"'.$category_image.'\".*?\/>/is',"callback_MagicZoomPlus_category",$GLOBALS['smarty']->_tpl_vars['main_content']);
                    }

                    foreach($GLOBALS['module_content'] as $prod) {
                        $p_img = preg_replace('/\//is','\/',$prod['PRODUCTS_IMAGE']);
                        $GLOBALS['smarty']->_tpl_vars['main_content'] = preg_replace_callback('/<a[^>]*><img[^<]*src=\"'.$p_img.'\".*?\/a>/is',"callback_MagicZoomPlus_category",$GLOBALS['smarty']->_tpl_vars['main_content']);
                    }
                }
            }
        }

    }

    function callback_MagicZoomPlus_head($matches) {
        $GLOBALS["magictoolbox"]["magiczoomplus"]->params->resetProfile();
        $headers = $GLOBALS["magictoolbox"]["magiczoomplus"]->getHeadersTemplate(DIR_WS_CATALOG . 'includes/modules/magictoolbox/core');
        return $headers . $matches[0];
    }

    function callback_MagicZoomPlus_category($matches) {
        $mod = & $GLOBALS["magictoolbox"]["magiczoomplus"];

        if($mod->params->checkValue('link-to-product-page', 'Yes')) {
        $link = preg_replace('/^<a[^>]*?href=\"([^\"]*?)\"[^>]*>.*?<\/a>$/is', '$1', $matches[0]);
        } else { $link = ''; }

        $th_pattern = '/'.preg_replace('/\//is','\/',constant('DIR_WS_THUMBNAIL_IMAGES')).'/is';
        $img_pattern = preg_replace('/\//is','\/',constant('DIR_WS_ORIGINAL_IMAGES'));

        $thumb = stripslashes(preg_replace('/.*?src=\"(.*)\".*/is','$1',$matches[0]));
        $img = preg_replace($th_pattern,$img_pattern,$matches[0]);
        $img = stripslashes(preg_replace('/.*?src=\"([^"]*)\".*/is','$1',$img));

        $width = $mod->params->getValue('thumbnails-size');
        if($width == -1) {
            $width = false;
        }

        $result = $mod->getMainTemplate(compact("img", "thumb", "title", "description", 'id', "alt", 'link', 'width'));

        $result = '<div id="MagicToolboxContainer" class="MagicToolboxContainerOnCategoryPage" style="text-align:center;float:left;">' . $result . '</div>';

        return $result;
    }

    function callback_MagicZoomPlus($matches) {

        $mod = & $GLOBALS["magictoolbox"]["magiczoomplus"];

        $imgPath = constant('DIR_WS_' . strtoupper($mod->params->getValue('big-image')) . '_IMAGES');
        if(!$imgPath) return $matches[0];

        $selectorsPath = constant('DIR_WS_THUMBNAIL_IMAGES');
        /*if(!$selectorsPath) return $matches[0];*/

        $thumb = str_replace('%20', ' ', $matches[1]);
        $path = pathinfo($thumb);
        $img = $imgPath . $path['basename'];
        $alt = $matches[3];
        if (!file_exists($img) ) return $matches[0];

        $selector = $selectorsPath . $path['basename'];
        /*if (!file_exists($selector) ) return $matches[0];*/

        $description = '';
        $shortDescription = '';
        $title = '';
        if ( isset($GLOBALS['product']) ) {
                $title = $GLOBALS['product']->data['products_name'];
                $description = $GLOBALS['product']->data['products_description'];
                $shortDescription = $GLOBALS['product']->data['products_short_description'];
        } else {
                // get product info from db
                if(isset($_GET['info'])) {
                    $site = explode('_', $_GET['info']);
                    $pID = $site[0];
                    $products_id = (int) str_replace('p', '', $pID);
                } elseif(isset($_GET['products_id'])) {
                    $products_id = (int) $_GET['products_id'];
                }
                $product_info_query = xtc_db_query("select p.*, pd.products_name, pd.products_description, pd.products_short_description from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . $products_id . "' and pd.products_id = p.products_id and pd.language_id = '" . (int) $_SESSION['languages_id'] . "'");
                $product_info = xtc_db_fetch_array($product_info_query);
                $title = $product_info['products_name'];
                $description = $product_info['products_description'];
                $shortDescription = $product_info['products_short_description'];
        }
        //$title = htmlentities($title, ENT_QUOTES);

        $html = array();

        /*
        if (!defined( '_MAGICZOOMPLUS_MODULE_ADDONS_LOADED' )) {
            $html[] = $mod->getAddonsTemplate(DIR_WS_CATALOG . 'includes/modules/magictoolbox/core');
            define('_MAGICZOOMPLUS_MODULE_ADDONS_LOADED', 1);
        }
        */

        $id = 'magiczoomplusMainImage';

        $GLOBALS['magictoolbox']['MagicZoomPlus']['selectorsCount']++;
        $medium = $thumb;
        $thumb = $selector;
        $sHtml = $html;
        $width = $mod->params->getValue('selectors-size');
        if($width == -1) {
            $width = false;
        }
        $sHtml[] = $mod->getSelectorTemplate(compact("img", "thumb", "title", "shortDescription" ,"description", 'id', 'medium', "alt", "width"));
        $selector = join($sHtml, ' ');
        $thumb = $medium;

        if($GLOBALS['magictoolbox']['MagicZoomPlus']['parceSelectors'] == false) {
            $width = $mod->params->getValue('thumbnails-size');
            if($width == -1) {
                $width = false;
            }
            $a = $mod->getMainTemplate(compact("img", "thumb", "title", "shortDescription", "description", 'id', "alt", "width"));
            $a = preg_replace('/^<a /is', '<a style="margin:0 auto;" ', $a);
            $html[] = $a;
            if($GLOBALS['magictoolbox']['MagicZoomPlus']['selectorsCount'] > 1) {
                $html[] = '<br />';
                $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] = $selector . $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'];
                //$html[] = '<div class="MagicToolboxSelectorsContainer">' . $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] . '</div>';
                $html[] = '<div class="MagicToolboxSelectorsContainer morepics">' . $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] . '</div>';
            }
        } else {
            $GLOBALS['magictoolbox']['MagicZoomPlus']['selectors'] .= $selector;
        }

        return '<div class="MagicToolboxContainer MagicToolboxContainerOnProductPage">'.join($html, ' ').'</div>';
    }

?>
