<?php
    /**
     *  xt:Commerce module installer class
     */

    require_once(dirname(__FILE__) . '/magictoolbox.installer.core.class.php');

    class MagicToolboxXTCommerceModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        var $filesToBackup = array();

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__) . '/module';
            $this->filesToBackup = array(
                '/product_info.php',
                '/includes/modules/product_listing.php',
                '/admin/includes/functions/general.php',
                '/admin/includes/column_left.php'
            );
            //for fix url's in css files
            $this->resDir = preg_replace('/^(.*?\/)[^\/]+\/[^\/]+$/is', '$1', $_SERVER['SCRIPT_NAME']) . 'includes/modules/magictoolbox/core';

        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/includes/modules/magictoolbox/core/magicthumb.module.core.class.php')) {
                if('magicthumb' == 'magicscroll') {
                    $contents = file_get_contents($this->dir.'/includes/modules/magictoolbox/core/magicscroll.module.core.class.php');
                    if(!preg_match('/<!-- Magic Scroll Zen Cart module/', $contents)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');
            if(!file_exists($this->dir . '/includes/application_top.php')) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the xt:Commerce store directory.');
                return false;
            }
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $files = array(
                // directory
                '/',
                '/admin',
                '/admin/includes/',
                '/admin/includes/functions',
                '/includes/modules'
                // file
            );
            $files = array_merge($files, $this->filesToBackup);
            list($result, $wrang) = $this->checkFilesPerm($files);
            if(!$result) {
                $this->setError('This installer need to modify some xt:Commerce store files.');
                $this->setError('Please check write access for following files of your xt:Commerce store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');

            list($result, $wrang) = $this->createBackups($this->filesToBackup);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            $this->removeBackups($this->filesToBackup);
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            //modify product_info.php file
            $fileContents = file_get_contents($this->dir . '/product_info.php');

            $pattern = "/include\s*\(\s*'includes\/application_top\.php'\s*\)\s*;/is";
            $replace = "include ('includes/application_top.php');" . "\r\n"
                . '// === magictoolbox modification start' . "\r\n"
                . "require_once(DIR_WS_MODULES . 'magictoolbox/core/magicthumb.php');" . "\r\n"
                . '// === magictoolbox modification end' . "\r\n\r\n";
            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            if($newFileContents == $fileContents) {
                $this->setError('Can\'t find the string: "include (\'includes/application_top.php\');" in product_info.php. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                return false;
            }
            $fileContents = $newFileContents;

            $pattern = "/include\s*\(\s*'includes\/application_bottom\.php'\s*\)\s*;/is";
            $replace = "\r\n\r\n"
                . '// === magictoolbox modification start' . "\r\n"
                . "MagicThumb();" . "\r\n"
                . '// === magictoolbox modification end' . "\r\n"
                . "include ('includes/application_bottom.php');" . "\r\n\r\n";
            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            if($newFileContents == $fileContents) {
                if(strpos($fileContents, 'application_bottom') !== false) {
                    $this->setError('Can\'t find the string: "include (\'includes/application_bottom.php\');" in product_info.php. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                    return false;
                } else {
                    $newFileContents = $newFileContents . "\r\n<?php MagicThumb(); ?>\r\n";
                }
            }
            file_put_contents($this->dir . '/product_info.php', $newFileContents);

            //modify /includes/modules/product_listing.php file
            $fileContents = file_get_contents($this->dir . '/includes/modules/product_listing.php');

            $string = '$listing_split = new splitPageResults($listing_sql, (int)$_GET[\'page\'], MAX_DISPLAY_SEARCH_RESULTS, \'p.products_id\');';
            $pattern = '/(\$listing_split = new splitPageResults\(\$listing_sql, (?:\(int\))?\$_GET\[\'page\'\], MAX_DISPLAY_SEARCH_RESULTS, \'p\.products_id\'\);)/is';
            $replace = "\r\n\r\n"
                . '// === magictoolbox modification start' . "\r\n"
                . 'include(DIR_WS_MODULES . \'/magictoolbox/core/magicthumb.php\');' . "\r\n"
                . '// === magictoolbox modification end' . "\r\n"
                . "$1\r\n\r\n";
            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            if($newFileContents == $fileContents) {
                $this->setError('Can\'t find the string: "'.$string.'" in /includes/modules/product_listing.php. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                return false;
            }
            $fileContents = $newFileContents;

            $pattern = '/(\?>[^>]*)$/';
            $replace = "\r\n\r\n"
                . '// === magictoolbox modification start' . "\r\n"
                . 'MagicThumb();' . "\r\n"
                . '// === magictoolbox modification end' . "\r\n"
                . '\\1' . "\r\n\r\n";
            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            if($newFileContents == $fileContents) {
                $this->setError('Can\'t find the string: "?>" in /includes/modules/product_listing.php. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                return false;
            }
            file_put_contents($this->dir . '/includes/modules/product_listing.php', $newFileContents);

            //modify admin/includes/functions/general.php file
            $fileContents = file_get_contents($this->dir . '/admin/includes/functions/general.php');
            $pattern = '/(\s*function\s+xtc_check_permission\s*\(\s*\$pagename\s*\)\s*\{)/is';
            $replace = "$1\r\n\r\n" .
                       '// === magictoolbox modification start' . "\r\n" .
                       'if($pagename == \'magicthumb\') $pagename = \'modules\';' . "\r\n" .
                       '// === magictoolbox modification end' . "\r\n\r\n";
            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            if($newFileContents == $fileContents) {
                $this->setError('Can\'t find the string: "function xtc_check_permission($pagename){" in /admin/includes/functions/general.php. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                return false;
            }
            file_put_contents($this->dir . '/admin/includes/functions/general.php', $newFileContents);

            //modify admin/includes/column_left.php file
            $fileContents = file_get_contents($this->dir . '/admin/includes/column_left.php');

            $string = htmlspecialchars('echo (\'<h2 class="boxheader">\' . BOX_HEADING_MODULES . \'</h2>\');' . "\n" .
                      'echo \'<div class="boxbody"><ul class="contentlist">\';');
            $pattern = '/(\s*echo\s+\(\'<h2 class="boxheader">\' . BOX_HEADING_MODULES . \'<\/h2>\'\);\s*\n' .
                       '\s*echo\s+\'<div class="boxbody"><ul class="contentlist">\';)/is';
            $replace = "$1\r\n\r\n" .
                       '// === magictoolbox modification start' . "\r\n" .
                       'if(($_SESSION[\'customers_status\'][\'customers_status_id\'] == \'0\') && ($admin_access[\'modules\'] == \'1\')) ' .
                       'echo \'<li><a href="\' . xtc_href_link(\'magicthumb.php\', \'\', \'NONSSL\') . \'">\' . xtc_image(DIR_WS_IMAGES . \'icon_arrow.gif\') . \'Magic Thumb</a></li>\';' . "\r\n" .
                       '// === magictoolbox modification end' . "\r\n\r\n";
            if(!preg_match($pattern, $fileContents)) {
                $string = htmlspecialchars('echo (\'<div class="menuBoxHeading"><b>\'.BOX_HEADING_MODULES.\'</b></div>\');');
                $pattern = '/(\s*echo\s*\(\s*\'<div class="menuBoxHeading"><b>\'.BOX_HEADING_MODULES.\'<\/b><\/div>\'\);)/is';
                $replace = "$1\r\n\r\n" .
                           '// === magictoolbox modification start' . "\r\n" .
                            'if(($_SESSION[\'customers_status\'][\'customers_status_id\'] == \'0\') && ($admin_access[\'modules\'] == \'1\')) ' .
                            'echo \'<a href="\' . xtc_href_link(\'magicthumb.php\', \'\', \'NONSSL\') . \'" class="menuBoxContentLink"> -Magic Thumb</a><br>\';' . "\r\n" .
                           '// === magictoolbox modification end' . "\r\n\r\n";
                if(!preg_match($pattern, $fileContents)) {
                    $string = htmlspecialchars('echo (\'<div class="dataTableHeadingContent"><b>\'.BOX_HEADING_MODULES.\'</b></div>\');');
                    $pattern = '/(\s*echo\s*\(\'<div class="dataTableHeadingContent"><b>\'\.BOX_HEADING_MODULES\.\'<\/b><\/div>\'\);)/is';
                    $replace = "$1\r\n\r\n" .
                           '// === magictoolbox modification start' . "\r\n" .
                            'if(($_SESSION[\'customers_status\'][\'customers_status_id\'] == \'0\') && ($admin_access[\'modules\'] == \'1\')) ' .
                            'echo \'<a href="\' . xtc_href_link(\'magicthumb.php\', \'\', \'NONSSL\') . \'" class="menuBoxContentLink"> -Magic Thumb</a><br>\';' . "\r\n" .
                           '// === magictoolbox modification end' . "\r\n\r\n";
                    if(!preg_match($pattern, $fileContents)) {
                        $this->setError('Can\'t modify content in /admin/includes/column_left.php file. Perhaps the original file was modified. Please, try to install Magic Thumb manually.');
                        return false;
                    }
                }
            }

            $newFileContents = preg_replace($pattern, $replace, $fileContents);
            file_put_contents($this->dir . '/admin/includes/column_left.php', $newFileContents);

            // copy modules folder
            $this->copyDir($this->modDir . '/includes', $this->dir . '/includes');

            // copy admin folder
            $this->copyDir($this->modDir . '/admin', $this->dir . '/admin');

            return true;
        }

        function restoreStep_installFiles() {

            $this->restoreFromBackups($this->filesToBackup);

            @$this->removeDir($this->dir . '/includes/modules/magictoolbox');

            @unlink($this->dir . '/admin/magicthumb.php');

            return true;
        }

        function upgrade($files) {
            $path = $this->dir . '/includes/modules/magictoolbox/core/';
            foreach($files as $name => $file) {
                if(file_exists($path . $name)) {
                    unlink($path . $name);
                }
                file_put_contents($path . $name, $file);
                chmod($path . $name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            if(file_exists($this->dir.'/includes/application_top.php')) {
                $contents  = file_get_contents($this->dir.'/includes/application_top.php');
                $match = array();
                if(preg_match('/define\s*\(\s*\'PROJECT_VERSION\'\s*,\s*\'[^\']*?v(\d+\.\d+(?:\.\d+)*)[^\']*\'\s*\)/i', $contents, $match)) {
                    return $match[1];
                }
            }
            return '';
        }

    }
