<?php

//$toolId, &$contents, $tool

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
$oldLocale = setlocale(LC_ALL, NULL);
setlocale(LC_ALL, 'en_US.UTF8');

switch($block) {
    case 'head':

        //$tool->params->resetProfile();

        $page = $this->magictoolboxGetPageType();
        $enable = $tool->params->profileExists($page) && !$tool->params->checkValue('enable-effect', 'No', $page)
                  || $page == 'home' && !$tool->params->checkValue('enable-effect', 'No', 'featured')
                  || !$tool->params->checkValue('enable-effect', 'No', 'arrivals')
                  || !$tool->params->checkValue('enable-effect', 'No', 'bestsellers')
                  || !$tool->params->checkValue('enable-effect', 'No', 'recently')
                  ;
        if(!$enable) break;

        $headers = $tool->getHeadersTemplate(MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/magiczoom');

        $scrollHeaders = '';
        $productHeaders = '';
        if($page == 'product') {
            if($tool->params->checkValue('magicscroll', 'Yes', 'product')) {
                $scroll = &MagicToolboxHelper::loadCoreClass($toolId, true);
                $scroll->params->resetProfile();
                $scrollHeaders = $scroll->getHeadersTemplate(MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/magiczoom', null, false);
            }
            if($tool->params->checkValue('enable-effect', 'Yes', 'product')) {
                $mouseEvent = $tool->params->getValue('selectorTrigger', 'product');
                if($mouseEvent == 'hover') $mouseEvent = 'mouseover';
                $productHeaders = "
<script type=\"text/javascript\">
    var magictoolboxModuleId = 'MagicZoom';
    var magictoolboxModuleClass = 'MagicZoom';
    var magictoolboxEvent = '".$mouseEvent."';
    //NOTE: in order to have time to switch the picture
    var switchDelay = 350;
    if(magictoolboxEvent == 'mouseover') switchDelay = switchDelay + 60;
    var magicJSAddEventMethod = 'je1';
    if(typeof(magicJS.Doc.je1) == 'undefined') magicJSAddEventMethod = 'jAddEvent';
</script>
";
                $productHeaders .= '<script type="text/javascript" src="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/product.js"></script>';
            }
        }

        //ideal comfort
        //.product-details .image width = thumb-max-width
        //.product-details .details margin-left = thumb-max-width

        if(MagicToolboxHelper::headers('magicslideshow')) {
            $contents = str_replace('<!-- Magic Slideshow X-Cart module', $headers.$scrollHeaders.$productHeaders."\r\n".'<!-- Magic Slideshow X-Cart module', $contents);
        } else {
            $contents .= $headers.$scrollHeaders.$productHeaders;
        }

        MagicToolboxHelper::headers('magiczoom', true);

    break;
    case 'detailed':
        global $config;
        if($config['Detailed_Product_Images']['det_image_popup'] == 'Y') {
            //debug_log('detailed popup: '.$toolId);
            $contents = '<!-- MAGICZOOM:DETAILED_PRODUCT_IMAGES_START -->'.$contents.'<!-- MAGICZOOM:DETAILED_PRODUCT_IMAGES_END -->';
            break;
        } else {
            //debug_log('detailed tab: '.$toolId);
            $isDetailedImagesTab = true;
        }
    case 'product':
        global $active_modules, $config;
        if(!isset($isDetailedImagesTab)) $isDetailedImagesTab = false;
        //if($block == 'product') debug_log('product: '.$toolId);


        $product = $this->{$this->magictoolboxGetTemplateVars}('product');
        $productId = $product['productid'];
        $mainImage = MagicToolboxHelper::getProductImages($productId, 'variant', $toolId);
        if(empty($mainImage)) {
            $mainImage = MagicToolboxHelper::getProductImages($productId, 'main', $toolId);
        }
        $productInfo = MagicToolboxHelper::getProductInfo($productId);
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);

        if(empty($mainImage)) {
            if(!$isDetailedImagesTab) return;
            //NOTE: to hide message when use main template for each images
            $tool->params->setValue('show-message', 'No', 'product');
            $mainImagePath = '';
        } else {
            $mainImagePath = $mainImage[0]['path'];
            $mainImageData = array(
                'id' => 'MainImage'.$productId,
                'title' => empty($mainImage[0]['alt']) ? $productInfo['title']: $mainImage[0]['alt'],
                'alt' => $mainImage[0]['alt'],
                'shortDescription' => $productInfo['short_description'],
                'description' => $productInfo['description'],
            );
            if($mainImage[0]['is_url']) {
                $mainImageData['img'] = $mainImage[0]['path'];
                //$mainImageData['thumb'] = $mainImage[0]['path'];
                $mainImageData['width'] = $tool->params->getValue('thumb-max-width');
                if(empty($mainImageData['width'])) $mainImageData['width'] = 'auto';
                $mainImageData['height'] = $tool->params->getValue('thumb-max-height');
                if(empty($mainImageData['height'])) $mainImageData['height'] = 'auto';
            } else {
                $mainImageData['img'] = $helper->create('/'.$mainImage[0]['path'], 'original', $productId);
                $mainImageData['img'] = MagicToolboxHelper::fixImageName($mainImageData['img']);
                $mainImageData['thumb'] = $helper->create('/'.$mainImage[0]['path'], 'thumb', $productId);
                $mainImageData['thumb'] = MagicToolboxHelper::fixImageName($mainImageData['thumb']);
            }
            $mainImageHTML = $tool->getMainTemplate($mainImageData);
            if($this->magictoolboxCooperativeMode) {
                $mainImageHTML = 
                    '<div style="position: relative;">'.
                        '<div id="mainImageContainer'.$productId.'" style="position: absolute; left: -5000px;">'.
                            //NOTE: we need this div because of MZP clones the parent node
                            '<div>'.$mainImageHTML.'</div>'.
                        '</div>'.
                        '<div id="magic360Container'.$productId.'">'.$this->magictoolbox360HTML.'</div>'.
                    '</div>';
            }

        }

        $detailedImages = MagicToolboxHelper::getProductImages($productId, 'detailed', $toolId);
        $detailedImagesCount = count($detailedImages);
        $additionalImagesHTML = array();
        $detailedImagesEnabled = !empty($active_modules['Detailed_Product_Images']) && $detailedImagesCount &&
                                 ($isDetailedImagesTab || $config['Detailed_Product_Images']['det_image_popup'] == 'Y');
        if($detailedImagesEnabled) {
            if(empty($mainImage)) {
                $width = $tool->params->getValue('thumb-max-width');
                if(empty($width)) $width = 'auto';
                $height = $tool->params->getValue('thumb-max-height');
                if(empty($height)) $height = 'auto';
                //if($this->magictoolboxCooperativeMode) {
                    //NOTE: Magic360 module is already applied in place of the main image
                    //$additionalImagesHTML[] = $this->magictoolbox360HTML;
                //}
            } else {
                $width = $tool->params->getValue('selector-max-width');
                if(empty($width)) $width = 'auto';
                $height = $tool->params->getValue('selector-max-height');
                if(empty($height)) $height = 'auto';
                //add selector for main image
                if($mainImage[0]['is_url']) {
                    //$mainImageData['img'] = $image['path'];
                    //$mainImageData['medium'] = $image['path'];
                    //$mainImageData['thumb'] = $image['path'];
                    $mainImageData['width'] = $width;
                    $mainImageData['height'] = $height;
                } else {
                    //$mainImageData['img'] = $helper->create('/'.$mainImage[0]['path'], 'original', $productId);
                    //$mainImageData['medium'] = $helper->create('/'.$mainImage[0]['path'], 'thumb', $productId);
                    $mainImageData['medium'] = $mainImageData['thumb'];
                    $mainImageData['thumb'] = $helper->create('/'.$mainImage[0]['path'], 'selector', $productId);
                    $mainImageData['thumb'] = MagicToolboxHelper::fixImageName($mainImageData['thumb']);
                }
                $selector = $tool->getSelectorTemplate($mainImageData);
                $additionalImagesHTML[] = str_replace('<a ', '<a class="mt-selector" ', $selector);
                if($this->magictoolboxCooperativeMode) {
                    if(!empty($this->magictoolbox360Icon) && file_exists(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.$this->magictoolbox360Icon)) {
                        $magic360Icon = $helper->create('/'.$this->magictoolbox360Icon, 'selector', 'magic360icon');
                        array_unshift(
                            $additionalImagesHTML,
                            '<a class="mt-selector m360-selector active-selector" title="360" href="#" onclick="return false;"><img src="'.$magic360Icon.'" alt="360" /></a>'
                        );
                    }
                }
            }
            foreach($detailedImages as $image) {
                if($image['path'] == $mainImagePath) continue;
                if($image['is_url']) {
                    if(empty($mainImage)) {
                        $additionalImagesHTML[] = $tool->getMainTemplate(array(
                            'id' => 'MainImage'.$productId.md5($image['path']),
                            'img' => $image['path'],
                            //'thumb' => $image['path'],
                            'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                            'alt' => $image['alt'],
                            'width' => $width,
                            'height' => $height
                        ));
                    } else {
                        $selector = $tool->getSelectorTemplate(array(
                            'id' => 'MainImage'.$productId,
                            'img' => $image['path'],
                            //'medium' => $image['path'],
                            //'thumb' => $image['path'],
                            'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                            'alt' => $image['alt'],
                            'width' => $width,
                            'height' => $height
                        ));
                        $additionalImagesHTML[] = str_replace('<a ', '<a class="mt-selector" ', $selector);
                    }
                } else {
                    if(empty($mainImage)) {
                        $additionalImagesHTML[] = $tool->getMainTemplate(array(
                            'id' => 'MainImage'.$productId.md5($image['path']),
                            'img' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'original', $productId)),
                            'thumb' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'thumb', $productId)),
                            'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                            'alt' => $image['alt']
                        ));
                    } else {
                        $selector = $tool->getSelectorTemplate(array(
                            'id' => 'MainImage'.$productId,
                            'img' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'original', $productId)),
                            'medium' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'thumb', $productId)),
                            'thumb' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'selector', $productId)),
                            'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                            'alt' => $image['alt']
                        ));
                        $additionalImagesHTML[] = str_replace('<a ', '<a class="mt-selector" ', $selector);
                    }
                }
            }
        }
        else if($this->magictoolboxCooperativeMode && !empty($mainImage)) {
            //NOTE: to not display a 360 and main selectors for the second time
            if($block != 'product' || $config['Detailed_Product_Images']['det_image_popup'] == 'Y') {
                $width = $tool->params->getValue('selector-max-width');
                if(empty($width)) $width = 'auto';
                $height = $tool->params->getValue('selector-max-height');
                if(empty($height)) $height = 'auto';
                //NOTE: add selector for main image
                if($mainImage[0]['is_url']) {
                    $mainImageData['width'] = $width;
                    $mainImageData['height'] = $height;
                } else {
                    $mainImageData['medium'] = $mainImageData['thumb'];
                    $mainImageData['thumb'] = $helper->create('/'.$mainImage[0]['path'], 'selector', $productId);
                    $mainImageData['thumb'] = MagicToolboxHelper::fixImageName($mainImageData['thumb']);
                }
                $selector = $tool->getSelectorTemplate($mainImageData);
                $additionalImagesHTML[] = str_replace('<a ', '<a class="mt-selector" ', $selector);
                if(!empty($this->magictoolbox360Icon) && file_exists(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.$this->magictoolbox360Icon)) {
                    $magic360Icon = $helper->create('/'.$this->magictoolbox360Icon, 'selector', 'magic360icon');
                    array_unshift(
                        $additionalImagesHTML,
                        '<a class="mt-selector m360-selector active-selector" title="360" href="#" onclick="return false;"><img src="'.$magic360Icon.'" alt="360" /></a>'
                    );
                }
            }
        }

        if($this->magictoolboxCooperativeMode) {
            foreach($additionalImagesHTML as &$selector) {
                if(preg_match('#(<a\b[^>]*?\bclass=")([^"]*+")#i', $selector, $_match)) {
                    $selector = str_replace($_match[0], $_match[1].'zoom-with-360 '.$_match[2], $selector);
                } else {
                    $selector = str_replace('<a ', '<a class="zoom-with-360" ', $selector);
                }
            }
        }

        if($isDetailedImagesTab) {
            if($tool->params->checkValue('magicscroll', 'No', 'product')) {
                $html = '<div class="magictoolbox-selectors-list">'.
                        '<div class="magictoolbox-selector-container">'.
                        implode('</div><div class="magictoolbox-selector-container">', $additionalImagesHTML).
                        '</div>'.
                        '<div style="clear:both;"></div>'.
                        '</div>';
            } else {
                $scroll = &MagicToolboxHelper::loadCoreClass($toolId, true);
                $magicscrollOptions = $scroll ? $scroll->params->serialize(false, '', 'product-magicscroll-options') : '';
                $html = '<div class="magictoolbox-selectors-list">'.
                        '<div id="MagicToolboxSelectors'.$productId.'" class="MagicToolboxSelectorsContainer'.($scroll ? ' MagicScroll' : '').'" data-options="'.$magicscrollOptions.'">'.
                        implode('', $additionalImagesHTML).
                        '</div>'.
                        '<div style="clear:both;"></div>'.
                        '</div>';
            }
            $pattern = '(?:<div[^>]+?class="[^"]*?dpimage-container[^"]*"[^>]*>[^<]*<img[^>]*>[^<]*<\/div>[^<]*)+';
            $pattern = '<div[^>]+?class="[^"]*?dpimages-list[^"]*"[^>]*>[^<]*'.$pattern.'<\/div>|'.$pattern.'|(?:<img[^>]*>[^<]*(?:<br[^>]*>[^<]*)?)+';
        } else {
            $additionalScriptHTML = array();
            $additionalScriptHTML[] = "\n<script type=\"text/javascript\">";
            $additionalScriptHTML[] = "\n\tvar magictoolboxProductId = '{$productId}';";
            $additionalScriptHTML[] = "\n</script>\n";

            $variantImages = MagicToolboxHelper::getProductImages($productId, 'variants', $toolId);
            $variantImagesCount = count($variantImages);
            $variantImagesHTML = array();
            if($variantImagesCount) {
                $variantImagesHTML[] = "\n<script type=\"text/javascript\">";
                $variantImagesHTML[] = "\n\tvar magictoolboxMainImage = {};";
                $variantImagesHTML[] = "\n\tmagictoolboxMainImage.image = '{$mainImageData['img']}';";
                if(isset($mainImageData['medium'])) {
                    $variantImagesHTML[] = "\n\tmagictoolboxMainImage.thumb = '{$mainImageData['medium']}';";
                } else {
                    $variantImagesHTML[] = "\n\tmagictoolboxMainImage.thumb = '{$mainImageData['thumb']}';";
                }
                $variantImagesHTML[] = "\n\tvar magictoolboxVariantImages = [];";
                foreach($variantImages as $image) {
                    $variantImagesHTML[] = "\n\tmagictoolboxVariantImages[{$image['id']}] = {};";
                    if($image['is_url']) {
                        $variantImagesHTML[] = "\n\tmagictoolboxVariantImages[{$image['id']}].image = '{$image['path']}';";
                        $variantImagesHTML[] = "\n\tmagictoolboxVariantImages[{$image['id']}].thumb = '{$image['path']}';";
                    } else {
                        $img = $helper->create('/'.$image['path'], 'original', $productId);
                        $img = MagicToolboxHelper::fixImageName($img);
                        $variantImagesHTML[] = "\n\tmagictoolboxVariantImages[{$image['id']}].image = '{$img}';";
                        $img = $helper->create('/'.$image['path'], 'thumb', $productId);
                        $img = MagicToolboxHelper::fixImageName($img);
                        $variantImagesHTML[] = "\n\tmagictoolboxVariantImages[{$image['id']}].thumb = '{$img}';";
                    }
                }
                $variantImagesHTML[] = "\n</script>\n";
            }

            require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'magiczoom'.DIRECTORY_SEPARATOR.'magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DIRECTORY_SEPARATOR.'magiczoom'.DIRECTORY_SEPARATOR .'templates');
            MagicToolboxTemplateHelperClass::setOptions($tool->params);
            $scroll = &MagicToolboxHelper::loadCoreClass($toolId, true);
            $html = MagicToolboxTemplateHelperClass::render(array(
                'main' => $mainImageHTML,
                'thumbs' => $additionalImagesHTML,
                'magicscrollOptions' => $scroll ? $scroll->params->serialize(false, '', 'product-magicscroll-options') : '',
                'pid' => $productId,
            ));
            $html .= implode('', $additionalScriptHTML);
            $html .= '<img id="product_thumbnail" scr="data:image/gif;base64,R0lGODlhAQABAAAAACwAAAAAAQABAAA=" alt="" style="display: none !important;" />';
            $html .= implode('', $variantImagesHTML);
            if($detailedImagesEnabled) {
                //$pattern = '<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_START -->.*?'.
                //            '<div[^>]*?class="[^"]*?image-box[^"]*"[^>]*>[^<]*(?:'.$pattern.')[^<]*<\/div>'.
                //            '.*?<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_END -->';
                $pattern = '<!-- MAGICZOOM:DETAILED_PRODUCT_IMAGES_START -->.*?<!-- MAGICZOOM:DETAILED_PRODUCT_IMAGES_END -->';
                $html = '<div class="image-box">'.$html.'</div>';
            } else {
                if(empty($product['image_url'])) {
                    //$current_location.'/image.php?type='.{$product.image_type|default:"T"}.'&amp;id='.{$product.image_id}
                    //$xcart_web_dir.'/image.php?type='.{$product.image_type|default:"T"}.'&amp;id='.{$product.image_id}
                    $tmbn_url = '';//???????
                } else {
                    $tmbn_url = $product['image_url'];
                }
                $imagePattern = '<img[^>]*?(?:id="product_thumbnail"|src="'.preg_quote($tmbn_url, '/').'")[^>]*>';
                $pattern = '<a[^>]*>[^<]*'.$imagePattern.'[^<]*<\/a>|'.$imagePattern;
                if($this->magictoolboxCooperativeMode) {
                    $pattern = '<a\b[^>]*?id="productMagic360"[^>]*+><img\b[^>]*+><\/a><div\b[^>]*?class="MagicToolboxMessage"[^>]*+>[^<]*+<\/div>';
                }
            }
        }
        $contents = preg_replace('/'.$pattern.'/is', $html, $contents, 1);

        $this->magictoolboxProcessedBlocks[$block] = $toolId;
        $this->magictoolboxCooperativeMode = false;//NOTE: reset cooperative mode flag
        //$this->magictoolboxSecondaryModule = $toolId;

    break;
    case 'search':
        //$products = $this->_tpl_vars['products'];
        $products = $this->{$this->magictoolboxGetTemplateVars}('products');
        if(!is_array($products) || empty($products)) break;
        $group = 'Category';
        global $cat, $page, $cat_str, $page_str;
        $linkSufix = (isset($cat_str) ? $cat_str : '&amp;cat='.(isset($cat) ? $cat : '')).(isset($page_str) ? $page_str : '&amp;page='.(isset($page) ? $page : ''));
    case 'category':
        if($block == 'category') {
            /*
            if(isset($this->_tpl_vars['cat_products'])) {
                $products = $this->_tpl_vars['cat_products'];
            } else {
                //for X-Cart 4.1.x
                $products = $this->_tpl_vars['products'];
            }
            */
            $products = $this->{$this->magictoolboxGetTemplateVars}('cat_products');
            if(empty($products)) {
                //for X-Cart 4.1.x
                $products = $this->{$this->magictoolboxGetTemplateVars}('products');
            }
            if(!is_array($products) || empty($products)) break;
            $group = 'Category';
            global $cat, $page, $cat_str, $page_str;
            $linkSufix = (isset($cat_str) ? $cat_str : '&amp;cat='.(isset($cat) ? $cat : '')).(isset($page_str) ? $page_str : '&amp;page='.(isset($page) ? $page : ''));
        }
    case 'featured':
        if($block == 'featured') {
            //$products = $this->_tpl_vars['f_products'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('f_products');
            if(!is_array($products) || empty($products)) break;
            $group = 'Featured';
            //$cat = isset($this->_tpl_vars['cat']) ? $this->_tpl_vars['cat'] : '';
            $cat = $this->{$this->magictoolboxGetTemplateVars}('cat');
            if(empty($cat)) $cat = '';
            $linkSufix = "&amp;cat={$cat}&amp;featured=Y";
        }
    case 'arrivals':
        if($block == 'arrivals') {
            //$products = $this->_tpl_vars['new_arrivals'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('new_arrivals');
            if(!is_array($products) || empty($products)) break;
            $group = 'Arrivals';
            $linkSufix = '';
        }
    case 'recently':
        if($block == 'recently') {
            //NOTE: key changed since 4.6 version
            //$products = isset($this->_tpl_vars['rviewed_products']) ? $this->_tpl_vars['rviewed_products'] : $this->_tpl_vars['recently_viewed_products'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('rviewed_products');
            if(empty($products)) {
                $products = $this->{$this->magictoolboxGetTemplateVars}('recently_viewed_products');
            }

            //NOTE: for X-Cart 4.7.x
            if(empty($products) && function_exists('func_tpl_get_recently_viewed_products')) {
                $products = func_tpl_get_recently_viewed_products();
            }

            if(!is_array($products) || empty($products)) break;
            $group = 'Recently';
            $linkSufix = '';
        }
    case 'bestsellers':
        if($block == 'bestsellers') {
            //$products = $this->_tpl_vars['bestsellers'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('bestsellers');

            //NOTE: for X-Cart 4.7.x
            if(empty($products) && function_exists('func_tpl_get_bestsellers')) {
                $products = func_tpl_get_bestsellers();
            }

            if(!is_array($products) || empty($products)) break;
            $group = 'Bestsellers';
            //$cat = isset($this->_tpl_vars['cat']) ? $this->_tpl_vars['cat'] : '';
            $cat = $this->{$this->magictoolboxGetTemplateVars}('cat');
            if(empty($cat)) $cat = '';
            $linkSufix = "&amp;cat={$cat}&amp;bestseller=Y";
        }
        $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);
        foreach($products as $key => $product) {
            $image = MagicToolboxHelper::getProductImages($product['productid'], 'main', $toolId);
            if(empty($image)) continue;
            $productInfo = MagicToolboxHelper::getProductInfo($product['productid']);
            if($useLink) {
                $link = isset($product['page_url']) ? $product['page_url'] : 'product.php?productid='.$product['productid'].$linkSufix;
                //if(strpos($link, 'http') !== 0) $link = MagicToolboxHelper::getConfig('xcart_web_dir').'/'.$link;
            } else {
                $link = '';
            }
            $imageData = array(
                'id' => $group.$product['productid'],
                'group' => $group,
                'link' => $link,
                'title' => $productInfo['title'],
                'alt' => $image[0]['alt'],//NOTE: if the main image has an alternative text!?
                'shortDescription' => $productInfo['short_description'],
                'description' => $productInfo['description'],
            );
            if($image[0]['is_url']) {
                $imageData['img'] = $image[0]['path'];
                //$imageData['thumb'] = $image[0]['path'];
                $imageData['width'] = $tool->params->getValue('thumb-max-width');
                if(empty($imageData['width'])) $imageData['width'] = 'auto';
                $imageData['height'] = $tool->params->getValue('thumb-max-height');
                if(empty($imageData['height'])) $imageData['height'] = 'auto';
            } else {
                $imageData['img'] = $helper->create('/'.$image[0]['path'], 'original', $product['productid']);
                $imageData['img'] = MagicToolboxHelper::fixImageName($imageData['img']);
                $imageData['thumb'] = $helper->create('/'.$image[0]['path'], 'thumb', $product['productid']);
                $imageData['thumb'] = MagicToolboxHelper::fixImageName($imageData['thumb']);
            }
            $html = $tool->getMainTemplate($imageData);
            //$html = '<div class="MagicToolboxContainer">'.$html.'</div>';

            if(empty($product['tmbn_url'])) {
                $tmbn_url = '/image.php?type=T&amp;id='.$product['productid'];
                $tmbn_url = '.*?'.preg_quote($tmbn_url, '/');
            } else {
                $tmbn_url = $product['tmbn_url'];
                if(function_exists('func_convert_amp')) {
                    $tmbn_url = func_convert_amp($tmbn_url);
                }
                $tmbn_url = preg_quote($tmbn_url, '/');
            }
            $imagePattern = '<img[^>]*?src="'.$tmbn_url.'"[^>]*>';
            if($block == 'bestsellers') {
                $imagePattern = '(?:'.$imagePattern.'|<img[^>]*?src="[^"]*?id='.$product['productid'].'[^"]*"[^>]*>)';
            }

            $pattern = '<a[^>]*?href="[^"]*?productid='.$product['productid'].'[^"]*"[^>]*>[^<]*'.$imagePattern.'[^<]*<\/a>';
            //NOTE: to cut spacer on product list pages
            $pattern  = '(<img[^>]*?src="[^"]*?spacer\.gif"[^>]*>[^<]*)?'.$pattern;
            $matches = array();
            if(preg_match('/'.$pattern.'/is', $contents, $matches)) {
                $contents = str_replace($matches[0], $html, $contents);
            } else {
                $pattern = $imagePattern;
                //FIXME: in this case,if some products have no thumbnail, default image will be displayed
                //       it can replace the wrong image
                $contents = preg_replace('/'.$pattern.'/is', $html, $contents, 1);
            }
        }
        $this->magictoolboxProcessedBlocks[$block] = $toolId;
    break;
    default: break;
}

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
setlocale(LC_ALL, $oldLocale);

?>
