<?php

require './auth.php';
require $xcart_dir.'/include/security.php';
if(!defined('XCART_START')) { header("Location: ../"); die("Access denied"); }

// ini_set('display_errors', false);
// error_reporting(E_ALL & ~E_NOTICE);

global $xcart_tbl_prefix;
$table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');

$action = isset($_POST['magiczoom-submit-action']) ? $_POST['magiczoom-submit-action'] : false;
$activeTab = isset($_POST['magiczoom-active-tab']) ? $_POST['magiczoom-active-tab'] : false;

if($action == 'reset') {
    db_query("DELETE FROM `{$table_prefix}magiczoom`");
}

$tool = &MagicToolboxHelper::loadCoreClass('MagicZoom');

$adminPath = MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/admin';

$paramData = $tool->params->getParam('magicscroll', 'product', false);
$paramData['description'] = '<img id="magicscroll_icon" src="'.
    $adminPath.'/magiczoom/resources/images/magicscroll.png" />'.
    $paramData['description'];
$tool->params->appendParams(array('magicscroll' => $paramData), 'product');

require_once(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.'magiczoom.params.php');


$params = isset($_POST['magiczoom']) ? $_POST['magiczoom'] : false;

if($action == 'save') {

    foreach(func_get_magiczoom_params_map() as $blockId => $groups) {
        foreach($groups as $group) {
            foreach($group as $param => $required) {
                if(isset($params[$blockId][$param])) {
                    $value = $params[$blockId][$param];
                    switch($tool->params->getType($param)) {
                        case 'num':
                            $value = intval($value);
                            break;
                        case 'array':
                            $value = trim($value);
                            if(!in_array($value, $tool->params->getValues($param))) $value = $tool->params->getDefaultValue($param);
                            break;
                        case 'text':
                            $value = addslashes(trim($value));
                            break;
                        default: $value = trim($value);
                    }
                    db_query("UPDATE `{$table_prefix}magiczoom` SET `value`='{$value}', `enabled`=1 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    $tool->params->setValue($param, $value, $blockId);
                } else {
                    db_query("UPDATE `{$table_prefix}magiczoom` SET `enabled`=0 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    if($tool->params->paramExists($param, $blockId)) {
                        $tool->params->removeParam($param, $blockId);
                    };
                }
            }
        }
    }
}

include(
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'admin'.DIRECTORY_SEPARATOR.
    'magiczoom'.DIRECTORY_SEPARATOR.
    'magictoolbox.settings.editor.class.php'
);

$settings = new MagictoolboxSettingsEditorClass(
    //NOTE: path to js files
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'magiczoom'
);
$settings->paramsMap = func_get_magiczoom_params_map();
$settings->core = &MagicToolboxHelper::loadCoreClass('MagicZoom');
$settings->profiles = func_get_magiczoom_blocks();
$settings->action = htmlentities($_SERVER['REQUEST_URI']);
$settings->setResourcesURL($adminPath.'/magiczoom/resources/');
$settings->namePrefix = 'magiczoom';
if($activeTab) {
    $settings->activeTab = $activeTab;
}

$generatedFormId = '';
if(function_exists('func_generate_formid')) {
    if(function_exists('db_connection')) {
        db_connection($sql_host, $sql_user, $sql_db, $sql_password);
        $generatedFormId = func_generate_formid();
    } else {
        db_connect($sql_host, $sql_user, $sql_password);
        db_select_db($sql_db);
        $generatedFormId = func_generate_formid();
    }
}
$settings->setInputValue('_formid', $generatedFormId);

$settings->customSlideshowGroupTitle = 'Setup slideshow for home page';

$html = $settings->getHTML();

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Magic Zoom settings editor</title>
<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    width: 80%;
    line-height: 18px;
}
</style>
</head>
<body>
<div id="container">
<?php echo $html; ?>
</div>
</body>
</html>
