<?php

require './auth.php';
require $xcart_dir.'/include/security.php';
if(!defined('XCART_START')) { header("Location: ../"); die("Access denied"); }

// ini_set('display_errors', false);
// error_reporting(E_ALL & ~E_NOTICE);

global $xcart_tbl_prefix;
$table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');

$action = isset($_POST['magicslideshow-submit-action']) ? $_POST['magicslideshow-submit-action'] : false;
$activeTab = isset($_POST['magicslideshow-active-tab']) ? $_POST['magicslideshow-active-tab'] : false;

$tabels = func_query_column("SHOW TABLES LIKE '{$table_prefix}magicslideshow_images'");
if(empty($tabels)) {
    db_query("CREATE TABLE {$table_prefix}magicslideshow_images (
                    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
                    `name` VARCHAR(64) NOT NULL,
                    `title` VARCHAR(64) DEFAULT '',
                    `description` TEXT,
                    `link` VARCHAR(256) DEFAULT '',
                    `order` INT UNSIGNED DEFAULT 0,
                    `exclude` INT(2) UNSIGNED DEFAULT 0,
                    PRIMARY KEY (id)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
    );
}

if($action == 'reset') {
    db_query("DELETE FROM `{$table_prefix}magicslideshow`");
}

$tool = &MagicToolboxHelper::loadCoreClass('MagicSlideshow');

$adminPath = MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/admin';

require_once(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.'magicslideshow.params.php');

$imageBasePath = MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'magicslideshow'.DIRECTORY_SEPARATOR;
$imageBaseUrl = MagicToolboxHelper::getConfig('xcart_web_dir').'/images/magicslideshow/';

$params = isset($_POST['magicslideshow']) ? $_POST['magicslideshow'] : false;

if($action == 'save') {

    foreach(func_get_magicslideshow_params_map() as $blockId => $groups) {
        foreach($groups as $group) {
            foreach($group as $param => $required) {
                if(isset($params[$blockId][$param])) {
                    $value = $params[$blockId][$param];
                    switch($tool->params->getType($param)) {
                        case 'num':
                            $value = intval($value);
                            break;
                        case 'array':
                            $value = trim($value);
                            if(!in_array($value, $tool->params->getValues($param))) $value = $tool->params->getDefaultValue($param);
                            break;
                        case 'text':
                            $value = addslashes(trim($value));
                            break;
                        default: $value = trim($value);
                    }
                    db_query("UPDATE `{$table_prefix}magicslideshow` SET `value`='{$value}', `enabled`=1 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    $tool->params->setValue($param, $value, $blockId);
                } else {
                    db_query("UPDATE `{$table_prefix}magicslideshow` SET `enabled`=0 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    if($tool->params->paramExists($param, $blockId)) {
                        $tool->params->removeParam($param, $blockId);
                    };
                }
            }
        }
    }

    // save images data
    $imagesUpdateData = isset($_POST['images-update-data']) ? $_POST['images-update-data'] : array();

    foreach($imagesUpdateData as $imageId => $imageData) {
        if ((int)$imageData['delete']) {
            $imagesData = func_query_first("SELECT `name` FROM {$table_prefix}magicslideshow_images WHERE `id`={$imageId}");
            if(!empty($imagesData)) {
                @unlink($imageBasePath.$imagesData['name']);
                db_query("DELETE FROM {$table_prefix}magicslideshow_images WHERE `id`={$imageId}");
            }
        } else {
            $imageData['title'] = htmlspecialchars($imageData['title']);
            $imageData['description'] = htmlspecialchars($imageData['description']);
            $imageData['link'] = htmlspecialchars($imageData['link']);
            $imageData['order'] = intval($imageData['order']);
            $imageData['exclude'] = isset($imageData['exclude']) ? 1 : 0;
            db_query(
                "UPDATE {$table_prefix}magicslideshow_images SET ".
                "`title`='{$imageData['title']}', ".
                "`description`='{$imageData['description']}', ".
                "`link`='{$imageData['link']}', ".
                "`order`={$imageData['order']}, ".
                "`exclude`={$imageData['exclude']} ".
                "WHERE `id`={$imageId}"
            );
        }
    }
}

if($action == 'upload' && !empty($_FILES['magicslideshow-image-files']['tmp_name'])) {
    if(is_dir($imageBasePath) || mkdir($imageBasePath)) {
        foreach($_FILES['magicslideshow-image-files']['tmp_name'] as $key => $tempName) {
            if(!empty($tempName) && file_exists($tempName)) {
                $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicslideshow-image-files']['name'][$key]);
                $ext = substr($name, strrpos($name, '.'));
                $name = substr($name, 0, -strlen($ext));
                $index = 0;
                $suffix = '';
                while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                    $suffix = "({$index})";
                    $index++;
                }
                if(!move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                    //An error occurred during the image upload.
                    break;
                }
                db_query("INSERT INTO {$table_prefix}magicslideshow_images (`name`) VALUES ('{$name}{$suffix}{$ext}')");
            }
        }
    }
}

include(
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'admin'.DIRECTORY_SEPARATOR.
    'magicslideshow'.DIRECTORY_SEPARATOR.
    'magictoolbox.settings.editor.class.php'
);

$settings = new MagictoolboxSettingsEditorClass(
    //NOTE: path to js files
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'magicslideshow'
);
$settings->paramsMap = func_get_magicslideshow_params_map();
$settings->core = &MagicToolboxHelper::loadCoreClass('MagicSlideshow');
$settings->profiles = func_get_magicslideshow_blocks();
$settings->action = htmlentities($_SERVER['REQUEST_URI']);
$settings->setResourcesURL($adminPath.'/magicslideshow/resources/');
$settings->namePrefix = 'magicslideshow';
if($activeTab) {
    $settings->activeTab = $activeTab;
}
$settings->imageBaseUrl = $imageBaseUrl;
$imagesData = func_query("SELECT * FROM {$table_prefix}magicslideshow_images ORDER BY `order`");
if ($imagesData) {
    $settings->customSlideshowImagesData = $imagesData;
}

$generatedFormId = '';
if(function_exists('func_generate_formid')) {
    if(function_exists('db_connection')) {
        db_connection($sql_host, $sql_user, $sql_db, $sql_password);
        $generatedFormId = func_generate_formid();
    } else {
        db_connect($sql_host, $sql_user, $sql_password);
        db_select_db($sql_db);
        $generatedFormId = func_generate_formid();
    }
}
$settings->setInputValue('_formid', $generatedFormId);

$settings->customSlideshowGroupTitle = 'Setup slideshow for home page';

$html = $settings->getHTML();

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Magic Slideshow settings editor</title>
<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    width: 80%;
    line-height: 18px;
}
</style>
</head>
<body>
<div id="container">
<?php echo $html; ?>
</div>
</body>
</html>
