<?php

//$toolId, &$contents, $tool

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
$oldLocale = setlocale(LC_ALL, NULL);
setlocale(LC_ALL, 'en_US.UTF8');

switch($block) {
    case 'head':

        //$tool->params->resetProfile();

        $page = $this->magictoolboxGetPageType();
        $enable = $tool->params->profileExists($page) && !$tool->params->checkValue('enable-effect', 'No', $page)
                  || !$tool->params->checkValue('enable-effect', 'No', 'bestsellers')
                  || !$tool->params->checkValue('enable-effect', 'No', 'recently')
                  || $page == 'home' && !$tool->params->checkValue('enable-effect', 'No', 'homeslideshow')
                  ;
        if(!$enable) break;

        $headers = $tool->getHeadersTemplate(MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/magicscroll');


        //ideal comfort
        //.product-details .image width = thumb-max-width
        //.product-details .details margin-left = thumb-max-width

        $contents .= $headers;

        MagicToolboxHelper::headers('magicscroll', true);

    break;
    case 'homeslideshow':
        global $xcart_tbl_prefix;
        $table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');

        $tabels = func_query_column("SHOW TABLES LIKE '{$table_prefix}magicscroll_images'");
        if(empty($tabels)) break;
        $imagesData = func_query("SELECT * FROM {$table_prefix}magicscroll_images ORDER BY `order`");
        if(empty($imagesData)) break;
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);
        $homeSlideshowData = array();
        foreach($imagesData as $imageData) {
                if($imageData['exclude']) continue;
                $img = MagicToolboxHelper::fixImageName($helper->create('/images/magicscroll/'.$imageData['name'], 'thumb', 'homeslideshow'));
                if(empty($img)) continue;
                $homeSlideshowData[] = array(
                    'img' => $img,
                    'title' => $imageData['title'],
                    'alt' => $imageData['title'],
                    'description' => $imageData['description'],
                    'link' => empty($imageData['link']) ? false : $imageData['link']
                );
        }
        if(empty($homeSlideshowData)) break;
        $html = $tool->getMainTemplate($homeSlideshowData, array('id' => 'homeMagicScroll'));
        $html = '<div class="MagicToolboxContainer">'.$html.'</div>';

        //NOTE: spike for 'Ideal Comfort' theme
        if(preg_match('#<(?:td|div)\b[^>]*?class="[^"]*?\bwelcome\-cell\b[^"]*+"[^>]*+>#is', $contents, $matches)) {
            $contents = str_replace($matches[0], $matches[0].$html, $contents);
        } else {
            $contents = $html.$contents;
        }

    break;
    case 'detailed':
        global $config;
        if($config['Detailed_Product_Images']['det_image_popup'] == 'Y') {
            //debug_log('detailed popup: '.$toolId);
            $contents = '<!-- MAGICSCROLL:DETAILED_PRODUCT_IMAGES_START -->'.$contents.'<!-- MAGICSCROLL:DETAILED_PRODUCT_IMAGES_END -->';
            break;
        } else {
            //debug_log('detailed tab: '.$toolId);
            $isDetailedImagesTab = true;
        }
    case 'product':
        global $active_modules, $config;
        if(!isset($isDetailedImagesTab)) $isDetailedImagesTab = false;
        //if($block == 'product') debug_log('product: '.$toolId);

        if($this->magictoolboxCooperativeMode) {
            $this->magictoolboxCooperativeMode = false;//NOTE: reset cooperative mode flag
            break;
        }

        $product = $this->{$this->magictoolboxGetTemplateVars}('product');
        $productId = $product['productid'];
        $mainImage = MagicToolboxHelper::getProductImages($productId, 'main', $toolId);
        $productInfo = MagicToolboxHelper::getProductInfo($productId);
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);


        $detailedImages = MagicToolboxHelper::getProductImages($productId, 'detailed', $toolId);
        $detailedImagesCount = count($detailedImages);
        $additionalImagesData = array();
        $detailedImagesEnabled = !empty($active_modules['Detailed_Product_Images']) && $detailedImagesCount &&
                                 ($isDetailedImagesTab || $config['Detailed_Product_Images']['det_image_popup'] == 'Y');
        if($detailedImagesEnabled) {
            if($detailedImagesCount < $tool->params->getValue('items')) {
                $tool->params->setValue('items', $detailedImagesCount);
            }
            if(!empty($mainImage)) {
                if($mainImage[0]['is_url']) {
                    $additionalImagesData[] = array(
                        'img' => $mainImage[0]['path'],
                        'title' => empty($mainImage[0]['alt']) ? $productInfo['title']: $mainImage[0]['alt'],
                        'alt' => $mainImage[0]['alt'],
                        //'description' => $productInfo['short_description']
                    );
                } else {
                    $additionalImagesData[] = array(
                        'img' => MagicToolboxHelper::fixImageName($helper->create('/'.$mainImage[0]['path'], 'thumb', $productId)),
                        'title' => empty($mainImage[0]['alt']) ? $productInfo['title']: $mainImage[0]['alt'],
                        'alt' => $mainImage[0]['alt'],
                        //'description' => $productInfo['short_description']
                    );
                }
            } else {
                if($detailedImagesCount == 1) break;
            }
            foreach($detailedImages as $image) {
                if($image['path'] == $mainImagePath) continue;
                if($image['is_url']) {
                    $additionalImagesData[] = array(
                        'img' => $image['path'],
                        'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                        'alt' => $image['alt'],
                        //'description' => $productInfo['short_description']
                    );
                } else {
                    $additionalImagesData[] = array(
                        'img' => MagicToolboxHelper::fixImageName($helper->create('/'.$image['path'], 'thumb', $productId)),
                        'title' => empty($image['alt']) ? $productInfo['title']: $image['alt'],
                        'alt' => $image['alt'],
                        //'description' => $productInfo['short_description']
                    );
                }
            }
            $html = $tool->getMainTemplate($additionalImagesData, array('id' => 'productMagicScroll'));
        }

        if($isDetailedImagesTab) {
            //NOTE: wrap div.magicscroll because of conflict with style #product-tabs-dpimages > div { display: block !important; }
            $html = '<div>'.$html.'</div>';
            $pattern = '(?:<div[^>]+?class="[^"]*?dpimage-container[^"]*"[^>]*>[^<]*<img[^>]*>[^<]*<\/div>[^<]*)+';
            $pattern = '<div[^>]+?class="[^"]*?dpimages-list[^"]*"[^>]*>[^<]*'.$pattern.'<\/div>|'.$pattern.'|(?:<img[^>]*>[^<]*(?:<br[^>]*>[^<]*)?)+';
        } else {
            if($detailedImagesEnabled) {
                //$pattern = '<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_START -->.*?'.
                //            '<div[^>]*?class="[^"]*?image-box[^"]*"[^>]*>[^<]*(?:'.$pattern.')[^<]*<\/div>'.
                //            '.*?<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_END -->';
                $pattern = '<!-- MAGICSCROLL:DETAILED_PRODUCT_IMAGES_START -->.*?<!-- MAGICSCROLL:DETAILED_PRODUCT_IMAGES_END -->';
                $html = '<div class="image-box">'.$html.'</div>';
            } else {
                break;
            }
        }
        $contents = preg_replace('/'.$pattern.'/is', $html, $contents, 1);

        //$this->magictoolboxProcessedBlocks[$block] = $toolId;
        $this->magictoolboxProcessedBlocks['detailed'] = $toolId;
        $this->magictoolboxProcessedBlocks['product'] = $toolId;

    break;
    case 'recently':
        if($block == 'recently') {
            //NOTE: key changed since 4.6 version
            //$products = isset($this->_tpl_vars['rviewed_products']) ? $this->_tpl_vars['rviewed_products'] : $this->_tpl_vars['recently_viewed_products'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('rviewed_products');
            if(empty($products)) {
                $products = $this->{$this->magictoolboxGetTemplateVars}('recently_viewed_products');
            }

            //NOTE: for X-Cart 4.7.x
            if(empty($products) && function_exists('func_tpl_get_recently_viewed_products')) {
                $products = func_tpl_get_recently_viewed_products();
            }

            if(!is_array($products) || empty($products)) break;
            $group = 'Recently';
            $linkSufix = '';
        }
    case 'bestsellers':
        if($block == 'bestsellers') {
            //$products = $this->_tpl_vars['bestsellers'];
            $products = $this->{$this->magictoolboxGetTemplateVars}('bestsellers');

            //NOTE: for X-Cart 4.7.x
            if(empty($products) && function_exists('func_tpl_get_bestsellers')) {
                $products = func_tpl_get_bestsellers();
            }

            if(!is_array($products) || empty($products)) break;
            $group = 'Bestsellers';
            //$cat = isset($this->_tpl_vars['cat']) ? $this->_tpl_vars['cat'] : '';
            $cat = $this->{$this->magictoolboxGetTemplateVars}('cat');
            if(empty($cat)) $cat = '';
            $linkSufix = "&amp;cat={$cat}&amp;bestseller=Y";
        }
        $useLink = $tool->params->checkValue('link-to-product-page', 'Yes');
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);
        $productImagesData = array();
        foreach($products as $key => $product) {
            $image = MagicToolboxHelper::getProductImages($product['productid'], 'main', $toolId);
            if(empty($image)) continue;
            $productInfo = MagicToolboxHelper::getProductInfo($product['productid']);
            if($image[0]['is_url']) {
                $productImagesData[] = array(
                    'img' => $image[0]['path'],
                    'title' => $productInfo['title'],
                    'alt' => $image[0]['alt'],
                    //'description' => $productInfo['short_description'],
                    'link' => isset($product['page_url']) ? $product['page_url'] : 'product.php?productid='.$product['productid'].$linkSufix
                );
            } else {
                $productImagesData[] = array(
                    'img' => MagicToolboxHelper::fixImageName($helper->create('/'.$image[0]['path'], 'thumb', $productId)),
                    'title' => $productInfo['title'],
                    'alt' => $image[0]['alt'],
                    //'description' => $productInfo['short_description'],
                    'link' => isset($product['page_url']) ? $product['page_url'] : 'product.php?productid='.$product['productid'].$linkSufix
                );
            }
        }
        $productsCount = count($productImagesData);
        if($productsCount) {
            //if($productsCount < $tool->params->getValue('items')) {
            //    $tool->params->setValue('items', $productsCount);
            //}
            $html = $tool->getMainTemplate($productImagesData, array('id' => $block.'MagicScroll'));
            $html = '<div class="MagicToolboxContainer">'.$html.'</div>';

            //$pattern = '<div[^>]*?class="[^"]*?content[^"]*"[^>]*>.*<\/div>(?=[^<]*<\/div>[^<]*)';
            //NOTE: pattern to match div.content or td.DialogBox (v4.1.x) tags
            $pattern =  '(<(div|td)\b[^>]*?\bclass\s*+=\s*+"[^"]*?\b(?:content|DialogBox)\b[^"]*+"[^>]*+>)'.
                        '('.
                        '(?:'.
                            '[^<]++'.
                            '|'.
                            '<(?!/?\2\b|!--)'.
                            '|'.
                            '<!--.*?-->'.
                            '|'.
                            '<\2\b[^>]*+>'.
                                '(?3)'.
                            '</\2\s*+>'.
                        ')*+'.
                        ')'.
                        '(</\2\s*+>)';

            //preg_match_all('%'.$pattern.'%is', $contents, $__matches, PREG_SET_ORDER);
            $contents = preg_replace('%'.$pattern.'%is', '$1'.$html.'$4', $contents, 1);

        }
        $this->magictoolboxProcessedBlocks[$block] = $toolId;
    break;
    default: break;
}

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
setlocale(LC_ALL, $oldLocale);

?>
