<?php

//ini_set('display_errors', false);
//error_reporting(E_ALL & ~E_NOTICE);

//global $config;
//$isXCart47 = !empty($config['version']) && version_compare($config['version'], '4.7.0', '>=');
$isXCart47 = class_exists('XCTemplaterOriginal', false);

if($isXCart47) {
    class TemplaterMediator extends XCTemplaterOriginal {}
} else {
    class TemplaterMediator extends TemplaterOriginal {}
}

class MagicToolboxHelper {

    public static function getModules() {
        static $modules = array(
            'magic360' => array(
                'name' => 'Magic 360',
                'upgrade' => '5.2.2',
            ),
            'magic360flash' => array(
                'name' => 'Magic 360 Flash',
                'upgrade' => '1.0.0',
            ),
            'magicslideshow' => array(
                'name' => 'Magic Slideshow',
                'upgrade' => '5.5.0',
            ),
            'magicmagnify' => array(
                'name' => 'Magic Magnify',
                'upgrade' => '1.0.0',
            ),
            'magicmagnifyplus' => array(
                'name' => 'Magic Magnify Plus',
                'upgrade' => '1.0.0',
            ),
            'magicscroll' => array(
                'name' => 'Magic Scroll',
                'upgrade' => '5.5.0',
            ),
            'magictouch' => array(
                'name' => 'Magic Touch',
                'upgrade' => '1.0.0',
            ),
            'magicthumb' => array(
                'name' => 'Magic Thumb',
                'upgrade' => '1.0.0',
            ),
            'magiczoom' => array(
                'name' => 'Magic Zoom',
                'upgrade' => '5.5.0',
            ),
            'magiczoomplus' => array(
                'name' => 'Magic Zoom Plus',
                'upgrade' => '5.5.0',
            ),
        );
        return $modules;
    }

    public static function headers($module, $set = false) {
        static $headers = array(
            'magic360' => false,
            'magic360flash' => false,
            'magicslideshow' => false,
            'magicmagnify' => false,
            'magicmagnifyplus' => false,
            'magicscroll' => false,
            'magictouch' => false,
            'magicthumb' => false,
            'magiczoom' => false,
            'magiczoomplus' => false,
        );
        if($set) {
            $headers[$module] = true;
        }
        return $headers[$module];
    }

    public static function getInstalledModules() {
        static $installedModules = null;
        if($installedModules === null) {
            $modules = MagicToolboxHelper::getModules();
            $pattern = MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.
                       '{'.implode(',', array_keys($modules)).'}.php';
            $files = glob($pattern, GLOB_BRACE);
            $installedModules = array();
            if(!empty($files)) {
                foreach($files as $file) {
                    $installedModules[] = str_replace(' ', '', $modules[basename($file, '.php')]['name']);
                }
            }
        }
        return $installedModules;
    }

    public static function getConfig($key) {
        static $config = array();
        if(empty($config)) {
            global $xcart_dir, $xcart_web_dir, $http_location, $current_location;
            $config['xcart_dir'] = preg_replace('/(\/|\\\\)$/is', '', $xcart_dir);
            $config['xcart_web_dir'] = preg_replace('/\/$/is', '', $xcart_web_dir);
            $config['http_location'] = preg_replace('/\/$/is', '', $http_location);
            $config['current_location'] = preg_replace('/\/$/is', '', $current_location);
            if(empty($config['xcart_web_dir'])) {
                $config['xcart_web_dir'] = $config['current_location'];
            }
        }
        return isset($config[$key]) ? $config[$key] : null;
    }

    public static function &loadCoreClass($toolId, $scroll = false) {
        static $tools = array();
        $lcToolId = strtolower($toolId);
        if(!isset($tools[$lcToolId])) {
            global $xcart_tbl_prefix;
            $table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');
            $xcart_dir = MagicToolboxHelper::getConfig('xcart_dir');
            $tabels = func_query_column("SHOW TABLES LIKE '{$table_prefix}{$lcToolId}'");
            if(empty($tabels)) {
                db_query("CREATE TABLE {$table_prefix}{$lcToolId} (
                                `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
                                `block` VARCHAR(32) NOT NULL,
                                `name` VARCHAR(32) NOT NULL,
                                `value` TEXT,
                                `enabled` INT(2) UNSIGNED NOT NULL,
                                PRIMARY KEY (id)
                            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
                );
                require_once($xcart_dir.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.$lcToolId.'.params.php');
                $func_load_params = 'func_load_'.$lcToolId.'_params';
                $func_load_params();
            } else {
                $version = func_query_first_cell("SELECT value FROM {$table_prefix}{$lcToolId} WHERE `block`='default' AND `name`='version'");
                $modules = MagicToolboxHelper::getModules();
                //NOTE: each module has its own number $ {env.$ {mod}_version_number}
                if($version != 'working' && version_compare($version, $modules[$lcToolId]['upgrade'], '<')) {
                    db_query("DROP TABLE IF EXISTS {$table_prefix}{$lcToolId}_backup");
                    db_query("RENAME TABLE {$table_prefix}{$lcToolId} TO {$table_prefix}{$lcToolId}_backup");
                    db_query("CREATE TABLE {$table_prefix}{$lcToolId} (
                                    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
                                    `block` VARCHAR(32) NOT NULL,
                                    `name` VARCHAR(32) NOT NULL,
                                    `value` TEXT,
                                    `enabled` INT(2) UNSIGNED NOT NULL,
                                    PRIMARY KEY (id)
                                ) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
                    );
                    require_once($xcart_dir.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.$lcToolId.'.params.php');
                    $func_load_params = 'func_load_'.$lcToolId.'_params';
                    $func_load_params();
                    //NOTICE: this leads to rewrite new values with outdated values
                    //db_query("UPDATE {$table_prefix}{$lcToolId} AS main, {$table_prefix}{$lcToolId}_backup AS backup ".
                    //         "SET main.value=backup.value, main.enabled=backup.enabled ".
                    //         "WHERE main.block=backup.block AND main.name=backup.name AND main.name!='version'");
                }
            }

            require_once($xcart_dir.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.$lcToolId.DIRECTORY_SEPARATOR.$lcToolId.'.module.core.class.php');
            $className = $toolId.'ModuleCoreClass';
            $tools[$lcToolId] = new $className();
            $tools[$lcToolId.'_magicscroll'] = null;

            $settings = func_query("SELECT `name`, `value`, `block` FROM {$table_prefix}{$lcToolId} WHERE enabled=1");
            if(is_array($settings))//NOTE: 'false' if table is empty
            foreach($settings as $param) {
                $tools[$lcToolId]->params->setValue($param['name'], $param['value'], $param['block']);
            }
            //NOTE: spike to create product profile for magic360
            if($lcToolId == 'magic360') {
                $tools[$lcToolId]->params->setValue('version', $tools[$lcToolId]->params->getValue('version'), 'product');
            }

            if($tools[$lcToolId]->type == 'standard' && $tools[$lcToolId]->params->checkValue('magicscroll', 'Yes', 'product')) {
                require_once($xcart_dir.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.$lcToolId.DIRECTORY_SEPARATOR.'magicscroll.module.core.class.php');
                $tools[$lcToolId.'_magicscroll'] = new MagicScrollModuleCoreClass(false);
                //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
                //$tools[$lcToolId.'_magicscroll']->params->appendParams($tools[$lcToolId]->params->getParams('product'), 'product-magicscroll-options');
                $tools[$lcToolId.'_magicscroll']->params->resetProfile();//NOTE: need to reset to get all options with 'getParams' method
                foreach($tools[$lcToolId.'_magicscroll']->params->getParams() as $id => $param) {
                    $value = $tools[$lcToolId]->params->getValue($id, 'product');
                    if($value !== null) {
                        $tools[$lcToolId.'_magicscroll']->params->setValue($id, $value, 'product-magicscroll-options');
                    }
                }
                $tools[$lcToolId.'_magicscroll']->params->setValue('orientation', ($tools[$lcToolId]->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
                //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
                if(in_array('MagicScroll', MagicToolboxHelper::getInstalledModules())) {
                    MagicToolboxHelper::loadCoreClass('MagicScroll');
                }
            }
        }
        return $scroll ? $tools[$lcToolId.'_magicscroll'] : $tools[$lcToolId];
    }

    public static function &loadImageHelperClass($toolId) {
        static $helperClasses = array();
        $lcToolId = strtolower($toolId);
        if(!isset($helperClasses[$lcToolId])) {
            $tool = &MagicToolboxHelper::loadCoreClass($toolId);
            require_once(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.$lcToolId.DIRECTORY_SEPARATOR.'magictoolbox.imagehelper.class.php');
            $helperClasses[$lcToolId] = new MagicToolboxImageHelperClass(MagicToolboxHelper::getConfig('xcart_dir'), DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'magictoolbox_cache', $tool->params, null, MagicToolboxHelper::getConfig('xcart_web_dir'));
        }
        return $helperClasses[$lcToolId];
    }

    public static function getProductImages($id, $image_type, $toolId) {
        global $sql_tbl;
        static $images = array();
        if(!isset($images[$id])) {
            $images[$id] = array();
        }
        if(!isset($images[$id][$image_type])) {
            $images[$id][$image_type] = array();
            $records = array();
            switch($image_type) {
                case 'main':
                    $records = func_query("SELECT `id`, `image`, `image_path`, `image_type`, `image_x`, `image_y`, `filename`, `alt`, `md5` FROM {$sql_tbl['images_P']} WHERE `id`={$id} LIMIT 1");
                    if(empty($records)) {
                        $tool = &MagicToolboxHelper::loadCoreClass($toolId);
                        if($tool->params->checkValue('disable-for-thumbnail', 'No')) {
                            $records = func_query("SELECT `id`, `image`, `image_path`, `image_type`, `image_x`, `image_y`, `filename`, `alt`, `md5` FROM {$sql_tbl['images_T']} WHERE `id`={$id} LIMIT 1");
                        }
                    }
                break;
                case 'variant':
                    if(isset($sql_tbl['images_W']))
                    $records = func_query("SELECT `id`, `image`, `image_path`, `image_type`, `image_x`, `image_y`, `filename`, `alt`, `md5` FROM {$sql_tbl['images_W']} AS i ".
                                          "LEFT JOIN {$sql_tbl['quick_prices']} AS p ON p.variantid = i.id WHERE p.productid='{$id}' LIMIT 1");
                break;
                case 'detailed':
                    $records = func_query("SELECT `id`, `image`, `image_path`, `image_type`, `image_x`, `image_y`, `filename`, `alt`, `md5` FROM {$sql_tbl['images_D']} WHERE `id`='{$id}' AND `avail`='Y' ORDER BY `orderby`, `imageid`");
                break;
                case 'variants':
                    if(isset($sql_tbl['images_W']))
                    $records = func_query("SELECT `id`, `image`, `image_path`, `image_type`, `image_x`, `image_y`, `filename`, `alt`, `md5` FROM {$sql_tbl['images_W']} AS i ".
                                          "LEFT JOIN {$sql_tbl['variants']} AS v ON v.variantid = i.id WHERE v.productid='{$id}'");
                break;
            }
            if(!empty($records))
            foreach($records as $data) {
                if(empty($data['image_path']) && !empty($data['image'])) {
                    // image stored in database, we should save it in filesystem
                    if(empty($data['filename'])) {
                        $file_name = $data['md5'].'.'.func_get_image_ext($data['image_type']);
                    } else {
                        $file_name = $data['md5'].substr($data['filename'], strrpos($data['filename'], '.'));
                    }
                    $data['image_path'] = 'images'.DIRECTORY_SEPARATOR.'magictoolbox_cache_from_database'.DIRECTORY_SEPARATOR.$file_name;
                    $path = MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.$data['image_path'];
                    if(!file_exists($path)) {
                        $cacheDir = dirname($path);
                        if(!file_exists($cacheDir)) {
                            if(mkdir($cacheDir)) {
                                @chmod($cacheDir, 0755);
                            }
                        }
                        $handle = fopen($path, 'w+');
                        if($handle) {
                            fwrite($handle, $data['image']);
                            fclose($handle);
                        }
                    }
                    $is_url = false;
                } else {
                    $data['image_path'] = str_replace('%20', ' ', $data['image_path']);
                    $data['image_path'] = str_replace('\\', '/', $data['image_path']);
                    $data['image_path'] = preg_replace('/^\.?\//is', '', $data['image_path']);
                    $is_url = preg_match('/^http(s)?\:\/\//is', trim($data['image_path']));
                    if($is_url && strpos($data['image_path'], MagicToolboxHelper::getConfig('http_location')) === 0) {
                        $path = str_replace(MagicToolboxHelper::getConfig('http_location'), '', $data['image_path']);
                        $path = preg_replace('/^\.?\//is', '', $path);
                        if(file_exists(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.$path)) {
                            $data['image_path'] = $path;
                            $is_url = false;
                        }
                    }
                }
                $images[$id][$image_type][] = array(
                    'id' => $data['id'],
                    'path' => $data['image_path'],
                    'width' => $data['image_x'],
                    'height' => $data['image_y'],
                    'alt' => $data['alt'],
                    'is_url' => $is_url
                );
            }
        }
        return $images[$id][$image_type];
    }

    public static function getProductInfo($id) {
        global $sql_tbl, $store_language;
        static $query = null, $productsInfo = array();
        if(!isset($productsInfo[$id])) {
            if($query == null) {
                if(isset($sql_tbl['products_lng_current'])) {
                    $query = "SELECT p.product AS title, p.descr AS short_description, p.fulldescr AS description FROM {$sql_tbl['products_lng_current']} AS p WHERE p.productid=";
                } else if(isset($sql_tbl['products_lng'])) {
                    $query = "SELECT p.product AS title, p.descr AS short_description, p.fulldescr AS description, lng.product AS title_lng, lng.descr AS short_description_lng, lng.fulldescr AS description_lng ".
                                "FROM {$sql_tbl['products']} AS p ".
                                "LEFT JOIN {$sql_tbl['products_lng']} AS lng ON lng.code='{$store_language}' AND lng.productid = p.productid ".
                                "WHERE p.productid=";
                } else {
                    $query = "SELECT p.product AS title, p.descr AS short_description, p.fulldescr AS description FROM {$sql_tbl['products']} AS p WHERE p.productid=";
                }
            }
            $data = func_query_first($query.$id);
            if(!empty($data['title_lng'])) {
                $data['title'] = $data['title_lng'];
                unset($data['title_lng']);
            }
            if(!empty($data['short_description_lng'])) {
                $data['short_description'] = $data['short_description_lng'];
                unset($data['short_description_lng']);
            }
            if(!empty($data['description_lng'])) {
                $data['description'] = $data['description_lng'];
                unset($data['description_lng']);
            }
            $productsInfo[$id] = $data;
        }
        return $productsInfo[$id];
    }

    public static function fixImageName($path) {
        //NOTE: fixed an issue with non-alphanumeric characters in file name
        //      like %5b7%5d.526e-FE.jpg
        $basename = basename($path);
        $dir = substr($path, 0, strlen($basename) * -1);
        return $dir.rawurlencode($basename);
    }

}

class MagicToolboxTemplater extends TemplaterMediator {

    var $magictoolboxProcessedBlocks = array();
    var $magictoolboxSkipFiles = false;
    var $magictoolboxWrongPageType = false;
    var $magictoolboxCooperativeMode = false;
    //var $magictoolboxSecondaryModule = '';
    var $magictoolbox360HTML = '';
    var $magictoolbox360Icon = '';
    var $magictoolboxGetTemplateVars = 'get_template_vars';

    function __construct() {
        global $isXCart47;
        if($isXCart47) {
            parent::__construct();
            $this->template_class = 'MT_Smarty_Internal_Template';
            $this->magictoolboxGetTemplateVars = 'getTemplateVars';//for Smarty v3 template engine
        } else {
            $this->magictoolboxGetTemplateVars = 'get_template_vars';//for Smarty v2 template engine
            return parent::TemplaterOriginal();
        }
    }

    function _smarty_include($params) {

        //debug_log('=>> '.$params['smarty_include_tpl_file']);
        //ob_start();
        //parent::_smarty_include($params);
        //$contents = ob_get_contents();
        //ob_end_clean();
        //debug_log($contents);
        //echo $contents;
        //return;

        if($this->magictoolboxSkipFiles) {
            parent::_smarty_include($params);
            return;
        }

        //if(AREA_TYPE != 'C' || !$this->magictoolboxGetPageType()) {
        //NOTE: fix for not standard templates
        if(AREA_TYPE != 'C' || $this->magictoolboxWrongPageType) {
            if(AREA_TYPE == 'A') {
                global $config;
                if(version_compare($config['version'], '4.4.0', '>=') &&
                    ($params['smarty_include_tpl_file'] == 'admin/menu_box.tpl' || $params['smarty_include_tpl_file'] == 'single/menu_box.tpl')) {
                    ob_start();
                    parent::_smarty_include($params);
                    $contents = ob_get_contents();
                    ob_end_clean();
                    $moduleIds = MagicToolboxHelper::getInstalledModules();
                    if(!empty($moduleIds)) {
                        $menu = array(
                            '<li>',
                            '<a href="#">Magic Toolbox</a>',
                            '<div>'
                        );
                        $modules = MagicToolboxHelper::getModules();
                        foreach($moduleIds as $id) {
                            $id = strtolower($id);
                            $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/'.$id.'.php">'.$modules[$id]['name'].'</a>';
                            if($id == 'magic360') {
                                $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/magic360_images.php">'.$modules[$id]['name'].' Images</a>';
                            }
                        }
                        $menu[] = '</div>';
                        $menu[] = '</li>';
                        if(version_compare($config['version'], '4.5.2', '>')) {
                            $menu[] = '<script type="text/javascript">
//<![CDATA[
var horizontalMenu = document.getElementById(\'horizontal-menu\');
if(horizontalMenu) {
    var horizontalMenuWidth = $(horizontalMenu).css(\'width\');
    horizontalMenuWidth = parseInt(horizontalMenuWidth.replace(\'px\', \'\')) + 120;
    $(horizontalMenu).css(\'width\', horizontalMenuWidth);
}
//]]>
</script>';
                        }
                        $pattern = '(<\/ul>)';
                        $replace = "\n".implode("\n", $menu)."\n$1";
                        $replaced = 0;
                        $contents = preg_replace('/'.$pattern.'/i', $replace, $contents, 1, $replaced);
                    }
                    echo $contents;
                    return;
                } else if($params['smarty_include_tpl_file'] == 'admin/menu_box.tpl' || $params['smarty_include_tpl_file'] == 'admin/menu_admin.tpl') {
                    //for X-Cart 4.1.x - 4.3.x
                    parent::_smarty_include($params);
                    $moduleIds = MagicToolboxHelper::getInstalledModules();
                    if(!empty($moduleIds)) {
                        $modules = MagicToolboxHelper::getModules();
                        foreach($moduleIds as $id) {
                            $id = strtolower($id);
                            $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/'.$id.'.php" class="VertMenuItems">'.$modules[$id]['name'].'</a><br />';
                            if($id == 'magic360') {
                                $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/magic360_images.php" class="VertMenuItems">'.$modules[$id]['name'].' Images</a><br />';
                            }
                        }
                        $params = array(
                            'smarty_include_tpl_file' => 'menu.tpl',
                            'smarty_include_vars' => array(
                                'dingbats' => 'dingbats_categorie.gif',
                                'menu_title' => 'Magic Toolbox',
                                'menu_content' => "\n".implode("\n", $menu)."\n",
                            ),
                        );
                        echo '<br />';
                        parent::_smarty_include($params);
                        echo '<br />';
                    }
                    return;
                }
            }
            parent::_smarty_include($params);
            return;
        }

        switch($params['smarty_include_tpl_file']) {
            case 'customer/service_head.tpl':
            //NOTE: for X-Cart 4.1.x
            case 'meta.tpl':
                if(!$this->magictoolboxGetPageType()) {
                    $this->magictoolboxWrongPageType = true;
                    parent::_smarty_include($params);
                    return;
                }
                $block = 'head';
                $profile = 'default';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'customer/main/welcome.tpl':
                //$this->magictoolboxGetPageType() == 'home'
                $block = 'homeslideshow';
                $profile = 'homeslideshow';
                break;
            case 'customer/main/featured.tpl':
                $block = 'featured';
                $profile = 'featured';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'modules/New_Arrivals/new_arrivals.tpl':
                $block = 'arrivals';
                $profile = 'arrivals';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'modules/Bestsellers/bestsellers.tpl':
                $_tpl_vars_config = $this->{$this->magictoolboxGetTemplateVars}('config');
                if($_tpl_vars_config['Bestsellers']['bestsellers_menu'] == 'Y') {
                    parent::_smarty_include($params);
                    return;
                }
                $block = 'bestsellers';
                $profile = 'bestsellers';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'modules/Bestsellers/menu_bestsellers.tpl':
                $_tpl_vars_config = $this->{$this->magictoolboxGetTemplateVars}('config');
                if($_tpl_vars_config['Bestsellers']['bestsellers_menu'] != 'Y') {
                    parent::_smarty_include($params);
                    return;
                }
                $block = 'bestsellers';
                $profile = 'bestsellers';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'modules/Recently_Viewed/content.tpl':
                $block = 'recently';
                $profile = 'recently';
                $this->magictoolboxSkipFiles = true;
                break;
            //case 'modules/Recommended_Products/recommends.tpl':
            //    $block = 'recommends';
            //    $profile = 'recommends';
            //    break;
            case 'customer/main/product.tpl':
                $block = 'product';
                $profile = 'product';
                //$this->magictoolboxSkipFiles = true;
                break;
            case 'modules/Detailed_Product_Images/popup_image.tpl':
                global $config;
                if(version_compare($config['version'], '4.4.0', '>=')) {
                    parent::_smarty_include($params);
                    return;
                }
            case 'modules/Detailed_Product_Images/widget.tpl':
            case 'modules/Detailed_Product_Images/product_images.tpl':
                $block = 'detailed';
                $profile = 'product';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'customer/main/products.tpl':
                if($this->magictoolboxGetPageType() != 'category') {
                    parent::_smarty_include($params);
                    return;
                }
                $block = 'category';
                $profile = 'category';
                $this->magictoolboxSkipFiles = true;
                break;
            case 'customer/main/search_result.tpl':
                $block = 'search';
                $profile = 'search';
                $this->magictoolboxSkipFiles = true;
            break;
            default:
                parent::_smarty_include($params);
                return;
        }

        //if(isset($this->magictoolboxProcessedBlocks[$block])) {
        //    parent::_smarty_include($params);
        //    return;
        //}

        //debug_log($block.' start');
        ob_start();
        parent::_smarty_include($params);
        $contents = ob_get_contents();
        ob_end_clean();
        $this->magictoolboxSkipFiles = false;

        foreach(MagicToolboxHelper::getInstalledModules() as $toolId) {
            $this->magictoolboxPatch($toolId, $block, $profile, $contents);
            if(isset($this->magictoolboxProcessedBlocks[$block]) && $this->magictoolboxProcessedBlocks[$block] != 'Magic360') {
                break;
            }
        }

        echo $contents;
        //debug_log($block.' end');
    }

    function magictoolboxPatch($toolId, $block, $profile, &$contents) {
        $tool = &MagicToolboxHelper::loadCoreClass($toolId);
        if(!$tool->params->profileExists($profile) || $tool->params->checkValue('enable-effect', 'No', $profile)) {
            return;
        }
        $tool->params->setProfile($profile);
        require(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.strtolower($toolId).'.php');
    }

    function magictoolboxGetPageType() {
        static $page = null;
        if($page === null) {
            switch($this->{$this->magictoolboxGetTemplateVars}('main')) {
                case 'product':
                    $page = 'product';
                    break;
                case 'catalog':
                    $page = $this->{$this->magictoolboxGetTemplateVars}('cat') ? 'category' : 'home';
                    break;
                case 'manufacturer_products':
                    $page = 'category';
                    break;
                case 'search':
                    $page = 'search';
                    break;
                case 'new_arrivals':
                    $page = 'new_arrivals';
                    break;
                case 'on_sale':
                    $page = 'on_sale';
                    break;
                default:
                    $page = '';
            }
        }
        return $page;
    }

}

if($isXCart47) {
    class XCTemplater extends MagicToolboxTemplater {}
    if(defined('DEVELOPMENT_MODE')) {
        class MT_Smarty_Internal_Template_Mediator extends XC_Dev_Smarty_Internal_Template {}
    } else {
        class MT_Smarty_Internal_Template_Mediator extends XC_Smarty_Internal_Template {}
    }
    class MT_Smarty_Internal_Template extends MT_Smarty_Internal_Template_Mediator {

        var $magictoolboxProcessedBlocks = array();
        var $magictoolboxSkipFiles = false;
        var $magictoolboxWrongPageType = false;
        var $magictoolboxCooperativeMode = false;
        //var $magictoolboxSecondaryModule = '';
        var $magictoolbox360HTML = '';
        var $magictoolbox360Icon = '';
        var $magictoolboxGetTemplateVars = 'getTemplateVars';

        function getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope) {

            //debug_log('=>> '.$template);
            //$contents = parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            //debug_log($contents);
            //return $contents;

            if($this->magictoolboxSkipFiles) {
                return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            }

            if(AREA_TYPE != 'C' || $this->magictoolboxWrongPageType) {
                if(AREA_TYPE == 'A') {
                    global $config;
                    if($template == 'admin/menu_box.tpl' || $template == 'single/menu_box.tpl') {
                        $contents = parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                        $moduleIds = MagicToolboxHelper::getInstalledModules();
                        if(!empty($moduleIds)) {
                            $menu = array(
                                '<li>',
                                '<a href="#">Magic Toolbox</a>',
                                '<div>'
                            );
                            $modules = MagicToolboxHelper::getModules();
                            foreach($moduleIds as $id) {
                                $id = strtolower($id);
                                $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/'.$id.'.php">'.$modules[$id]['name'].'</a>';
                                if($id == 'magic360') {
                                    $menu[] = '<a target="_blank" href="'.MagicToolboxHelper::getConfig('xcart_web_dir').'/admin/magic360_images.php">'.$modules[$id]['name'].' Images</a>';
                                }
                            }
                            $menu[] = '</div>';
                            $menu[] = '</li>';
                            $menu[] = '<script type="text/javascript">
    //<![CDATA[
    var horizontalMenu = document.getElementById(\'horizontal-menu\');
    if(horizontalMenu) {
        var horizontalMenuWidth = $(horizontalMenu).css(\'width\');
        horizontalMenuWidth = parseInt(horizontalMenuWidth.replace(\'px\', \'\')) + 120;
        $(horizontalMenu).css(\'width\', horizontalMenuWidth);
    }
    //]]>
    </script>';
                            $pattern = '(<\/ul>)';
                            $replace = "\n".implode("\n", $menu)."\n$1";
                            $replaced = 0;
                            $contents = preg_replace('/'.$pattern.'/i', $replace, $contents, 1, $replaced);
                        }
                        return $contents;
                    }
                }
                return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            }

            switch($template) {
                case 'customer/service_head.tpl':
                //NOTE: for X-Cart 4.1.x
                case 'meta.tpl':
                    if(!$this->magictoolboxGetPageType()) {
                        $this->magictoolboxWrongPageType = true;
                        return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                    }
                    $block = 'head';
                    $profile = 'default';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'customer/main/welcome.tpl':
                    //$this->magictoolboxGetPageType() == 'home'
                    $block = 'homeslideshow';
                    $profile = 'homeslideshow';
                    break;
                case 'customer/main/featured.tpl':
                    $block = 'featured';
                    $profile = 'featured';
                    $this->magictoolboxSkipFiles = true;
                    break;
                //case 'modules/New_Arrivals/new_arrivals.tpl':
                case 'modules/New_Arrivals/menu_new_arrivals.tpl':
                    $block = 'arrivals';
                    $profile = 'arrivals';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'modules/Bestsellers/bestsellers.tpl':
                    $_tpl_vars_config = $this->getTemplateVars('config');
                    if($_tpl_vars_config['Bestsellers']['bestsellers_menu'] == 'Y') {
                        return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                    }
                    $block = 'bestsellers';
                    $profile = 'bestsellers';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'modules/Bestsellers/menu_bestsellers.tpl':
                    $_tpl_vars_config = $this->getTemplateVars('config');
                    if($_tpl_vars_config['Bestsellers']['bestsellers_menu'] != 'Y') {
                        return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                    }
                    $block = 'bestsellers';
                    $profile = 'bestsellers';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'modules/Recently_Viewed/content.tpl':
                    $block = 'recently';
                    $profile = 'recently';
                    $this->magictoolboxSkipFiles = true;
                    break;
                //case 'modules/Recommended_Products/recommends.tpl':
                //    $block = 'recommends';
                //    $profile = 'recommends';
                //    break;
                case 'customer/main/product.tpl':
                    $block = 'product';
                    $profile = 'product';
                    //$this->magictoolboxSkipFiles = true;
                    break;
                case 'modules/Detailed_Product_Images/popup_image.tpl':
                    return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                case 'modules/Detailed_Product_Images/widget.tpl':
                case 'modules/Detailed_Product_Images/product_images.tpl':
                    $block = 'detailed';
                    $profile = 'product';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'customer/main/products.tpl':
                    if($this->magictoolboxGetPageType() != 'category') {
                        return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
                    }
                    $block = 'category';
                    $profile = 'category';
                    $this->magictoolboxSkipFiles = true;
                    break;
                case 'customer/main/search_result.tpl':
                    $block = 'search';
                    $profile = 'search';
                    $this->magictoolboxSkipFiles = true;
                break;
                default:
                    return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            }

            //if(isset($this->magictoolboxProcessedBlocks[$block])) {
            //    return parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            //}

            //debug_log($block.' start');
            $contents = parent::getSubTemplate($template, $cache_id, $compile_id, $caching, $cache_lifetime, $data, $parent_scope);
            $this->magictoolboxSkipFiles = false;

            foreach(MagicToolboxHelper::getInstalledModules() as $toolId) {

                //NOTE: skip for MagicScroll and MagicSlideshow because they don't work in cooperative mode
                if(isset($this->magictoolboxProcessedBlocks[$block]) && in_array($toolId, array('MagicScroll', 'MagicSlideshow'))) {
                    continue;
                }

                $this->magictoolboxPatch($toolId, $block, $profile, $contents);

                if(isset($this->magictoolboxProcessedBlocks[$block]) && $this->magictoolboxProcessedBlocks[$block] != 'Magic360') {
                    break;
                }

            }

            return $contents;
            //debug_log($block.' end');

        }

        function magictoolboxPatch($toolId, $block, $profile, &$contents) {
            $tool = &MagicToolboxHelper::loadCoreClass($toolId);
            if(!$tool->params->profileExists($profile) || $tool->params->checkValue('enable-effect', 'No', $profile)) {
                return;
            }
            $tool->params->setProfile($profile);
            require(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.strtolower($toolId).'.php');
        }

        function magictoolboxGetPageType() {
            static $page = null;
            if($page === null) {
                switch($this->getTemplateVars('main')) {
                    case 'product':
                        $page = 'product';
                        break;
                    case 'catalog':
                        $page = $this->getTemplateVars('cat') ? 'category' : 'home';
                        break;
                    case 'manufacturer_products':
                        $page = 'category';
                        break;
                    case 'search':
                        $page = 'search';
                        break;
                    case 'new_arrivals':
                        $page = 'new_arrivals';
                        break;
                    case 'on_sale':
                        $page = 'on_sale';
                        break;
                    default:
                        $page = '';
                }
            }
            return $page;
        }

    }
} else {
    class Templater extends MagicToolboxTemplater {}
}
