<?php

//$toolId, &$contents, $tool

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
$oldLocale = setlocale(LC_ALL, NULL);
setlocale(LC_ALL, 'en_US.UTF8');

switch($block) {
    case 'head':

        //$tool->params->resetProfile();

        $page = $this->magictoolboxGetPageType();
        $enable = $tool->params->profileExists($page) && !$tool->params->checkValue('enable-effect', 'No', $page)
                  ;
        if(!$enable) break;

        $headers = $tool->getHeadersTemplate(MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/magic360');


        //ideal comfort
        //.product-details .image width = thumb-max-width
        //.product-details .details margin-left = thumb-max-width

        $contents .= $headers;

        MagicToolboxHelper::headers('magic360', true);

    break;
    case 'detailed':
        global $config;
        if($config['Detailed_Product_Images']['det_image_popup'] == 'Y') {
            //debug_log('detailed popup: '.$toolId);
            $contents = '<!-- MAGIC360:DETAILED_PRODUCT_IMAGES_START -->'.$contents.'<!-- MAGIC360:DETAILED_PRODUCT_IMAGES_END -->';
            break;
        } else {
            //debug_log('detailed tab: '.$toolId);
            $isDetailedImagesTab = true;
        }
    case 'product':
        global $active_modules, $config;
        if(!isset($isDetailedImagesTab)) $isDetailedImagesTab = false;
        //if($block == 'product') debug_log('product: '.$toolId);


        $product = $this->{$this->magictoolboxGetTemplateVars}('product');
        $productId = $product['productid'];
        $helper = &MagicToolboxHelper::loadImageHelperClass($toolId);


        $detailedImages = MagicToolboxHelper::getProductImages($productId, 'detailed', $toolId);
        $detailedImagesCount = count($detailedImages);
        $detailedImagesEnabled = !empty($active_modules['Detailed_Product_Images']) && $detailedImagesCount &&
                                 ($isDetailedImagesTab || $config['Detailed_Product_Images']['det_image_popup'] == 'Y');
        if(!$this->magictoolboxCooperativeMode) {//NOTE: check if $magictoolbox360HTML was set
            global $xcart_tbl_prefix;
            $table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');
            $result = func_query_first("SELECT * FROM `{$table_prefix}magic360_images` WHERE `id`={$productId}");
            if(empty($result) || empty($result['gallery'])) {
                break;
            }
            $magic360Images = explode(';', $result['gallery']);
            if(count($magic360Images)) {
                $magic360Columns = (int)$result['columns'];
                $tool->params->setValue('columns', $magic360Columns);
                $imageBasePath = 'images'.DIRECTORY_SEPARATOR.'magic360'.DIRECTORY_SEPARATOR;
                foreach($magic360Images as $index => $img) {
                    $magic360Images[$index] = array(
                        'img' => $helper->create('/'.$imageBasePath.$img, 'original', $productId),
                        'medium' => $helper->create('/'.$imageBasePath.$img, 'thumb', $productId),
                    );
                }
                $this->magictoolbox360Icon = $tool->params->getValue('icon');
                $this->magictoolbox360HTML = $html = $tool->getMainTemplate($magic360Images, array('id' => 'productMagic360'));
                $this->magictoolboxCooperativeMode = true;
            } else {
                break;
            }
        } else {
            $html = $this->magictoolbox360HTML;
        }

        if($isDetailedImagesTab) {
            break;//NOTE: apply only for product block (not detailed)
            $pattern = '(?:<div[^>]+?class="[^"]*?dpimage-container[^"]*"[^>]*>[^<]*<img[^>]*>[^<]*<\/div>[^<]*)+';
            $pattern = '<div[^>]+?class="[^"]*?dpimages-list[^"]*"[^>]*>[^<]*'.$pattern.'<\/div>|'.$pattern.'|(?:<img[^>]*>[^<]*(?:<br[^>]*>[^<]*)?)+';
        } else {
            if($detailedImagesEnabled) {
                //$pattern = '<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_START -->.*?'.
                //            '<div[^>]*?class="[^"]*?image-box[^"]*"[^>]*>[^<]*(?:'.$pattern.')[^<]*<\/div>'.
                //            '.*?<!-- MAGICTOOLBOX:DETAILED_PRODUCT_IMAGES_END -->';
                $pattern = '<!-- MAGIC360:DETAILED_PRODUCT_IMAGES_START -->.*?<!-- MAGIC360:DETAILED_PRODUCT_IMAGES_END -->';
                $html = '<div class="image-box">'.$html.'</div>';
            } else {
                if(empty($product['image_url'])) {
                    //$current_location.'/image.php?type='.{$product.image_type|default:"T"}.'&amp;id='.{$product.image_id}
                    //$xcart_web_dir.'/image.php?type='.{$product.image_type|default:"T"}.'&amp;id='.{$product.image_id}
                    $tmbn_url = '';//???????
                } else {
                    $tmbn_url = $product['image_url'];
                }
                $imagePattern = '<img[^>]*?(?:id="product_thumbnail"|src="'.preg_quote($tmbn_url, '/').'")[^>]*>';
                $pattern = '<a[^>]*>[^<]*'.$imagePattern.'[^<]*<\/a>|'.$imagePattern;
            }
        }
        $contents = preg_replace('/'.$pattern.'/is', $html, $contents, 1);

        $this->magictoolboxProcessedBlocks[$block] = $toolId;

    break;
    default: break;
}

//NOTE: Non-ASCII filenames are chunked if no locale is provided
//      so this is a fix
setlocale(LC_ALL, $oldLocale);

?>
