<?php

require './auth.php';
require $xcart_dir.'/include/security.php';
if(!defined('XCART_START')) { header("Location: ../"); die("Access denied"); }

// ini_set('display_errors', false);
// error_reporting(E_ALL & ~E_NOTICE);

global $xcart_tbl_prefix;
$table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');

$tabels = func_query_column("SHOW TABLES LIKE '{$table_prefix}magic360_images'");
if(empty($tabels)) {
    db_query("
CREATE TABLE {$table_prefix}magic360_images (
    `id` int(11) NOT NULL,
    `gallery` mediumtext,
    `columns` tinyint unsigned NOT NULL,
    PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;"
    );
}

defined('MT_DS') || define('MT_DS', DIRECTORY_SEPARATOR);

$category_id = isset($_POST['category_id']) ? (int)$_POST['category_id'] : 0;
$product_id = isset($_POST['product_id']) ? (int)$_POST['product_id'] : 0;
if(empty($product_id)) {
    $product_id = isset($_GET['productid']) ? (int)$_GET['productid'] : 0;
}

x_load('category');

$categories_data = func_get_categories_list(0, true, true, 0);

if(empty($category_id) && !empty($product_id)) {
    $search_query = "SELECT categoryid FROM {$table_prefix}products_categories WHERE productid={$product_id} AND main='Y'";
    $result = func_query_first($search_query);
    $category_id = empty($result['categoryid']) ? 0 : $result['categoryid'];
}

$categories_menu = implode("\n", get_categories_menu_options('0', (string)$category_id));

function get_categories_menu_options($parent_id = '0', $selected_id = '0', $indent = '') {
    global $categories_data;
    $categories_menu = array();
    $ids = array();
    foreach($categories_data as $id => $category) {
        if($category['parentid'] == $parent_id) {
            $ids[$id] = $category['category'];
            unset($categories_data[$id]);
        }
    }
    foreach($ids as $id => $category) {
        $menu = get_categories_menu_options($id, $selected_id, $indent.'&nbsp;&nbsp;');
        $categories_menu[] = '<option value="'.$id.'"'.($selected_id == $id ? ' selected="selected"' : '').'>'.$indent.$category.'</option>';
        $categories_menu = array_merge($categories_menu, $menu);
    }
    return $categories_menu;
}

//NOTE: only for GET requests
// $search_data['products'] = array();
// $search_data['products']['categoryid'] = $category_id;
// $search_data['products']['category_main'] = 'Y';
// $search_data['products']['category_extra'] = 'Y';
// $search_data['products']['sort_field'] = 'orderby';
// $search_data['products']['sort_direction'] = 0;
// $mode = 'search';
// include $xcart_dir.'/include/search.php';

$search_query = "SELECT {$table_prefix}products.productid, {$table_prefix}products_lng_en.product FROM {$table_prefix}products ".
                "INNER JOIN {$table_prefix}products_lng_en ON {$table_prefix}products_lng_en.productid = {$table_prefix}products.productid ".
                "INNER JOIN {$table_prefix}products_categories ON {$table_prefix}products_categories.productid = {$table_prefix}products.productid ".
                "LEFT JOIN {$table_prefix}category_memberships ON {$table_prefix}category_memberships.categoryid = {$table_prefix}products_categories.categoryid ".
                "LEFT JOIN {$table_prefix}product_memberships ON {$table_prefix}product_memberships.productid = {$table_prefix}products.productid ".
                "WHERE {$table_prefix}products_categories.categoryid='{$category_id}' ".
                "GROUP BY {$table_prefix}products_categories.productid ".
                "ORDER BY {$table_prefix}products_categories.orderby ASC, {$table_prefix}products_lng_en.product ASC, {$table_prefix}products.productcode ASC, {$table_prefix}products.productid ASC";

global $config;
if(version_compare($config['version'], '4.5.0', '<')) {
    $search_query = 
    "SELECT {$table_prefix}products.productid, {$table_prefix}products.product FROM {$table_prefix}products ".
    "INNER JOIN {$table_prefix}products_categories ON {$table_prefix}products_categories.productid = {$table_prefix}products.productid ".
    "INNER JOIN {$table_prefix}categories ON {$table_prefix}products_categories.categoryid = {$table_prefix}categories.categoryid ".
    "LEFT JOIN {$table_prefix}category_memberships ON {$table_prefix}category_memberships.categoryid = {$table_prefix}categories.categoryid ".
    "LEFT JOIN {$table_prefix}product_memberships ON {$table_prefix}product_memberships.productid = {$table_prefix}products.productid ".
    "WHERE {$table_prefix}products_categories.categoryid='{$category_id}' ".
    "GROUP BY {$table_prefix}products.productid ".
    "ORDER BY {$table_prefix}products_categories.orderby ASC, {$table_prefix}products.product ASC, {$table_prefix}products.productcode ASC, {$table_prefix}products.productid ASC ";
}

$products = func_query($search_query);

$products_menu = array();
if(is_array($products)) {
    foreach($products as $product) {
        $products_menu[] = '<option value="'.$product['productid'].'"'.($product_id == (int)$product['productid'] ? ' selected="selected"' : '').'>'.$product['product'].'</option>';
    }
}
$products_menu = implode("\n", $products_menu);

$magic360Images = array();
$magic360Columns = 0;
$magic360Rows = 0;
$multiRows = false;
$insert = true;
if($product_id) {
    $result = func_query_first("SELECT * FROM `{$table_prefix}magic360_images` WHERE `id`={$product_id}");
    if(!empty($result)) {
        if(!empty($result['gallery'])) {
            $magic360Images = explode(';', $result['gallery']);
            $magic360Columns = (int)$result['columns'];
        }
        $insert = false;
    }
}

$imageBasePath = MagicToolboxHelper::getConfig('xcart_dir').MT_DS.'images'.MT_DS.'magic360'.MT_DS;
$imageBaseUrl = MagicToolboxHelper::getConfig('xcart_web_dir').'/images/magic360/';

$updateDB = false;

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    switch($_POST['magictoolboxSubmitAction']) {
        case 'select':
            break;
        case 'upload':
            if(!empty($_FILES['magic360images']) && (is_dir($imageBasePath) || mkdir($imageBasePath))) {
                $_magic360Columns = $magic360Columns;
                $magic360ImagesCount = count($magic360Images);
                foreach($_FILES['magic360images']['tmp_name'] as $key => $tempName) {
                    if(!empty($tempName) && file_exists($tempName)) {
                        $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magic360images']['name'][$key]);
                        $ext = substr($name, strrpos($name, '.'));
                        $name = substr($name, 0, -strlen($ext));
                        $index = 0;
                        $suffix = '';
                        while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                            $suffix = "({$index})";
                            $index++;
                        }
                        if(move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                            $magic360Images[] = $name.$suffix.$ext;
                            $_magic360Columns++;
                        }
                    }
                }
                if(!$magic360Columns || $magic360Columns == $magic360ImagesCount) {
                    $magic360Columns = $_magic360Columns;
                }
                $updateDB = true;
            }
            break;
        case 'delete':
            if(is_numeric($_POST['magictoolboxImageId'])) {
                $_POST['magictoolboxImageId'] = (int)$_POST['magictoolboxImageId'];
                if(isset($magic360Images[$_POST['magictoolboxImageId']]) &&
                   file_exists($imageBasePath.$magic360Images[$_POST['magictoolboxImageId']]) &&
                   unlink($imageBasePath.$magic360Images[$_POST['magictoolboxImageId']])
                  ) {
                    $magic360ImagesCount = count($magic360Images);
                    unset($magic360Images[$_POST['magictoolboxImageId']]);
                    $magic360Images = array_values($magic360Images);
                    if($magic360Columns == $magic360ImagesCount) {
                        $magic360Columns--;
                    }
                    $updateDB = true;
                 }
            } else if($_POST['magictoolboxImageId'] == '') {
                $_magic360Columns = $magic360Columns;
                $magic360ImagesCount = count($magic360Images);
                foreach($magic360Images as $index => $magic360Image) {
                    if(file_exists($imageBasePath.$magic360Image) && unlink($imageBasePath.$magic360Image)) {
                        unset($magic360Images[$index]);
                        $_magic360Columns--;
                     }
                }
                $magic360Images = array_values($magic360Images);
                if($magic360Columns == $magic360ImagesCount) {
                    $magic360Columns = $_magic360Columns;
                }
                $updateDB = true;
            }
            break;
        case 'save':
            if(isset($_POST['magic360-columns']) && is_numeric($_POST['magic360-columns'])) {
                $magic360Columns = (int)$_POST['magic360-columns'];
                $updateDB = true;
            }
            if(!isset($_POST['magic360-multi-rows']) && $magic360Columns != count($magic360Images)) {
                $magic360Columns = count($magic360Images);
                $updateDB = true;
            }
            break;
        default :
    }
}

$magic360ImagesCount = count($magic360Images);
if($magic360Columns) {
    if($magic360Columns < $magic360ImagesCount) {
        $magic360Rows = floor($magic360ImagesCount/$magic360Columns);
        $multiRows = true;
    } else {
        $magic360Rows = 1;
    }
}

if($updateDB) {
    $gallery = implode(';', $magic360Images);
    if($insert) {
        db_query("INSERT INTO `{$table_prefix}magic360_images` (`id`, `gallery`, `columns`) VALUES ({$product_id}, '{$gallery}', {$magic360Columns})");
    } else {
        db_query("UPDATE `{$table_prefix}magic360_images` SET `gallery`='{$gallery}', `columns`={$magic360Columns} WHERE `id`={$product_id}");
    }
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Magic 360 images</title>
<?php
    $resourcesPath = MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/admin/magic360/resources/';
    echo '<link rel="stylesheet" href="'.$resourcesPath.'mt-form.css">';
    echo '<link rel="stylesheet" href="'.$resourcesPath.'mt-form-font.css">';
?>
<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
.mt-settings-form {
    margin: 0 auto;
    width: 80%;
}

.mt-button {
    height: 38px;
    vertical-align: middle;
}

/* upload images button */
div.mt-upload-container {
    text-align: center;
    overflow: hidden;
    width: 119px;
    height: 38px;
    display: inline-block;
    vertical-align: middle;
}
input.mt-upload-button {
    cursor: pointer;
    padding: 8px;
    color: #fff;
    font-size: 15px;
    background: #83c611;
    border: none;

    margin: 0;
    width: 119px;
    height: 38px;
}
input.mt-upload-button-hover {
    background: #77AC1C;
}
input.mt-upload-file {
    margin: 0;
    padding: 0;
    border: none;
    margin-top: -38px;
    margin-left:-410px;
    -moz-opacity: 0;
    filter: alpha(opacity=0);
    opacity: 0;
    font-size: 150px;
    height: 100px;
    cursor: pointer;
}
input.mt-upload-file::-webkit-file-upload-button {
    cursor: pointer;
}

.mt-param-holder.select select {
    width: 300px;
}
.mt-param-holder.select .mt-help-block {
    width: 300px;
    text-align: center;
    color: red;
}
.mt-table img {
    max-height: 100px;
}
.mt-table a {
    color: red !important;
}
</style>
</head>
<body>
<div class="mt-settings-form mt-border-r-4px">
<form id="magic360form" name="magic360form" action="<?php echo htmlentities($_SERVER['SCRIPT_NAME']); ?>" method="post" enctype="multipart/form-data">
<?php
    $generatedFormId = '';
    if(function_exists('func_generate_formid')) {
        if(function_exists('db_connection')) {
            db_connection($sql_host, $sql_user, $sql_db, $sql_password);
            $generatedFormId = func_generate_formid();
        } else {
            db_connect($sql_host, $sql_user, $sql_password);
            db_select_db($sql_db);
            $generatedFormId = func_generate_formid();
        }
    }
?>
    <input type="hidden" name="_formid" value="<?php echo $generatedFormId;?>" />
<?php
    if(!empty($_GET['productid'])) {
?>
<input type="hidden" value="<?php echo $_GET['productid']; ?>" id="magictoolboxProductId" name="magictoolboxProductId" />
<?php
    }
?>
    <input type="hidden" value="select" id="magictoolboxSubmitAction" name="magictoolboxSubmitAction" />
    <input type="hidden" value="" id="magictoolboxImageId" name="magictoolboxImageId" />
    <div class="magictoolboxContent">
        <h1>Magic 360 images</h1>
        <br />
        <?php if($product_id && $category_id) { ?>
        <div id="mt-buttons" class="mt-buttons">
            <div class="mt-upload-container">
                <input type="button" class="mt-upload-button mt-border-r-4px" id="upload-button" onclick="buttonClickHandler(this)" data-submit-action="upload" value="Upload images"/>
                <input class="mt-upload-file" type="file" name="magic360images[]" id="upload-images" multiple="multiple" accept="image/*" size="1" onchange="uploadFiles(this)" />
            </div>
            <?php if($magic360ImagesCount) { ?>
            <input type="button" class="mt-button mt-border-r-4px" onclick="buttonClickHandler(this)" data-submit-action="delete" value="Delete images"/>
            <input type="button" class="mt-button mt-border-r-4px" onclick="buttonClickHandler(this)" data-submit-action="save" value="Save"/>
            <?php } ?>
        </div>
        <?php } ?>

        <fieldset class="mt-border-r-4px">
            <legend>Products selector</legend>
            <div class="params-block">
                <div class="mt-form-item">
                    <div class="mt-param-name"><label for="category_id">Category</label></div>
                    <div class="mt-param-holder select">
                        <div class="mt-param-holder-inner">
                            <select id="category_id" name="category_id" class="categories_menu" onchange="this.form.product_id.selectedIndex = 0;this.form.submit();">
                                <option value="0">-- Please select category --</option>
                                <?php echo $categories_menu; ?>
                            </select>
                        </div>
                        <?php if($category_id && empty($products_menu)) { ?>
                        <span class="mt-help-block">this category has no products</span>
                        <?php } ?>
                    </div>
                </div>
                <div class="mt-form-item">
                    <div class="mt-param-name"><label for="product_id">Product</label></div>
                    <div class="mt-param-holder select">
                        <div class="mt-param-holder-inner">
                            <select id="product_id" name="product_id" class="products_menu" <?php echo $category_id ? '' : 'disabled="disabled"'; ?> onchange="this.form.submit();">
                                <option value="0">-- Please select product --</option>
                                <?php echo $products_menu; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
        <?php if($magic360ImagesCount) { ?>
        <fieldset class="mt-border-r-4px">
            <legend>Multi-row spin options</legend>
            <div class="params-block">
                <div class="mt-form-item">
                    <div class="mt-param-name"><label for="magic360-multi-rows">Multi-row spin</label></div>
                    <div class="mt-param-holder checkbox">
                        <div class="mt-param-holder-inner">
                            <input type="checkbox" id="magic360-multi-rows" name="magic360-multi-rows"<?php echo $multiRows ? ' checked="checked"' : ''; ?> onclick="switchMultiRows()" />
                        </div>
                    </div>
                </div>
                <div class="mt-form-item">
                    <div class="mt-param-name"><label for="magic360-columns">Number of images on X-axis</label></div>
                    <div class="mt-param-holder text">
                        <div class="mt-param-holder-inner">
                            <input type="text" id="magic360-columns" name="magic360-columns" size="10"<?php echo $multiRows ? '' : ' disabled="disabled"'; ?> value="<?php echo $magic360Columns; ?>" />
                        </div>
                    </div>
                </div>
                <div class="mt-form-item">
                    <div class="mt-param-name"><label for="magic360-rows">Number of images on Y-axis</label></div>
                    <div class="mt-param-holder text">
                        <div class="mt-param-holder-inner">
                            <input type="text" id="magic360-rows" name="magic360-rows" size="10"<?php echo $multiRows ? '' : ' disabled="disabled"'; ?> value="<?php echo $magic360Rows; ?>" />
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
        <fieldset class="mt-border-r-4px">
            <legend>Images</legend>
            <div class="params-block">
                <div class="mt-form-item">
                    <table id="magic360_images" cellspacing="0" cellpadding="0" class="mt-table">
                    <thead>
                        <tr>
                            <th title="">#</th>
                            <th title="">Image</th>
                            <th title="">Delete</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach($magic360Images as $index => $imageName) { ?>
                        <tr id="row-<?php echo $index; ?>">
                            <td>#<?php echo $index+1; ?></td>
                            <td>
                                <img src="<?php echo $imageBaseUrl.$imageName; ?>" alt="<?php echo $imageName; ?>" title="<?php echo $imageName; ?>" />
                            </td>
                            <td>
                                <a onclick="return deleteImage(<?php echo $index; ?>);" href="#" title="Delete image" >
                                    <span class="mt-icon-trash"></span>
                                </a>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                    </table>
                </div>
            </div>
        </fieldset>
        <?php } ?>
    </div>
</form>
</div>

<script type="text/javascript">
//<![CDATA[

    function switchMultiRows() {
        if(document.getElementById('magic360-multi-rows').checked) {
            document.getElementById('magic360-columns').removeAttribute('disabled');
            document.getElementById('magic360-rows').removeAttribute('disabled');
        } else {
            document.getElementById('magic360-columns').setAttribute('disabled', true);
            document.getElementById('magic360-rows').setAttribute('disabled', true);
        }
    }

    var fileInput = document.getElementById('upload-images');
    if(fileInput) {
        if(fileInput.addEventListener) {
            fileInput.addEventListener('mouseover', mouseoverHandler, false);
            fileInput.addEventListener('mouseout', mouseoutHandler, false);
        } else {
            fileInput.attachEvent('mouseover', mouseoverHandler);
            fileInput.addEventListener('mouseout', mouseoutHandler, false);
        }
    }
    function mouseoverHandler() {
        var button = document.getElementById('upload-button');
        button.style.background = '#77AC1C';
    }
    function mouseoutHandler() {
        var button = document.getElementById('upload-button');
        button.style.background = '#83c611';
    }
    function scrollHandler() {
        var buttonsContainer = document.getElementById('mt-buttons');
        if(!buttonsContainer) return;
        var buttonsContainerWrapper = buttonsContainer.parentNode;
        if(typeof(buttonsContainerWrapper.getBoundingClientRect) == 'undefined') return;
        var buttonsContainerWrapperBox = buttonsContainerWrapper.getBoundingClientRect();
        if(buttonsContainerWrapperBox.top < 0) {
            magicToolboxAddClass(buttonsContainer, 'affix');
        } else {
            magicToolboxRemoveClass(buttonsContainer, 'affix');
        }
    }
    if(window.addEventListener) {
        window.addEventListener('scroll', scrollHandler, false);
        window.addEventListener('resize', scrollHandler, false);
    } else {
        window.attachEvent('scroll', scrollHandler);
        window.attachEvent('resize', scrollHandler);
    }

    function magicToolboxHasClass(element, className) {
        return element.className.match(new RegExp('(\\s|^)'+className+'(\\s|$)'));
    }
    function magicToolboxAddClass(element, className) {
        if(!this.magicToolboxHasClass(element, className)) element.className += " "+className;
    }
    function magicToolboxRemoveClass(element, className) {
        if(magicToolboxHasClass(element, className)) {
            var reg = new RegExp('(\\s|^)'+className+'(\\s|$)');
            element.className = element.className.replace(reg, ' ');
        }
    }

    function buttonClickHandler(el) {
        var action = el.getAttribute('data-submit-action');

        var actionInput = document.getElementById('magictoolboxSubmitAction');
        actionInput.value = action;

        var form = document.getElementById('magic360form');
        form.submit();
    }

    function uploadFiles() {
        var button = document.getElementById('upload-button');
        buttonClickHandler(button);
    }

    function deleteImage(id) {
        document.magic360form.magictoolboxImageId.value = id;
        document.magic360form.magictoolboxSubmitAction.value = 'delete';
        document.magic360form.submit();
        return false;
    }
//]]>
</script>
</body>
</html>
