<?php

require './auth.php';
require $xcart_dir.'/include/security.php';
if(!defined('XCART_START')) { header("Location: ../"); die("Access denied"); }

// ini_set('display_errors', false);
// error_reporting(E_ALL & ~E_NOTICE);

global $xcart_tbl_prefix;
$table_prefix = defined('XC_TBL_PREFIX') ? XC_TBL_PREFIX : (isset($xcart_tbl_prefix) ? $xcart_tbl_prefix : 'xcart_');

$action = isset($_POST['magic360-submit-action']) ? $_POST['magic360-submit-action'] : false;
$activeTab = isset($_POST['magic360-active-tab']) ? $_POST['magic360-active-tab'] : false;

if($action == 'reset') {
    db_query("DELETE FROM `{$table_prefix}magic360`");
}

$tool = &MagicToolboxHelper::loadCoreClass('Magic360');

$adminPath = MagicToolboxHelper::getConfig('xcart_web_dir').'/modules/MagicToolbox/admin';

require_once(MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.'magic360.params.php');


$params = isset($_POST['magic360']) ? $_POST['magic360'] : false;

if($action == 'save') {

    foreach(func_get_magic360_params_map() as $blockId => $groups) {
        foreach($groups as $group) {
            foreach($group as $param => $required) {
                if(isset($params[$blockId][$param])) {
                    $value = $params[$blockId][$param];
                    switch($tool->params->getType($param)) {
                        case 'num':
                            $value = intval($value);
                            break;
                        case 'array':
                            $value = trim($value);
                            if(!in_array($value, $tool->params->getValues($param))) $value = $tool->params->getDefaultValue($param);
                            break;
                        case 'text':
                            $value = addslashes(trim($value));
                            break;
                        default: $value = trim($value);
                    }
                    db_query("UPDATE `{$table_prefix}magic360` SET `value`='{$value}', `enabled`=1 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    $tool->params->setValue($param, $value, $blockId);
                } else {
                    db_query("UPDATE `{$table_prefix}magic360` SET `enabled`=0 WHERE `block`='{$blockId}' AND `name`='{$param}'");
                    if($tool->params->paramExists($param, $blockId)) {
                        $tool->params->removeParam($param, $blockId);
                    };
                }
            }
        }
    }
}

include(
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'admin'.DIRECTORY_SEPARATOR.
    'magic360'.DIRECTORY_SEPARATOR.
    'magictoolbox.settings.editor.class.php'
);

$settings = new MagictoolboxSettingsEditorClass(
    //NOTE: path to js files
    MagicToolboxHelper::getConfig('xcart_dir').DIRECTORY_SEPARATOR.
    'modules'.DIRECTORY_SEPARATOR.
    'MagicToolbox'.DIRECTORY_SEPARATOR.
    'magic360'
);
$settings->paramsMap = func_get_magic360_params_map();
$settings->core = &MagicToolboxHelper::loadCoreClass('Magic360');
$settings->profiles = func_get_magic360_blocks();
$settings->action = htmlentities($_SERVER['REQUEST_URI']);
$settings->setResourcesURL($adminPath.'/magic360/resources/');
$settings->namePrefix = 'magic360';
if($activeTab) {
    $settings->activeTab = $activeTab;
}

$generatedFormId = '';
if(function_exists('func_generate_formid')) {
    if(function_exists('db_connection')) {
        db_connection($sql_host, $sql_user, $sql_db, $sql_password);
        $generatedFormId = func_generate_formid();
    } else {
        db_connect($sql_host, $sql_user, $sql_password);
        db_select_db($sql_db);
        $generatedFormId = func_generate_formid();
    }
}
$settings->setInputValue('_formid', $generatedFormId);

$settings->customSlideshowGroupTitle = 'Setup slideshow for home page';

$html = $settings->getHTML();

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Magic 360 settings editor</title>
<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    width: 80%;
    line-height: 18px;
}
</style>
</head>
<body>
<div id="container">
<?php echo $html; ?>
</div>
</body>
</html>
