<?php
    /**
     *  X-Cart module installer class
     */

    require_once(dirname(__FILE__).'/magictoolbox.installer.core.class.php');

    class MagicToolboxXCartModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        var $smartySkinDir = '';
        var $commonSmartySkinDir = '';
        var $filesToBackup = array();
        var $filesToCopy = array();
        var $XCartVersion = '';
        var $config = array();
        var $fixDetailedImagesWidget = false;
        var $isOldModuleInstalled = false;
        var $magictoolboxModules = array(
            'magic360',
            'magic360flash',
            'magiczoom',
            'magiczoomplus',
            'magicthumb',
            'magicmagnify',
            'magicmagnifyplus',
            'magicslideshow',
            'magicscroll',
            'magictouch',
        );

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';
            //$this->adminDir = dirname(__FILE__).'/admin';
        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');

            //for get $smarty_skin_dir
            $this->prepare();

            if(file_exists($this->dir.$this->smartySkinDir.'/magictoolbox/core/magic360.php')) {
                $this->isOldModuleInstalled = true;
                return true;
            } else if(file_exists($this->dir.'/modules/MagicToolbox/magic360.php')) {
                return true;
            }
            return false;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');
            if(!file_exists($this->dir.'/init.php')) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the X-Cart store directory.');
                return false;
            }
            //$this->fixDetailedImagesWidget = true;
            return true;
        }

        function getConfig() {
            static $config = null;
            if($config == null) {
                if(file_exists($this->dir.'/config.php')) {
                    if(!defined('XCART_START')) define('XCART_START', 1);//need for include config.php
                    require_once($this->dir.'/config.php');//need for getting $smarty_skin_dir and other variables (for DB)
                    $config = array();
                    $config['xcart_web_dir'] = isset($xcart_web_dir) ? $xcart_web_dir : '';
                    $config['smarty_skin_dir'] = isset($smarty_skin_dir) ? $smarty_skin_dir : '';
                    $config['sql_host'] = isset($sql_host) ? $sql_host : '';
                    $config['sql_user'] = isset($sql_user) ? $sql_user : '';
                    $config['sql_password'] = isset($sql_password) ? $sql_password : '';
                    $config['sql_db'] = isset($sql_db) ? $sql_db : '';
                } else {
                    $this->setError('X-Cart config does not exist');
                    return array();
                }
            }
            return $config;
        }

        function prepare() {
            $this->setStatus('check', 'prepare');

            $this->XCartVersion = $this->getPlatformVersion();
            if(empty($this->XCartVersion)) return false;
            $this->config = $this->getConfig();
            if(empty($this->config)) return false;

            if(version_compare($this->XCartVersion, '4.4.0', '<')) {
                //path to current Smarty template
                $this->smartySkinDir = empty($this->config['smarty_skin_dir']) ? '/skin1' : $this->config['smarty_skin_dir'];
            } else {
                $result = $this->getSelectQuery("SELECT value FROM xcart_config WHERE name='alt_skin' AND category=''");
                if($result === false) {
                    return false;
                }
                $skin_dir = '';
                if(($result = reset($result)) && isset($result['value'])) {
                    $skin_dir = preg_replace("#^[0-9]*_(.+)$#s", '$1', $result['value']);
                }
                if(empty($skin_dir)) {
                    $schemesDir = $this->dir.'/skin';
                    $schemes = @opendir($schemesDir);
                    $altSkinInfo = array();
                    while(($schemesSkinName = @readdir($schemes)) !== false) {
                        $schemesSkin = $schemesDir.'/'.$schemesSkinName;
                        $altskinINI = $schemesSkin.'/'.'altskin.ini';
                        if(is_dir($schemesSkin) && file_exists($altskinINI)) {
                            $skinInfo = parse_ini_file($altskinINI);
                            if (!empty($skinInfo)) {
                                $id = @$skinInfo['order'].'_'.$schemesSkinName;
                                $altSkinInfo[$id]['alt_schemes_skin_name'] = $schemesSkinName;
                            }
                        }
                    }
                    ksort($altSkinInfo);
                    $alt_skin_info = current($altSkinInfo);
                    $skin_dir = $alt_skin_info['alt_schemes_skin_name'];
                }

                $this->smartySkinDir = '/skin/'.$skin_dir;//$smarty_skin_root_dir.'/'.$skin_dir
                $this->commonSmartySkinDir = $this->config['smarty_skin_dir'];

                /*
                if($this->fixDetailedImagesWidget) {
                    //apply internal widget for Detailed Product Images module
                    $sql = "update xcart_config set value='I' where name='det_image_box_plugin'";
                    mysql_query($sql);
                }
                */

            }

            //for fix url's in css files
            //$this->resDir = $this->config['xcart_web_dir'].$this->smartySkinDir.'/magictoolbox/core';
            $this->resDir = $this->config['xcart_web_dir'].'/modules/MagicToolbox/magic360';

            return true;

        }

        function getExistsFilesRecursive($files) {
            $ret = array();
            foreach($files as $f) {
                while(!file_exists($this->dir.$f) && strlen($f) > 0 && strpos($f, '/') !== false) {
                    $f = substr($f, 0, strrpos($f, '/'));
                }
                $ret[] = $f;
            }
            return array_unique($ret);
        }

        function checkPerm() {

            $this->setStatus('check', 'perm');

            if($this->isOldModuleInstalled) {
                $checkFiles = array(
                    // directory
                    $this->smartySkinDir,
                    $this->smartySkinDir.'/modules',
                    $this->smartySkinDir.'/modules/Detailed_Product_Images',
                    $this->smartySkinDir.'/modules/Product_Options',
                    $this->smartySkinDir.'/customer',
                    '/admin'//for admin folder
                    // file
                );
                $checkFiles = $this->getExistsFilesRecursive($checkFiles);

                $this->filesToBackup = array(
                    $this->smartySkinDir.'/product_thumbnail.tpl',
                    $this->smartySkinDir.'/modules/Detailed_Product_Images/product_images.tpl',
                    $this->smartySkinDir.'/modules/Detailed_Product_Images/popup_image.tpl',
                    $this->smartySkinDir.'/customer/home.tpl',
                );

                foreach($this->filesToBackup as $file) {
                    if(!file_exists($this->dir.$file)) {
                        $this->filesToCopy[] = $file;
                    } else {
                        $checkFiles[] = $file;
                    }
                }

                //hack for '3-columns' theme and similar
                if(version_compare($this->XCartVersion, '4.4.0', '>='))
                if(!file_exists($this->dir.$this->smartySkinDir.'/css/altskin.css')) {
                    $checkFiles[] = $this->smartySkinDir.'/css';
                }

            } else {
                $checkFiles = array(
                    '/include',
                    '/include/product_modify.php',
                    '/include/templater',
                    '/include/templater/templater.php',
                    '/admin',
                    '/admin/magic360.php',
                    '/admin/magic360_images.php',
                    '/modules',
                    '/modules/MagicToolbox',
                    '/modules/MagicToolbox/magic360.php',
                    '/modules/MagicToolbox/magic360.params.php',
                    '/modules/MagicToolbox/magic360',
                    '/modules/MagicToolbox/admin',
                );
                $checkFiles = $this->getExistsFilesRecursive($checkFiles);
                $this->filesToBackup = array(
                    '/include/product_modify.php',
                    '/include/templater/templater.php',
                );
            }

            list($result, $wrang) = $this->checkFilesPerm($checkFiles);
            if(!$result) {
                $this->setError('This installer need to modify some X-Cart store files.');
                $this->setError('Please check write access for following files of your X-Cart store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }

            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            /*
            if(version_compare($this->XCartVersion, '4.4.0', '>=')) {
                foreach($this->filesToCopy as $file) {
                    $src = $this->dir.preg_replace('/^'.preg_quote($this->smartySkinDir, '/').'\//', $this->commonSmartySkinDir.'/', $file);
                    if(file_exists($src)) {
                        $this->createDirRecursive(dirname($this->dir.$file));
                        copy($src, $this->dir.$file);
                    }
                }
            }
            */
            list($result, $wrang) = $this->createBackups($this->filesToBackup);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            if($this->isOldModuleInstalled) $this->removeBackups($this->filesToBackup);
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            //NOTE: copy admin folder
            $this->copyDir($this->modDir.'/admin', $this->dir.'/admin');
            //NOTE: copy magictoolbox folder
            $this->copyDir($this->modDir.'/modules', $this->dir.'/modules', 0755, false);
            //NOTE: copy images folder
            $this->copyDir($this->modDir.'/images', $this->dir.'/images', 0755, false);

            //NOTE: copyDir logs 'templater.php'
            //NOTE: try to update templater.php separately
            @copy($this->modDir.'/modules/MagicToolbox/templater.php', $this->dir.'/modules/MagicToolbox/templater.php');

            //NOTE: modify include/templater/templater.php file
            $pathToFile = $this->dir.'/include/templater/templater.php';
            if(file_exists($pathToFile)) {
                $contents = file_get_contents($pathToFile);
                $pattern = '/class\s+(XC)?Templater\s+extends\s+Smarty(BC)?/is';
                $replace = 'class $1TemplaterOriginal extends Smarty$2';
                if(preg_match($pattern, $contents)) {
                    $contents = preg_replace($pattern, $replace, $contents);

                    $pattern = '/function\s+Templater\s*\(/is';
                    if(version_compare($this->XCartVersion, '4.7.0', '<') || preg_match($pattern, $contents)) {
                        $replace = 'function TemplaterOriginal(';
                        if(preg_match($pattern, $contents)) {
                            $contents = preg_replace($pattern, $replace, $contents);
                        } else {
                            if(!preg_match('/function\s+TemplaterOriginal\s*\(/is', $contents)) {
                                $this->setError('Error: Perhaps the file '.$pathToFile.' was modified. Please, try to install Magic 360 manually.');
                                return false;
                            }
                        }
                    }

                    $pattern = '/\?>/is';
                    $replace = "\nrequire_once(\$xcart_dir.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'MagicToolbox'.DIRECTORY_SEPARATOR.'templater.php');\n?>";
                    if(preg_match($pattern, $contents)) {
                        $contents = preg_replace($pattern, $replace, $contents);
                    } else {
                        $contents .= $replace;
                    }
                    file_put_contents($pathToFile, $contents);

                } else {
                    if(!preg_match('/class\s+(XC)?TemplaterOriginal\s+extends\s+Smarty(BC)?/is', $contents)) {
                        $this->setError('Error: Perhaps the file '.$pathToFile.' was modified. Please, try to install Magic 360 manually.');
                        return false;
                    }
                }
            } else {
                $this->setError('Error: The file '.$pathToFile.' not exists!');
                return false;
            }

            //modify include/product_modify.php file
            $pathToFile = $this->dir.'/include/product_modify.php';
            if(file_exists($pathToFile)) {
                $contents = file_get_contents($pathToFile);
                $pattern = '/if\s*\(\s*\(\s*\$REQUEST_METHOD\s*==\s*\'POST\'\s*\)\s*&&\s*\(\s*\$mode\s*==\s*\'product_modify\'\s*\)\s*\)\s*\{/is';
                $replace = '
if(!empty($product_info))
$dialog_tools_data[\'left\'][] = array(
    \'link\'  => $xcart_web_dir.DIR_ADMIN."/magic360_images.php?productid={$productid}",
    \'target\' => \'_blank\',
    \'title\' => \'Magic 360 Images\'
);

$0
';
                if(preg_match($pattern, $contents)) {
                    $contents = preg_replace($pattern, $replace, $contents);
                    file_put_contents($pathToFile, $contents);
                }
            }

            return true;
        }

        function uninstall_from_logFile($exclude = array()) {

            $removeAll = true;
            foreach($this->magictoolboxModules as $module) {
                if($module != 'magic360' && file_exists($this->dir.'/modules/MagicToolbox/'.$module.'.php')) {
                    $removeAll = false;
                    break;
                }
            }

            if(!$removeAll) {
                $exclude[] = 'include/templater/templater.php';
                $exclude[] = 'modules/MagicToolbox/.htaccess';
                $exclude[] = 'modules/MagicToolbox/templater.php';
                $exclude[] = 'modules/MagicToolbox/product.js';
                $exclude[] = 'modules/MagicToolbox/admin/graphics';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/logo.gif';

                //NOTE: these files don't exist after v5.5.5
                $exclude[] = 'modules/MagicToolbox/admin/graphics/bottom.gif';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/left.gif';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/magicscroll.png';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/no.gif';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/right.gif';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/top.gif';
                $exclude[] = 'modules/MagicToolbox/admin/graphics/yes.gif';

            }

            $return = parent::uninstall_from_logFile($exclude);

            if($removeAll) {
                $src  = '/include/templater/templater~backup~created~by~magictoolbox~team.php';
                $dest = '/include/templater/templater.php';
                if(file_exists($this->dir.$src)) {
                    copy($this->dir.$src, $this->dir.$dest);
                    $this->removeDir($this->dir.'/modules/MagicToolbox/');
                }
            }

            return $return;
        }

        function restoreStep_installFiles() {

            if($this->isOldModuleInstalled) {
                $this->restoreFromBackups($this->filesToBackup);

                $this->removeDir($this->dir.$this->smartySkinDir.'/magictoolbox');

                //hack for '3-columns' theme and similar
                if(version_compare($this->XCartVersion, '4.4.0', '>='))
                if(file_exists($this->dir.$this->smartySkinDir.'/css/altskin.css')) {
                    $fileContents = file_get_contents($this->dir.$this->smartySkinDir.'/css/altskin.css');
                    if($fileContents == '/* magic360 */') {
                        @unlink($this->dir.$this->smartySkinDir.'/css/altskin.css');
                    }
                }
                @unlink($this->dir.'/admin/magic360.php');
            } else {
                @unlink($this->dir.'/admin/magic360.php');
                @unlink($this->dir.'/modules/MagicToolbox/magic360.php');
                $removeAll = true;
                foreach($this->magictoolboxModules as $module) {
                    if($module != 'magic360' && file_exists($this->dir.'/modules/MagicToolbox/'.$module.'.php')) {
                        $removeAll = false;
                        break;
                    }
                }
                if($removeAll) {
                    $this->removeDir($this->dir.'/modules/MagicToolbox');
                } else {
                    $this->removeDir($this->dir.'/modules/MagicToolbox/admin/magic360');
                    $this->removeDir($this->dir.'/modules/MagicToolbox/magic360');
                    @unlink($this->dir.'/modules/MagicToolbox/magic360.params.php');
                }
            }
            return true;
        }

        function upgrade($files) {
            $path = $this->dir.'/modules/MagicToolbox/magic360/';
            foreach($files as $name => $file) {
                if(file_exists($path.$name)) {
                    unlink($path.$name);
                }
                file_put_contents($path.$name, $file);
                chmod($path.$name, 0755);
            }
            return true;
        }

        function getTableAlias($table = '') {
            static $sql_tbl = null;
            if($sql_tbl == null) {
                if(file_exists($this->dir.'/init.php')) {
                    $contents = file_get_contents($this->dir.'/init.php');
                    $match = array();
                    $pattern = 'define\s*\(\s*\'XC_TBL_PREFIX\'\s*,\s*\'[^\']*\'\s*\)\s*;';
                    if(preg_match('/'.$pattern.'/i', $contents, $match)) {
                        $exeption = eval($match[0]);
                    }
                    $pattern = '\$sql_tbl\s*=\s*array\s*\([^\)]*\)\s*;';
                    if(preg_match('/'.$pattern.'/i', $contents, $match)) {
                        $exeption = eval($match[0]);
                        if($exeption !== null) {
                            return $table;
                        }
                    } else return $table;
                } else return $table;
            }
            return isset($sql_tbl[$table]) ? $sql_tbl[$table] : $table;
        }

        function getPlatformVersion() {
            static $version = '';
            if($version == null) {
                $config = $this->getConfig();
                if(empty($config)) return '';
                $table = $this->getTableAlias('config');
                $result = $this->getSelectQuery("SELECT value FROM {$table} WHERE name='version'");
                if($result === false) {
                    return '';
                }
                if(($result = reset($result)) && isset($result['value'])) {
                    $version = $result['value'];
                } else {
                    if(!file_exists($this->dir.'/VERSION')) {
                        $this->setError('File VERSION does not exist! Can not detect version!');
                        return '';
                    }
                    //get version
                    $fileVersion = file_get_contents($this->dir.'/VERSION');
                    $pattern = "/.*?([0-9]+\.[0-9]+(?:\.[0-9]+)*).*/s";
                    $version = preg_replace($pattern, '$1', $fileVersion);
                    if($version == $fileVersion) {
                        $version = '';
                        $this->setError('Wrong VERSION file! Can not detect version!');
                        return '';
                    }
                }
            }
            return $version;
        }

        function getSelectQuery($query) {
            $config = $this->getConfig();
            if(empty($config)) return false;
            $result = array();
            if(class_exists('PDO')) {
                if(preg_match('#^(.+):([0-9]+)$#is', $config['sql_host'], $matches)) {
                    //NOTE: if port specified
                    $dsn = "mysql:host={$matches[1]};port={$matches[2]};dbname={$config['sql_db']}";
                } else if(preg_match('#^(.+):((?:/[^/]++)++)$#is', $config['sql_host'], $matches)) {
                    //NOTE: if unix socket specified
                    $dsn = "mysql:host={$matches[1]};unix_socket={$matches[2]};dbname={$config['sql_db']}";
                } else {
                    $dsn = "mysql:host={$config['sql_host']};dbname={$config['sql_db']}";
                }
                $options = array(
                    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
                );
                try {
                    $pdo = new PDO($dsn, $config['sql_user'], $config['sql_password'], $options);
                } catch (PDOException $e) {
                    $this->setError('Could not connect: '.$e->getMessage());
                    return false;
                }
                $statement = $pdo->query($query);
                if(!$statement) {
                    $errorInfo = $pdo->errorInfo();
                    $errorInfo = isset($errorInfo[2]) ? $errorInfo[2] : 'SQLSTATE '.$errorInfo[0];
                    $this->setError('Error while trying execute query.<br/>Query: '.$query.'<br/>Mysql Error: '.$errorInfo);
                    return false;
                }
                while($row = $statement->fetch(PDO::FETCH_ASSOC)) {
                    $result[] = $row;
                }
                $statement->closeCursor();
            } else if(function_exists('mysqli_connect')) {
                if(preg_match('#^(.+):([0-9]+)$#is', $config['sql_host'], $matches)) {
                    $link = mysqli_connect($matches[1], $config['sql_user'], $config['sql_password'], $config['sql_db'], $matches[2]);
                } else {
                    $link = mysqli_connect($config['sql_host'], $config['sql_user'], $config['sql_password'], $config['sql_db']);
                }
                if(mysqli_connect_errno()) {
                    $this->setError('Could not connect: '.mysqli_connect_error());
                    return false;
                }
                $resource = mysqli_query($link, $query);
                if(!$resource) {
                    $this->setError('Error while trying execute query.<br/>Query: '.$query.'<br/>Mysql Error: '.mysqli_error());
                    mysqli_close($link);
                    return false;
                }
                while($row = mysqli_fetch_assoc($resource)) {
                    $result[] = $row;
                }
                mysqli_free_result($resource);
                mysqli_close($link);
            } else {
                $link = mysql_connect($config['sql_host'], $config['sql_user'], $config['sql_password']);
                if(!$link) {
                    $this->setError('Could not connect: '.mysql_error());
                    return false;
                }
                $db_selected = mysql_select_db($config['sql_db'], $link);
                if(!$db_selected) {
                    $this->setError('Can\'t use "'.$config['sql_db'].'" : '.mysql_error());
                    mysql_close($link);
                    return false;
                }
                $resource = mysql_query($query);
                if(!$resource) {
                    $this->setError('Error while trying execute query.<br/>Query: '.$query.'<br/>Mysql Error: '.mysql_error());
                    mysql_close($link);
                    return false;
                }
                while($row = mysql_fetch_assoc($resource)) {
                    $result[] = $row;
                }
                mysql_free_result($resource);
                mysql_close($link);
            }
            return $result;
        }

    }
