/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Product details controller
 *
 */

if ('undefined' != typeof(ProductDetailsView)) {

  //NOTE: fixed JS error due to unconnected colorbox plugin (because of replaced gallery)
  if ('undefined' != typeof($) && 'undefined' == typeof($.colorbox)) {
    $.colorbox = {};
    $.colorbox.remove = function (){};
  }

  ProductDetailsView.prototype.mtPreviousData = '';

  ProductDetailsView.prototype.mtProductId = null;

  ProductDetailsView.prototype.mtMainNodeId = null;

  ProductDetailsView.prototype.mtMainNode = null;

  ProductDetailsView.prototype.mtGalleryNodeId = null;

  ProductDetailsView.prototype.mtGalleryNode = null;

  ProductDetailsView.prototype.mtCurrentHref = '';

  ProductDetailsView.prototype.mtNeedStart = false;

  ProductDetailsView.prototype.addProductToCartOriginal = ProductDetailsView.prototype.addProductToCart;
  ProductDetailsView.prototype.addProductToCart = function(event)
  {
    this.mtToolStop();
    this.mtNeedStart = true;
    this.addProductToCartOriginal.apply(this, arguments);
  };

  ProductDetailsView.prototype.postprocessOriginal = ProductDetailsView.prototype.postprocess;
  ProductDetailsView.prototype.postprocess = function(isSuccess, initial)
  {
    this.postprocessOriginal.apply(this, arguments);

    if (!this.mtNeedStart) {
      return;
    }

    this.mtToolStart();

    //NOTE: reset the data so that they update after adding the product to the shopping cart
    this.mtPreviousData = '';

    this.mtNeedStart = false;
  }

  ProductDetailsView.prototype.getURLParametersForLoadVariantsImages = function(productId)
  {
    var params = {product_id: productId};
    params = array_merge(params, core.getWidgetsParams('update-product-page', params));
    return array_merge({'target': 'product', 'action': 'get_magiczoomplus_data'}, params);
  }

  ProductDetailsView.prototype.handleLoadVariantsImages = function (XMLHttpRequest, textStatus, data)
  {
    var mtData = data;

    if (this.mtPreviousData != data) {

      if (data && _.isString(data)) {
        data = $.parseJSON(data);
      }

      var input = $('input[name="product_id"]');
      if (input.length > 0) {
        this.mtProductId = input.val();
      }

      this.mtMainNodeId = 'MagicZoomPlusImageProduct' + this.mtProductId;
      this.mtMainNode = document.getElementById(this.mtMainNodeId);
      this.mtGalleryNodeId = 'MagicToolboxSelectors' + this.mtProductId;
      this.mtGalleryNode = document.getElementById(this.mtGalleryNodeId);

      if (typeof(MagicZoom) != 'undefined' && this.mtMainNode) {
        if (mtIsOriginalTemplate) {
          if (this.base.find('.product-image-gallery:visible').length > 0) {
            this.processVariantImageAsGallery(data);
          } else {
            //NOTE: when product has only one image in gallery (product image or product variant image)
            this.processVariantImageAsImage(data);
          }
        } else {
          if (this.mtGalleryNode && $(this.mtGalleryNode).parent().css('display') != 'none') {
            this.mtProcessVariantImageAsGallery(data);
          } else {
            this.mtProcessVariantImageAsImage(data);
          }
        }
      }

    }

    if (this.loadVariantsImagesShade) {
      this.base.find('.product-details-info .single-progress-mark').remove();
    }

    this.mtPreviousData = mtData;
  }

  // Save original function
  ProductDetailsView.prototype.hideLightboxOriginal = ProductDetailsView.prototype.hideLightbox;

  ProductDetailsView.prototype.hideLightbox = function()
  {
    this.hideLightboxOriginal.apply(this, arguments);

    var gallery = $('.product-image-gallery:not(.mobile) ul', this.base);
    var mobileGallery = $('.product-image-gallery.mobile ul', this.base);

    mobileGallery.find('li a')
      .unbind('click.mobileSelector')
      .bind('click.mobileSelector', {'gallery': gallery, 'view': this}, this.mtOnClick);
  }

  ProductDetailsView.prototype.mtOnClick = function(event)
  {
    var href = $(this).attr('href');
    var target = event.data.gallery.find('li a[href="' + href + '"]');
    if (target.length) {
      //NOTE: call 'btnclick' event on mz(p) selector to initiate image switching
      magicJS.$(target.get(0)).jCallEvent('btnclick', {'target': target.get(0)});
      //event.data.view.mtRunEvent(target.get(0), 'MouseEvents', 'click');

    }
    return false;
  }

  ProductDetailsView.prototype.mtRunEvent = function(element, eventType, eventName)
  {
    var event;
    if (document.createEvent) {
      event = document.createEvent(eventType);
      event.initEvent(eventName, true, true);
      element.dispatchEvent(event);
    } else {
      event = document.createEventObject();
      event.eventType = eventType;
      element.fireEvent('on' + eventName, event);
    }
    return event;
  }

  ProductDetailsView.prototype.selectImage = function(pos)
  {
    //NOTE: this function is called when clicking on <a>
    //      the click handler is binded in the original 'hideLightbox' function
    var gallery = this.base.find('.product-image-gallery:not(.mobile) li');
    gallery.removeClass('selected');
    var next = gallery.eq(pos);
    next.addClass('selected');

    gallery = this.base.find('.product-image-gallery.mobile li');
    gallery.removeClass('selected');
    next = gallery.eq(pos);
    next.addClass('selected');
  }

  ProductDetailsView.prototype.processVariantImageAsGallery = function(data)
  {
    var aHref,
        aDataImage,
        newVariantHtml,
        gallery,
        mGallery,
        prevVariant,
        imageChanged = false,
        li,
        firstSelector;

    newVariantHtml = (data && _.isObject(data) ? data.magiczoomplus.html : null);
    gallery = this.base.find('.product-image-gallery:not(.mobile)');
    mGallery = this.base.find('.product-image-gallery.mobile');
    prevVariant = gallery.find('.variant-image');/* li.variant-image */

    if (newVariantHtml && prevVariant.length) {
      aHref = newVariantHtml.replace(/^.+href="([^"]+)".+$/, '$1');
      imageChanged = prevVariant.find('a').attr('href') != aHref;
    } else if (newVariantHtml || prevVariant.length) {
      imageChanged = true;
    }

    if (!imageChanged) {
      return;
    }

    this.mtToolStop();

    if (newVariantHtml) {
      li = gallery.find('li:eq(0)').clone(true);
      li.html(newVariantHtml);
      li.addClass('variant-image');
      gallery.find('.variant-image').remove();
      gallery.find('li:eq(0)').before(li);

      li = mGallery.find('li:eq(0)').clone(true);
      newVariantHtml = newVariantHtml.replace(/\sdata\-zoom\-id\s*=\s*"[^"]*"/, ' ');
      newVariantHtml = newVariantHtml.replace(/\sdata\-options\s*=\s*"[^"]*"/, ' ');
      newVariantHtml = newVariantHtml.replace(/^<a /, '<a onclick="return false;" ');
      li.html(newVariantHtml);
      li.addClass('variant-image');
      mGallery.find('.variant-image').remove();
      mGallery.find('li:eq(0)').before(li);
    } else {
      gallery.find('.variant-image').remove();
      mGallery.find('.variant-image').remove();
    }

    //NOTE: change main image before start
    firstSelector = gallery.find('li:eq(0) a');
    aHref = firstSelector.attr('href');
    aDataImage = firstSelector.attr('data-image');
    $(this.mtMainNode).attr('href', aHref).find('img').attr('src', aDataImage);
    //NOTE: to fix an issue with displaying old main image after tool start
    $(this.mtMainNode).attr('data-image', aDataImage);

    this.mtToolStart();

    //NOTE: gallery reinitialization
    if (typeof(this.initializeGallery) == 'undefined') {
      this.gallery = gallery.find('li');
    } else {
      this.initializeGallery();
    }

    //NOTE: to bind gallery items
    this.hideLightbox();

    //NOTE: to change selection
    gallery.find('li.selected').removeClass('selected');
    gallery.find('li:eq(0)').addClass('selected');
    mGallery.find('li.selected').removeClass('selected');
    mGallery.find('li:eq(0)').addClass('selected');
  }

  ProductDetailsView.prototype.processVariantImageAsImage = function(data)
  {
    var html, aHref, aDataImage;

    if (this.mtCurrentHref == '') {
      this.mtCurrentHref = this.mtMainNode.href;
    }

    if (data && _.isObject(data)) {
        html = data.magiczoomplus.html;
        aHref = html.replace(/^.+href="([^"]+)".+$/, '$1');
        aDataImage = html.replace(/^.+data-image="([^"]+)".+$/, '$1');
    } else {
      if (this.base.find('.product-image-gallery li').length > 0) {
        var a = this.base.find('.product-image-gallery li a');
        aHref = a.attr('href');
        aDataImage = a.attr('data-image');
      } else {
        var img = this.base.find('.default-image img');
        aHref = aDataImage = img.attr('src');
      }
    }

    if (this.mtCurrentHref != aHref) {
      this.mtCurrentHref = aHref;
      MagicZoom.update(this.mtMainNodeId, aHref, aDataImage);
    }
  }

  ProductDetailsView.prototype.mtProcessVariantImageAsGallery = function(data)
  {
    var aHref,
        aDataImage,
        newVariantHtml,
        newVariant,
        gallery,
        prevVariant,
        imageChanged = false,
        firstSelector;

    newVariantHtml = (data && _.isObject(data) ? data.magiczoomplus.html : null);
    gallery = this.base.find('#' + this.mtGalleryNodeId);
    prevVariant = gallery.find('a[data-variant-image]');

    if (newVariantHtml && prevVariant.length) {
      aHref = newVariantHtml.replace(/^.+href="([^"]+)".+$/, '$1');
      imageChanged = prevVariant.attr('href') != aHref;
    } else if (newVariantHtml || prevVariant.length) {
      imageChanged = true;
    }

    if (!imageChanged) {
      return;
    }

    this.mtToolStop();

    if (newVariantHtml) {
      newVariant = $(newVariantHtml);
      newVariant.attr('data-variant-image', true);
      prevVariant.remove();
      gallery.prepend(newVariant);
    } else {
      prevVariant.remove();
    }

    //NOTE: change main image before start
    firstSelector = gallery.find('a');
    aHref = firstSelector.attr('href');
    aDataImage = firstSelector.attr('data-image');
    $(this.mtMainNode).attr('href', aHref).find('img').attr('src', aDataImage);
    //NOTE: to fix an issue with displaying old main image after tool start
    $(this.mtMainNode).attr('data-image', aDataImage);

    this.mtToolStart();
  }

  ProductDetailsView.prototype.mtProcessVariantImageAsImage = function(data)
  {
    var html, aHref, aDataImage, gallery, firstSelector;

    if (this.mtCurrentHref == '') {
      this.mtCurrentHref = this.mtMainNode.href;
    }

    if (data && _.isObject(data)) {
        html = data.magiczoomplus.html;
        aHref = html.replace(/^.+href="([^"]+)".+$/, '$1');
        aDataImage = html.replace(/^.+data-image="([^"]+)".+$/, '$1');
    } else {
      gallery = this.base.find('#' + this.mtGalleryNodeId);
      firstSelector = gallery.find('a');
      if (firstSelector.length) {
        aHref = firstSelector.attr('href');
        aDataImage = firstSelector.attr('data-image');
      } else {
        aHref = aDataImage = this.base.find('.default-image img').attr('src');
      }
    }

    if (this.mtCurrentHref != aHref) {
      this.mtCurrentHref = aHref;
      MagicZoom.update(this.mtMainNodeId, aHref, aDataImage);
    }
  }

  ProductDetailsView.prototype.mtUpdateMainNode = function(selector)
  {
    var aNode = $(this.mtMainNode), imgNode;
    aNode.attr('href', selector.attr('href'));
    aNode.attr('title', selector.attr('title'));
    imgNode = aNode.find('img');
    imgNode.attr('src', selector.attr('data-image'));
    imgNode.attr('alt', selector.attr('title'));
  }

  ProductDetailsView.prototype.mtToolStop = function()
  {
    var gallery = $(this.mtGalleryNode);
    if (gallery.length > 0) {
      if (gallery.hasClass('MagicScroll')) {
        MagicScroll.stop(this.mtGalleryNodeId);
      }
    }
    MagicZoom.stop(this.mtMainNodeId);
    mtIsToolReady = false;
  }

  ProductDetailsView.prototype.mtToolStart = function()
  {
    var mtMainNodeId = this.mtMainNodeId;
    //NOTE: wrap tool start to fix issue with updating main thumbnail
    //setTimeout(function(){
      MagicZoom.start(mtMainNodeId);
    //}, 0);
    var gallery = $(this.mtGalleryNode);
    if (gallery.length > 0) {
      if (gallery.hasClass('MagicScroll')) {
        MagicScroll.start(this.mtGalleryNodeId);
      }
    }
  }
}
