<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

return function () {

    //NOTE: check the repository
    $repo = \XLite\Core\Database::getRepo('\XLite\Module\MagicToolbox\MagicZoomPlus\Model\Config');
    $doLoadFixturesFromYaml = !($repo && $repo->count());
    if ($doLoadFixturesFromYaml) {
        $yaml = \Includes\Utils\ModulesManager::getModuleYAMLFiles('MagicToolbox', 'MagicZoomPlus');
        $yaml = $yaml[0];
        if (\Includes\Utils\FileManager::isFileReadable($yaml)) {
            \XLite\Core\Database::getInstance()->loadFixturesFromYaml($yaml);
        }
        $repo = \XLite\Core\Database::getRepo('\XLite\Module\MagicToolbox\MagicZoomPlus\Model\Config');
    }

    $licenseKeyOptionNames = array(
        'magiczoomplus' => 'license-key',
        'magicscroll' => 'magicscroll-license-key',
    );
    $licenseKeys = array();

    //NOTE: find license keys
    $configRepo = \XLite\Core\Database::getRepo('\XLite\Model\Config');
    $options = $configRepo->findBy(array(
        'category' => 'MagicToolbox\MagicZoomPlusBackup',
        'name' => array_values($licenseKeyOptionNames)
    ));
    foreach ($options as $option) {
        $licenseKey = strtoupper(trim($option->value));
        if (!empty($licenseKey) && !preg_match('#[^\-\.0-9A-Za-z]#', $licenseKey)) {
            $licenseKeys[$option->name] = $licenseKey;
        }
        $configRepo->delete($option);
    }

    //NOTE: update license keys
    $options = $repo->findByProfileAndNames(
        'default',
        array_values($licenseKeyOptionNames)
    );
    foreach ($options as $option) {
        if (!empty($licenseKeys[$option->name])) {
            $option->value = $licenseKeys[$option->name];
            $repo->update($option);
        }
    }

    //NOTE: update js files
    foreach ($licenseKeyOptionNames as $fileName => $optionName) {
        if (!empty($licenseKeys[$optionName])) {
            $url = "https://www.magictoolbox.com/site/order/{$licenseKey}/{$fileName}.js";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
            $response = curl_exec($ch);
            $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($code == 200) {
                $jsPath = "modules/MagicToolbox/MagicZoomPlus/js/{$fileName}.js";
                $jsPath = \XLite\Core\Layout::getInstance()->getResourceFullPath($jsPath, \XLite::CUSTOMER_INTERFACE, false);
                \Includes\Utils\FileManager::write($jsPath, $response, 0, 0755);
                if (\Includes\Utils\FileManager::write($jsPath, $response, 0, 0755)) {
                    \XLite\Core\TopMessage::addInfo('Magic Zoom Plus license have been updated successfully.');
                    $href = \XLite::ADMIN_SELF.'?'.http_build_query(array('target' => 'css_js_performance'));
                    $href = \XLite\Core\URLManager::getShopURL($href);
                    \XLite\Core\TopMessage::addInfo("Please don't forget to <a href=\"{$href}\">clear aggregation cache</a> if need it.");
                }
            } elseif ($code == 403) {
                \XLite\Core\TopMessage::addWarning('There was a problem with checking your license key. Please <a target="_blank" href="http://www.magictoolbox.com/contact/">contact us</a>.');
            } else {
                \XLite\Core\TopMessage::addWarning('Please enter the valid license key.');
            }
        }
    }

};
