<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicZoomPlus\View\Product\Details\Customer;

/**
 * PhotoBox
 *
 * @ListChild (list="product.details.page.image", weight="0")
 */
class PhotoBox extends \XLite\View\Product\Details\Customer\PhotoBox implements \XLite\Base\IDecorator
{
    /**
     * Return current template
     *
     * @return string
     */
    protected function getTemplate()
    {
        $tool = static::getToolObj('MagicZoomPlus');
        if ($tool->params->checkValue('enable-effect', 'Yes', 'product')) {
            return 'modules/MagicToolbox/MagicZoomPlus/templates/photobox.twig';
        }

        return parent::getTemplate();
    }

    /**
     * Check for CrispWhite skin
     *
     * @return boolean
     */
    protected function isCrispWhiteSkin()
    {
        static $isCrispWhiteSkin = null;

        if ($isCrispWhiteSkin === null) {
            $isCrispWhiteSkin = false;

            $version = \XLite::getInstance()->getVersion();
            if (version_compare($version, '5.4', '<')) {
                $module = \XLite\Core\Database::getRepo('XLite\Model\Module')->getCurrentSkinModule();
                if ($module && $module->getActualName() == 'XC\CrispWhiteSkin') {
                    $isCrispWhiteSkin = true;
                }
            } else {
                $currentSkinModuleId = \XLite\Core\Skin::getInstance()->getCurrentSkinModuleId();
                if ($currentSkinModuleId == 'XC-CrispWhiteSkin') {
                    $isCrispWhiteSkin = true;
                }
            }
        }

        return $isCrispWhiteSkin;
    }
}
