<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicZoomPlus\Controller\Customer;

/**
 * Product Controller
 *
 */
class Product extends \XLite\Controller\Customer\Product implements \XLite\Base\IDecorator
{
    /**
     * Get images data
     *
     * @return void
     */
    protected function doActionGetMagicZoomPlusData()
    {
        $data = null;

        $productVariantImage = null;
        if ($this->getProduct()->mustHaveVariants()) {
            $ids = array();
            $attributeValues = trim(\XLite\Core\Request::getInstance()->{\XLite\View\Product\Details\Customer\Widget::PARAM_ATTRIBUTE_VALUES}, ',');
            if ($attributeValues) {
                $attributeValues = explode(',', $attributeValues);
                foreach ($attributeValues as $v) {
                    $v = explode('_', $v);
                    $ids[$v[0]] = $v[1];
                }
            }
            $productVariant = $this->getProduct()->getVariant(
                $this->getProduct()->prepareAttributeValues($ids)
            );
            if ($productVariant && $productVariant->getImage()) {
                $productVariantImage = $productVariant->getImage();
            }
        }

        $html = $this->getMagicZoomPlusHTML($productVariantImage);
        if ($html) {
            $data = array(
                'magiczoomplus' => array('html' => $html)
            );
        }

        $this->displayJSON($data);
        $this->setSuppressOutput(true);
    }

    /**
     * Get HTML
     *
     * @param \XLite\Module\XC\ProductVariants\Model\Image\ProductVariant\Image $variantImage Image
     *
     * @return mixed
     */
    protected function getMagicZoomPlusHTML($variantImage = null)
    {
        $tool = \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\Helper::getInstance()->getPrimaryTool();
        $tool->params->setProfile('product');

        if (!$variantImage || $tool->params->checkValue('enable-effect', 'No')) {
            return false;
        }

        $product = $this->getProduct();
        $productId = $product->getId();
        $productName = $product->getName();
        $html = '';
        $original = $tool->params->checkValue('template', 'original');
        $thumbMaxWidth = intval($tool->params->getValue('thumb-max-width'));
        $thumbMaxHeight = intval($tool->params->getValue('thumb-max-height'));
        $selectorMaxWidth = intval($tool->params->getValue('selector-max-width'));
        $selectorMaxHeight = intval($tool->params->getValue('selector-max-height'));
        $useAlt = $tool->params->checkValue('use-individual-titles', 'Yes');

        $img = $variantImage->getURL();
        list($width, $height, $thumb) = $variantImage->doResize($thumbMaxWidth, $thumbMaxHeight, false);
        list($width, $height, $selector) = $variantImage->doResize($selectorMaxWidth, $selectorMaxHeight, false);
        $alt = $useAlt ? $variantImage->getAlt() : '';
        $html = $tool->getSelectorTemplate(array(
            'id' => 'Product'.$productId,
            'group' => 'productPage',
            'img' => $img,
            'medium' => $thumb,
            'thumb' => $selector,
            'title' => $alt ? $alt : $productName
        ));

        return $html;
    }
}
