/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Scripts for admin settings page
 *
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
 */

$(document).ready(function() {
    $('div.magicscroll-value ul li:first').prepend(
        "<img id=\"magicscroll_icon\" src=\"skins/admin/modules/MagicToolbox/MagicZoom/magicscroll.png\" />"
    );
    $('input[name=magicscroll]').bind('click', function(event) {
        if (this.checked && this.value == 'Yes') {
            var option = $('select[name=template]');
            if (option.val() == 'original') {
                option.val('bottom');
            }
        }
    });
    $('select[name=template]').bind('change', function(event) {
        if (this.value == 'original') {
            var option = $('input[name=magicscroll]');
            if (option.val() == 'Yes') {
                option.val(['No']);
            }
        }
    });
    $('a.status-switcher').click(function() {
        var statusSwitcher = $(this);
        var li = this.parentNode.parentNode;
        var elements = $(li).find('.table-value input, .table-value select');
        var isRadio = (elements.attr('type') == 'radio');

        if (statusSwitcher.hasClass('on')) {
            if (!isRadio) {
                var initialValue = elements.get(0).initialValue;
                elements.val(initialValue);
            }
            elements.each(function(index) {
                if (isRadio) {
                    $(this).prop('checked', this.initialValue);
                }
                $(this).attr('disabled', 'disabled');
            });
            statusSwitcher.removeClass('on').addClass('off');
        } else if (statusSwitcher.hasClass('off')) {
            elements.each(function(index) {
                $(this).removeAttr('disabled');
            });
            statusSwitcher.removeClass('off').addClass('on');
        }

        if (isRadio) {
            elements = elements.filter('input:checked');
        }

        elements.change();

    });
});

CommonElement.prototype.saveValueOriginal = CommonElement.prototype.saveValue;
CommonElement.prototype.saveValue = function() {
    CommonElement.prototype.saveValueOriginal.apply(this, arguments);
    this.element.initialElementStatus = this.element.getAttribute('disabled') ? 0 : 1;
};

CommonElement.prototype.isChangedOriginal = CommonElement.prototype.isChanged;
CommonElement.prototype.isChanged = function(onlyVisible) {
    var result = false;
    result = CommonElement.prototype.isChangedOriginal.apply(this, arguments);
    if (!result) {
        var elementStatus = this.element.getAttribute('disabled') ? 0 : 1;
        result = (elementStatus != this.element.initialElementStatus);
    }
    return result;
};
