<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicThumb\View\Product\Details\Customer;

/**
 * Mobile Gallery
 *
 * @ListChild (list="product.details.page.image", weight="11")
 *
 */
class GalleryMobile extends \XLite\Module\XC\CrispWhiteSkin\View\Product\Details\Customer\GalleryMobile implements \XLite\Base\IDecorator
{
    /**
     * Gallery images data
     *
     * @var   array
     */
    protected $mobileGalleryImages = null;

    /**
     * Return widget template
     *
     * @return string
     */
    protected function getTemplate()
    {
        $tool = static::getToolObj('MagicThumb');
        if ($tool->params->checkValue('enable-effect', 'No', 'product')) {
            return parent::getTemplate();
        }

        return 'modules/MagicToolbox/MagicThumb/templates/crisp_white/gallery_mobile.twig';
    }

    /**
     * Method to get selector HTML
     *
     * @return string
     */
    public function getMobileGalleryImageHTML($index)
    {
        $image = $this->getGalleryImageHTML($index);
        $image = preg_replace('#data-thumb-id="[^"]*+"#', '', $image);
        $image = preg_replace('#data-options="[^"]*+"#', '', $image);
        $image = preg_replace('#^<a #', '<a onclick="return false;" ', $image);
        return $image;
    }

    /**
     * Check visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        $tool = static::getToolObj('MagicThumb');

        $isVisible = $tool->params->checkValue('enable-effect', 'No', 'product');
        $isVisible = $isVisible || $tool->params->checkValue('template', 'original', 'product');

        return $isVisible && parent::isVisible();
    }
}
