<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicThumb\View\Product\Details\Customer;

/**
 * Gallery
 *
 * @ListChild (list="product.details.page.image", weight="20")
 *
 */
class Gallery extends \XLite\View\Product\Details\Customer\Gallery implements \XLite\Base\IDecorator
{
    /**
     * Gallery images data
     *
     * @var   array
     */
    protected $galleryImages = null;

    /**
     * Return widget template
     *
     * @return string
     */
    protected function getTemplate()
    {
        if (static::QUICKLOOK_PAGE === $this->viewListName || 'product.details.quicklook' === $this->viewListName) {
            return parent::getTemplate();
        }

        $tool = static::getToolObj('MagicThumb');
        if ($tool->params->checkValue('enable-effect', 'No', 'product')) {
            return parent::getTemplate();
        }

        if ($this instanceof \XLite\Module\XC\CrispWhiteSkin\View\Product\Details\Customer\Gallery) {
            return 'modules/MagicToolbox/MagicThumb/templates/crisp_white/gallery.twig';
        }

        return 'modules/MagicToolbox/MagicThumb/templates/gallery.twig';
    }

    /**
     * Method to get selector HTML
     *
     * @return string
     */
    public function getGalleryImageHTML($index)
    {
        if ($this->galleryImages === null) {
            $this->galleryImages = array();
            $tool = static::getToolObj('MagicThumb');
            $thumbMaxWidth = intval($tool->params->getValue('thumb-max-width', 'product'));
            $thumbMaxHeight = intval($tool->params->getValue('thumb-max-height', 'product'));
            $selectorMaxWidth = intval($tool->params->getValue('selector-max-width', 'product'));
            $selectorMaxHeight = intval($tool->params->getValue('selector-max-height', 'product'));
            $useAlt = $tool->params->checkValue('use-individual-titles', 'Yes', 'product');
            $product = $this->getProduct();
            $productId = $product->getId();
            $productName = $product->getName();
            $images = $product->getPublicImages();
            foreach ($images as $i => $image) {
                $img = $image->getURL();
                list($width, $height, $thumb) = $image->doResize($thumbMaxWidth, $thumbMaxHeight, false);
                list($width, $height, $selector) = $image->doResize($selectorMaxWidth, $selectorMaxHeight, false);
                $alt = $useAlt ? $image->getAlt() : '';
                $this->galleryImages[$i] = $tool->getSelectorTemplate(array(
                    'id' => 'Product'.$productId,
                    'group' => 'productPage',
                    'img' => $img,
                    'medium' => $thumb,
                    'thumb' => $selector,
                    'title' => $alt ? $alt : $productName
                ));
            }
        }
        return isset($this->galleryImages[$index]) ? $this->galleryImages[$index] : '';
    }

    /**
     * Method to get ID
     *
     * @return integer|string
     */
    public function getPid()
    {
        return $this->getProduct()->getId();
    }

    /**
     * Checks if slider mode is required for the gallery
     *
     * @return boolean
     */
    protected function useSlider()
    {
        $useSlider = false;
        $version = \XLite::getInstance()->getVersion();
        if (version_compare($version, '5.3.3.4', '>=')) {
            $useSlider = true;
        } elseif (method_exists($this, 'isInSliderMode')) {
            $useSlider = parent::isInSliderMode();
        }
        return $useSlider;
    }

    /**
     * Check visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        if (static::QUICKLOOK_PAGE === $this->viewListName || 'product.details.quicklook' === $this->viewListName) {
            return parent::isVisible();
        }

        $tool = static::getToolObj('MagicThumb');

        $isVisible = $tool->params->checkValue('enable-effect', 'No', 'product');
        $isVisible = $isVisible || $tool->params->checkValue('template', 'original', 'product');

        return $isVisible && parent::isVisible();
    }
}
