<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicThumb\View;

/**
 * Decorate AView to add js/css files
 *
 */
abstract class AView extends \XLite\View\AView implements \XLite\Base\IDecorator
{
    /**
     * Tool core class
     *
     * @var null|false|object
     *
     */
    protected static $magicthumb = null;

    /**
     * MagicThumb enable flag
     *
     * @var bool
     *
     */
    protected static $isMagicthumbEnabled = null;

    /**
     * Product's spin data
     *
     * @var array
     *
     */
    protected static $productSpinData = array();

    /**
     * Method to get tool core class
     *
     * @param string $toolId Tool id
     *
     * @return false|object
     */
    public static function getToolObj($toolId)
    {
        $property = strtolower($toolId);
        if (!isset(static::$$property)) {
            if (!property_exists(get_called_class(), $property)) {
                return false;
            }

            static::$$property = false;
            $class = "\\XLite\\Module\\MagicToolbox\\{$toolId}\\Classes\\Helper";
            if (class_exists($class)) {
                static::$$property = $class::getInstance()->getPrimaryTool();
            }
        }

        return static::$$property;
    }

    /**
     * Method to check if tool is enabled
     *
     * @param string $toolId Tool id
     *
     * @return boolean
     */
    public static function isToolEnabled($toolId)
    {
        $property = 'is' . ucfirst(strtolower($toolId)) . 'Enabled';
        if (!isset(static::$$property)) {
            if (\XLite::isAdminZone()) {
                static::$$property = false;
                return static::$$property;
            }
            $tool = static::getToolObj($toolId);
            $page = static::getCurrentPageType();
            static::$$property = $tool && $tool->params->profileExists($page) && $tool->params->checkValue('enable-effect', 'Yes', $page);
        }

        return static::$$property;
    }

    /**
     * Method to check if headers should be included
     *
     * @param string $toolId Tool id
     *
     * @return boolean
     */
    public static function shouldIncludeHeaders($toolId)
    {
        $tool = static::getToolObj($toolId);
        return $tool && ($tool->params->checkValue('include-headers-on-all-pages', 'Yes') || static::isToolEnabled($toolId));
    }

    /**
     * Get JS files list
     *
     * @return array
     */
    public function getJSFiles()
    {
        static $list = null;

        if ($list === null) {
            $list = array();
            if (!\XLite::isAdminZone() && static::shouldIncludeHeaders('MagicThumb')) {
                $list[] = 'modules/MagicToolbox/MagicThumb/js/magicthumb.js';
                //NOTE: if MagicScroll module headers displayed (to not display twice)
                if (!static::shouldIncludeHeaders('MagicScroll')) {
                    if (\XLite\Module\MagicToolbox\MagicThumb\Classes\Helper::getInstance()->getScrollTool()) {
                        $list[] = 'modules/MagicToolbox/MagicThumb/js/magicscroll.js';
                    }
                }
            }
        }

        return array_merge(
            parent::getJSFiles(),
            $list
        );
    }

    /**
     * Get CSS files list
     *
     * @return array
     */
    public function getCSSFiles()
    {
        static $list = null;

        if ($list === null) {
            $list = array();
            if (!\XLite::isAdminZone() && static::shouldIncludeHeaders('MagicThumb')) {
                $list[] = 'modules/MagicToolbox/MagicThumb/css/magicthumb.css';
                //NOTE: if MagicScroll module headers displayed (to not display twice)
                if (!static::shouldIncludeHeaders('MagicScroll')) {
                    if (\XLite\Module\MagicToolbox\MagicThumb\Classes\Helper::getInstance()->getScrollTool()) {
                        $list[] = 'modules/MagicToolbox/MagicThumb/css/magicscroll.css';
                    }
                }

                $list[] = 'modules/MagicToolbox/MagicThumb/css/magicthumb.module.css';
            }
        }

        return array_merge(
            parent::getCSSFiles(),
            $list
        );
    }

    /**
     * Method to get current page
     *
     * @return string
     */
    public static function getCurrentPageType()
    {
        static $page = null;

        if ($page === null) {
            $controller = \XLite::getController();
            if ($controller instanceof \XLite\Controller\Customer\Main) {
                $page = 'homepage';
            } elseif ($controller instanceof \XLite\Controller\Customer\Category) {
                $page = 'category';
            } elseif ($controller instanceof \XLite\Controller\Customer\Product) {
                $page = 'product';
            } else {
                $page = '';
            }
        }

        return $page;
    }
}
