<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicThumb\Model;

/**
 * MagicThumb configuration registry
 *
 * @Entity (repositoryClass="\XLite\Module\MagicToolbox\MagicThumb\Model\Repo\Config")
 * @Table  (name="magicthumb_config",
 *      uniqueConstraints={
 *          @UniqueConstraint (name="pn", columns={"profile", "name"})
 *      },
 *      indexes={
 *          @Index (name="profile", columns={"profile"}),
 *          @Index (name="name", columns={"name"}),
 *          @Index (name="orderby", columns={"orderby"})
 *      }
 * )
 */
class Config extends \XLite\Model\Base\I18n
{
    /**
     * Option's statuses
     */
    const OPTION_IS_INACTIVE      = 0;
    const OPTION_IS_ACTIVE        = 1;
    const OPTION_IS_ALWAYS_ACTIVE = 2;

    /**
     * Option unique id
     *
     * @var string
     *
     * @Id
     * @GeneratedValue (strategy="AUTO")
     * @Column (type="integer")
     */
    protected $config_id;

    /**
     * Option profile
     *
     * @var string
     *
     * @Column (type="string", length=64)
     */
    protected $profile;

    /**
     * Option name
     *
     * @var string
     *
     * @Column (type="string", length=64)
     */
    protected $name;

    /**
     * Option type
     *
     * @var string
     *
     * @Column (type="string", length=128)
     */
    protected $type = '';

    /**
     * Option position within profile
     *
     * @var integer
     *
     * @Column (type="integer")
     */
    protected $orderby = 0;

    /**
     * Option value
     *
     * @var string
     *
     * @Column (type="text")
     */
    protected $value = '';

    /**
     * Option default value
     *
     * @var string
     *
     * @Column (type="text")
     */
    protected $default_value = '';

    /**
     * Option's status
     *
     * @var smallint
     *
     * @Column (type="smallint")
     */
    protected $status = self::OPTION_IS_ALWAYS_ACTIVE;

    /**
     * Widget parameters
     *
     * @var array
     *
     * @Column (type="array", nullable=true)
     */
    protected $widgetParameters;

    /**
     * Get option unique id
     *
     * @return integer
     */
    public function getConfigId()
    {
        return $this->config_id;
    }

    /**
     * Set profile
     *
     * @param string $profile
     * @return Config
     */
    public function setProfile($profile)
    {
        $this->profile = $profile;
        return $this;
    }

    /**
     * Get profile
     *
     * @return string
     */
    public function getProfile()
    {
        return $this->profile;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Config
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return Config
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set orderby
     *
     * @param integer $orderby
     * @return Config
     */
    public function setOrderby($orderby)
    {
        $this->orderby = $orderby;
        return $this;
    }

    /**
     * Get orderby
     *
     * @return integer
     */
    public function getOrderby()
    {
        return $this->orderby;
    }

    /**
     * Set value
     *
     * @param text $value
     * @return Config
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * Get value
     *
     * @return text
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set default value
     *
     * @param text $defaultValue
     * @return Config
     */
    public function setDefaultValue($defaultValue)
    {
        $this->default_value = $defaultValue;
        return $this;
    }

    /**
     * Get default value
     *
     * @return text
     */
    public function getDefaultValue()
    {
        return $this->default_value;
    }

    /**
     * Set status
     *
     * @param text $status
     * @return Config
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * Get status
     *
     * @return tinyint
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set widget parameters
     *
     * @param array $widgetParameters
     * @return Config
     */
    public function setWidgetParameters($widgetParameters)
    {
        $this->widgetParameters = $widgetParameters;
        return $this;
    }

    /**
     * Get widget parameters
     *
     * @return array
     */
    public function getWidgetParameters()
    {
        return $this->widgetParameters;
    }

    /**
     * Translations (relation). AUTOGENERATED
     *
     * @var \Doctrine\Common\Collections\ArrayCollection
     *
     * @OneToMany (targetEntity="XLite\Module\MagicToolbox\MagicThumb\Model\ConfigTranslation", mappedBy="owner", cascade={"all"})
     */
    protected $translations;

    /**
     * Translation getter. AUTOGENERATED
     *
     * @return string
     */
    public function getOptionName()
    {
        return $this->getSoftTranslation()->getOptionName();
    }

    /**
     * Translation setter. AUTOGENERATED
     *
     * @param string $value value to set
     *
     * @return void
     */
    public function setOptionName($value)
    {
        $translation = $this->getTranslation();

        if (!$this->hasTranslation($translation->getCode())) {
            $this->addTranslations($translation);
        }

        return $translation->setOptionName($value);
    }

    /**
     * Translation getter. AUTOGENERATED
     *
     * @return string
     */
    public function getOptionComment()
    {
        return $this->getSoftTranslation()->getOptionComment();
    }

    /**
     * Translation setter. AUTOGENERATED
     *
     * @param string $value value to set
     *
     * @return void
     */
    public function setOptionComment($value)
    {
        $translation = $this->getTranslation();

        if (!$this->hasTranslation($translation->getCode())) {
            $this->addTranslations($translation);
        }

        return $translation->setOptionComment($value);
    }
}
