<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicThumb\Classes;

/**
 * Helper class
 *
 */
class Helper extends \XLite\Base\Singleton
{
    /**
     * MagicThumb module core class
     *
     * @var \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass
     *
     */
    protected $primaryTool = null;

    /**
     * MagicScroll module core class
     *
     * @var \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass
     *
     */
    protected $scrollTool = null;

    /**
     * Protected constructor.
     * Load and set up MagicThumb module core class
     *
     * @return void
     */
    protected function __construct()
    {
        $this->primaryTool = new \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass();

        $repo = \XLite\Core\Database::getRepo('XLite\Module\MagicToolbox\MagicThumb\Model\Config');
        if (!($repo && $repo->count())) {
            $this->doLoadDefaults();
        }

        $config = $repo->getEditableAndActiveOptions();
        foreach ($config as $profile => $options) {
            foreach ($options as $id => $value) {
                $this->primaryTool->params->setValue($id, $value, $profile);
            }
        }

        if ($this->primaryTool->params->checkValue('magicscroll', 'Yes', 'product')) {
            $this->scrollTool = new \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass(false);
            //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
            $this->scrollTool->params->appendParams($this->primaryTool->params->getParams('product'), 'product-magicscroll-options');
            $this->scrollTool->params->setValue(
                'orientation',
                ($this->primaryTool->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'),
                'product-magicscroll-options'
            );
        }
    }

    /**
     * Load defaults
     *
     * @return void
     */
    protected function doLoadDefaults()
    {
        $yaml = \Includes\Utils\ModulesManager::getModuleYAMLFiles('MagicToolbox', 'MagicThumb');
        $yaml = $yaml[0];
        if (\Includes\Utils\FileManager::isFileReadable($yaml)) {
            \XLite\Core\Database::getRepo('\XLite\Module\MagicToolbox\MagicThumb\Model\Config')->clearAll();
            \XLite\Core\Database::getInstance()->loadFixturesFromYaml($yaml);
        }
    }

    /**
     * Method to get MagicThumb module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass
     */
    public function getPrimaryTool()
    {
        return $this->primaryTool;
    }

    /**
     * Method to get MagicScroll module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass
     */
    public function getScrollTool()
    {
        return $this->scrollTool;
    }
}
