<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\View\Product\Details\Customer\Page;

/**
 * Main
 *
 * @Decorator\After({"MagicToolbox\MagicThumb","MagicToolbox\MagicZoom","MagicToolbox\MagicZoomPlus"})
 * @ListChild (list="center", zone="customer")
 */
class Main extends \XLite\View\Product\Details\Customer\Page\Main implements \XLite\Base\IDecorator
{
    /**
     * Check - loupe icon is visible or not
     *
     * @return boolean
     */
    protected function isLoupeVisible()
    {
        $tool = static::getToolObj('MagicSlideshow');
        if ($tool->params->checkValue('enable-effect', 'No', 'product')) {
            return parent::isLoupeVisible();
        }
        return false;
    }

    /**
     * Define CSS class for MagicSlideshow module
     *
     * @return string
     */
    protected function getMagicToolboxClass()
    {
        $class = 'magicslideshow-image-block';
        $tool = static::getToolObj('MagicSlideshow');
        if ($tool->params->checkValue('enable-effect', 'Yes', 'product')) {
            return $class;
        }
        if (method_exists(get_parent_class(), 'getMagicToolboxClass')) {
            return parent::getMagicToolboxClass();
        }
        return '';
    }
}
