<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\View\Product\Details\Customer;

/**
 * MagicSlideshow
 *
 */
class MagicSlideshow extends \XLite\View\Product\Details\Customer\ACustomer
{
    /**
     * Product unique ID
     *
     * @var   integer
     *
     */
    protected $currentProductId = null;

    /**
     * Rendered HTML
     *
     * @var   string
     */
    protected $renderedHTML = '';

    /**
     * Additional classes
     *
     * @var   string
     *
     */
    protected $additionalClasses = '';

    /**
     * Scroll options
     *
     * @var   string
     *
     */
    protected $scrollOptions = '';

    /**
     * Get JS files list
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        $tool = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance()->getPrimaryTool();
        if ($tool->params->checkValue('enable-effect', 'Yes', 'product')) {
            $list[] = 'modules/MagicToolbox/MagicSlideshow/js/controller.js';
        }

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/MagicToolbox/MagicSlideshow/templates/magicslideshow.twig';
    }

    /**
     * Check visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible();
    }

    /**
     * Method to get rendered HTML
     *
     * @return string
     */
    public function getHTML()
    {
        return $this->renderedHTML;
    }

    /**
     * Method to get ID
     *
     * @return integer|string
     */
    public function getPid()
    {
        return ($this->currentProductId !== null) ? $this->currentProductId : '';
    }

    /**
     * Method to get additional classes
     *
     * @return string
     */
    public function getAdditionalClasses()
    {
        return $this->additionalClasses;
    }

    /**
     * Method to get scroll options
     *
     * @return string
     */
    public function getScrollOptions()
    {
        return $this->scrollOptions;
    }

    /**
     * Method to get option value
     *
     * @param string $option Option name
     *
     * @return mixed
     */
    public function getOptionValue($option)
    {
        $tool = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance()->getPrimaryTool();
        $tool->params->setProfile('product');
        return $tool->params->getValue($option);
    }

    /**
     * Method to render MagicSlideshow HTML
     *
     * @return boolean
     */
    public function renderTemplate()
    {
        $helper = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance();
        $tool = $helper->getPrimaryTool();
        $tool->params->setProfile('product');
        if ($tool->params->checkValue('enable-effect', 'No')) {
            return false;
        }

        $thumbMaxWidth = intval($tool->params->getValue('thumb-max-width', 'product'));
        $thumbMaxHeight = intval($tool->params->getValue('thumb-max-height', 'product'));
        $selectorMaxWidth = intval($tool->params->getValue('selector-max-width', 'product'));
        $selectorMaxHeight = intval($tool->params->getValue('selector-max-height', 'product'));
        $useAlt = $tool->params->checkValue('use-individual-titles', 'Yes', 'product');

        $product = $this->getProduct();
        $this->currentProductId = $product->getId();
        $productName = $product->getName();
        $briefDescription = $product->getBriefDescription();
        $fullDescription = $product->getDescription();
        $images = $product->getPublicImages();
        $imagesCount = count($images);
        if (!$imagesCount) {
            return false;
        }

        $toolData = array();

        foreach ($images as $index => $image) {

            $img = $image->getURL();
            list($width, $height, $thumb) = $image->doResize($thumbMaxWidth, $thumbMaxHeight, false);
            list($width, $height, $selector) = $image->doResize($selectorMaxWidth, $selectorMaxHeight, false);
            $alt = $useAlt ? $image->getAlt() : '';

            $toolData[] = array(
                'title' => $alt ? $alt : $productName,
                'img' => $thumb,
                'thumb' => $selector,
                'fullscreen' => $img,
            );

        }

        $this->renderedHTML = $tool->getMainTemplate($toolData, array('id' => 'productMagicSlideshow'));

        return true;
    }

    /**
     * Method to get default image URL
     *
     * @return string
     */
    public function getDefaultImageURL()
    {
        $url = null;

        $url = \XLite::getInstance()->getOptions(['images', 'default_image']);

        if (!\XLite\Core\Converter::isURL($url)) {
            $url = \XLite\Core\Layout::getInstance()->getResourceWebPath(
                $url,
                \XLite\Core\Layout::WEB_PATH_OUTPUT_URL
            );
        }

        $url = str_replace(array('http://', 'https://'), '//', $url);

        return $url;
    }

    /**
     * Method to get default image HTML
     *
     * @return string
     */
    public function getDefaultImageHTML()
    {
        $product = $this->getProduct();
        $id = $product->getId();
        $productName = $product->getName();
        $img = $this->getDefaultImageURL();
        $tool = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance()->getPrimaryTool();
        $data[] = array(
            'title' => $productName,
            'img' => $img,
            'thumb' => $img,
            'fullscreen' => $img,
        );
        $html = $tool->getMainTemplate($data, array('id' => 'productMagicSlideshow'));
        return $html;
    }
}
