<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\View;

/**
 * Homepage MagicSlideshow widget
 *
 * @ListChild (list="layout.main", zone="customer", weight="300")
 * @ListChild (list="center", zone="customer", weight="0")
 */
class Homepage extends \XLite\View\AView
{
    /**
     * Return list of targets allowed for this widget
     *
     * @return array
     */
    public static function getAllowedTargets()
    {
        $result = parent::getAllowedTargets();
        $result[] = 'main';
        return $result;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/MagicToolbox/MagicSlideshow/templates/homepage.twig';
    }

    /**
     * Check widget visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        static $listName = null;
        if ($listName === null) {
            $listName = 'center.';
            $tool = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance()->getPrimaryTool();
            if ($tool->params->checkValue('homepage-slideshow-position', 'under the header area', 'homepage')) {
                $listName = 'layout.main.';
            }
        }
        return (strpos($this->getNestedListName(''), $listName) === 0) && parent::isVisible();
    }

    /**
     * Method to get rendered HTML
     *
     * @return string
     */
    protected function getHTML()
    {
        static $html = null;
        if ($html === null) {
            $html = '';
            $tool = \XLite\Module\MagicToolbox\MagicSlideshow\Classes\Helper::getInstance()->getPrimaryTool();
            if (!$tool->params->checkValue('enable-effect', 'Yes', 'homepage')) {
                return '';
            }
            $tool->params->setProfile('homepage');

            $imagesData = \XLite\Core\Database::getRepo('XLite\Module\MagicToolbox\MagicSlideshow\Model\Image')->findBy(array(), array('orderby' => 'asc'));

            if (empty($imagesData)) {
                return '';
            }

            $slideshowData = array();
            foreach ($imagesData as $image) {
                $img = $image->getURL();
                list($width, $height, $thumb) = $image->doResize(intval($tool->params->getValue('thumb-max-width')), intval($tool->params->getValue('thumb-max-height')), false);
                list($width, $height, $selector) = $image->doResize(intval($tool->params->getValue('selector-max-width')), intval($tool->params->getValue('selector-max-height')), false);
                $slideshowData[] = array(
                    'title' => $image->getterProperty('alt'),
                    'alt' => $image->getterProperty('alt'),
                    'description' => $image->getterProperty('description'),
                    'link' => $image->getterProperty('linked_url'),
                    'img' => $thumb,
                    'thumb' => $selector,
                    'fullscreen' => $img,
                );
            }

            $html = $tool->getMainTemplate($slideshowData, array('id' => 'homepageMagicSlideshow'));

        }
        return $html;
    }
}
