<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\View\FormField;

/**
 * Form selector
 */
class MagicToolboxSelect extends \XLite\View\FormField\Select\ASelect
{
    /**
     * Widget param names
     */
    const PARAM_STATUS = 'paramStatus';

    /**
     * Option's statuses
     */
    const OPTION_IS_INACTIVE      = \XLite\Module\MagicToolbox\MagicSlideshow\Model\Config::OPTION_IS_INACTIVE;
    const OPTION_IS_ACTIVE        = \XLite\Module\MagicToolbox\MagicSlideshow\Model\Config::OPTION_IS_ACTIVE;
    const OPTION_IS_ALWAYS_ACTIVE = \XLite\Module\MagicToolbox\MagicSlideshow\Model\Config::OPTION_IS_ALWAYS_ACTIVE;

    /**
     * MagicSlideshow module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicSlideshow\Classes\MagicSlideshowModuleCoreClass
     *
     */
    static protected $toolCoreClass = null;

    /**
     * Define widget params
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();
        $this->widgetParams += array(
            static::PARAM_STATUS => new \XLite\Model\WidgetParam\TypeInt('Param\'s status', $this->getDefaultStatus()),
        );
    }

    /**
     * Get default status
     *
     * @return string
     */
    protected function getDefaultStatus()
    {
        return static::OPTION_IS_ALWAYS_ACTIVE;
    }

    /**
     * Get common attributes
     *
     * @return array
     */
    protected function getCommonAttributes()
    {
        $list = parent::getCommonAttributes();
        if ($this->isOptionInactive()) {
            $list['disabled'] = 'disabled';
        }
        $list['data-default-status'] = $this->getDefaultStatus();
        return $list;
    }

    /**
     * Check - specidifed option is inactive or not
     *
     * @return boolean
     */
    protected function isOptionInactive()
    {
        return ($this->getParam(static::PARAM_STATUS) === static::OPTION_IS_INACTIVE);
    }

    /**
     * Check if status switcher is visible
     *
     * @return boolean
     */
    protected function isStatusSwitcherVisible()
    {
        return in_array($this->getParam(static::PARAM_STATUS), array(static::OPTION_IS_INACTIVE, static::OPTION_IS_ACTIVE));
    }

    /**
     * Get status switcher tag attributes
     *
     * @return array
     */
    protected function getStatusSwitcherTagAttributes()
    {
        return array(
            'class' => array(
                'status-switcher',
                ($this->getParam(static::PARAM_STATUS) ? 'on' : 'off'),
            ),
            'onclick' => array(
                'return false;',
            ),
            'title' => array(
                'switching between this option and the appropriate option from the \'Defaults\' tab',
            ),
        );
    }

    /**
     * Get options list
     *
     * @return array
     */
    protected function getOptions()
    {
        if (null === self::$toolCoreClass) {
            self::$toolCoreClass = new \XLite\Module\MagicToolbox\MagicSlideshow\Classes\MagicSlideshowModuleCoreClass();
        }
        $options = array();
        foreach (self::$toolCoreClass->params->getValues($this->getName()) as $value) {
            $options[$value] = $value;
        }
        return $options;
    }

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return array();
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return './modules/MagicToolbox/MagicSlideshow/form_field.twig';
    }
}
