<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\View\FormField;

/**
 * Image file uploader
 */
class MagicToolboxImageUploader extends \XLite\View\FormField\FileUploader\Image
{
    /**
     * Define widget params
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();
        $this->widgetParams[static::PARAM_MULTIPLE] = new \XLite\Model\WidgetParam\TypeBool('Multiple', true);
    }

    /**
     * Return 'isImage' flag
     *
     * @return boolean
     */
    protected function isImage()
    {
        return true;
    }

    /**
     * Registers the JS files
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $key = array_search('form_field/file_uploader/multiple.js', $list);
        if ($key !== false) {
            unset($list[$key]);
        }
        return $list;
    }

    /**
     * Method to get common attributes
     *
     * @return array
     */
    protected function getCommonAttributes()
    {
        $list = parent::getCommonAttributes();
        $list['is_image'] = true;
        return $list;
    }

    /**
     * Return field template
     *
     * @return string
     */
    protected function getFieldTemplate()
    {
        return '../modules/MagicToolbox/MagicSlideshow/multiple.twig';
    }

    /**
     * Return HTML representation for widget attributes
     *
     * @return string
     */
    protected function getMtAttributesCode()
    {
        if (method_exists($this, 'getDataCode')) {
            return parent::getDataCode();
        }

        return parent::getAttributesCode();
    }
}
