<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow\Model;

/**
 * MagicSlideshow image
 *
 * @Entity (repositoryClass="\XLite\Module\MagicToolbox\MagicSlideshow\Model\Repo\Image")
 * @Table  (name="magicslideshow_images")
 */
class Image extends \XLite\Model\Base\Image
{

    /**
     * Image position
     *
     * @var integer
     *
     * @Column (type="integer")
     */
    protected $orderby = 0;

    /**
     * Alternative image text (title)
     *
     * @var string
     *
     * @Column (type="string", length=255)
     */
    protected $alt = '';

    /**
     * Linked URL
     *
     * @var string
     *
     * @Column (type="string", length=255)
     */
    protected $linked_url = '';

    /**
     * Image description
     *
     * @var string
     *
     * @Column (type="text")
     */
    protected $description = '';

    /**
     * Set orderby
     *
     * @param integer $orderby
     * @return Image
     */
    public function setOrderby($orderby)
    {
        $this->orderby = $orderby;
        return $this;
    }

    /**
     * Get orderby
     *
     * @return integer
     */
    public function getOrderby()
    {
        return $this->orderby;
    }

    /**
     * Set alt
     *
     * @param string $alt
     * @return Image
     */
    public function setAlt($alt)
    {
        $this->alt = $alt;
        return $this;
    }

    /**
     * Get alt
     *
     * @return string
     */
    public function getAlt()
    {
        return $this->alt;
    }

    /**
     * Set linked URL
     *
     * @param string $url
     * @return Image
     */
    public function setLinkedUrl($url)
    {
        $this->linked_url = $url;
        return $this;
    }

    /**
     * Get linked URL
     *
     * @return string
     */
    public function getLinkedUrl()
    {
        return $this->linked_url;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return Image
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
}
