<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicSlideshow;

/**
 * MagicSlideshow module main class
 *
 */
abstract class Main extends \XLite\Module\AModule
{

    /**
     * Return module name
     *
     * @return string
     */
    public static function getModuleName()
    {
        return 'Magic Slideshow';
    }

    /**
     * Return author name
     *
     * @return string
     */
    public static function getAuthorName()
    {
        return 'Magic Toolbox';
    }

    /**
     * Return module description
     *
     * @return string
     */
    public static function getDescription()
    {
        return "Display one image after another. Fade or slide, fast or slow, text or just images. It's your choice!";
    }

    /**
     * Get module major version
     *
     * @return string
     */
    public static function getMajorVersion()
    {
        return '5.4';
    }

    /**
     * Get module minor version
     *
     * @return string
     */
    public static function getMinorVersion()
    {
        return '0';
    }

    /**
     * Return link to the module author page
     *
     * @return string
     */
    public static function getAuthorPageURL()
    {
        return 'http://www.magictoolbox.com/';
    }

    /**
     * Determines if we need to show settings form link
     *
     * @return boolean
     */
    public static function showSettingsForm()
    {
        return true;
    }

    /**
     * Return link to settings form
     *
     * @return string
     */
    public static function getSettingsForm()
    {
        return \XLite\Core\Converter::buildURL('magicslideshow_settings', '', array('section' => 'default'));
    }

    /**
     * Build cache handler
     *
     * @return void
     */
    public static function runBuildCacheHandler()
    {
        parent::runBuildCacheHandler();
        static::fixViewList();
    }

    /**
     * Update view list entries
     *
     * @return void
     */
    public static function updateViewListEntries()
    {
        parent::updateViewListEntries();
        static::fixViewList();
    }

    /**
     * Return list of mutually exclusive modules
     *
     * @return array
     */
    public static function getMutualModulesList()
    {
        $list = parent::getMutualModulesList();
        $list[] = 'CDev\DrupalConnector';
        return $list;
    }

    /**
     * Fix view list
     *
     * @return void
     */
    protected static function fixViewList()
    {
        $layout = \XLite\Core\Layout::getInstance();

        //NOTE: remove original 'page.image.twig' template from a view list
        $layout->removeTemplateFromList(
            'product/details/parts/page.image.twig',
            'product.details.page',
            \XLite\Model\ViewList::INTERFACE_CUSTOMER
        );
        $layout->removeTemplateFromList(
            'modules/MagicToolbox/MagicThumb/templates/page.image.twig',
            'product.details.page',
            \XLite\Model\ViewList::INTERFACE_CUSTOMER
        );
        $layout->removeTemplateFromList(
            'modules/MagicToolbox/MagicZoom/templates/page.image.twig',
            'product.details.page',
            \XLite\Model\ViewList::INTERFACE_CUSTOMER
        );
        $layout->removeTemplateFromList(
            'modules/MagicToolbox/MagicZoomPlus/templates/page.image.twig',
            'product.details.page',
            \XLite\Model\ViewList::INTERFACE_CUSTOMER
        );
    }
}
