/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Product details controller
 *
 */

if ('undefined' != typeof(ProductDetailsView)) {

  //NOTE: fixed JS error due to unconnected colorbox plugin (because of replaced gallery)
  if ('undefined' != typeof($) && 'undefined' == typeof($.colorbox)) {
    $.colorbox = {};
    $.colorbox.remove = function (){};
  }

  ProductDetailsView.prototype.mtPreviousData = '';

  ProductDetailsView.prototype.mtProductId = null;

  ProductDetailsView.prototype.mtMainNodeId = null;

  ProductDetailsView.prototype.mtMainNode = null;

  ProductDetailsView.prototype.mtDefaultHtml = null;

  ProductDetailsView.prototype.mtNeedStart = false;

  ProductDetailsView.prototype.addProductToCartOriginal = ProductDetailsView.prototype.addProductToCart;
  ProductDetailsView.prototype.addProductToCart = function(event)
  {
    this.mtToolStop();
    this.mtNeedStart = true;
    this.addProductToCartOriginal.apply(this, arguments);
  };

  ProductDetailsView.prototype.postprocessOriginal = ProductDetailsView.prototype.postprocess;
  ProductDetailsView.prototype.postprocess = function(isSuccess, initial)
  {
    this.postprocessOriginal.apply(this, arguments);

    if (!this.mtNeedStart) {
      return;
    }

    this.mtToolStart();

    //NOTE: reset the data so that they update after adding the product to the shopping cart
    this.mtPreviousData = '';

    this.mtNeedStart = false;
  }

  ProductDetailsView.prototype.getURLParametersForLoadVariantsImages = function(productId)
  {
    var params = {product_id: productId};
    params = array_merge(params, core.getWidgetsParams('update-product-page', params));
    return array_merge({'target': 'product', 'action': 'get_magicscroll_data'}, params);
  }

  ProductDetailsView.prototype.handleLoadVariantsImages = function (XMLHttpRequest, textStatus, data)
  {
    var mtData = data;

    if (this.mtPreviousData != data) {

      if (data && _.isString(data)) {
        data = $.parseJSON(data);
      }

      var input = $('input[name="product_id"]');
      if (input.length > 0) {
        this.mtProductId = input.val();
      }

      this.mtMainNodeId = 'productMagicScroll';
      this.mtMainNode = document.getElementById(this.mtMainNodeId);

      if (typeof(MagicScroll) != 'undefined' && this.mtMainNode) {
        var newHtml = (data && _.isObject(data) ? data.magicscroll.html : null);

        MagicScroll.stop(this.mtMainNodeId);

        if (this.mtDefaultHtml == null) {
          this.mtDefaultHtml = this.base.find('#' + this.mtMainNodeId).parent().html();
        }

        this.base.find('.MagicToolboxMessage').first().remove();
        if (newHtml) {
          this.base.find('#' + this.mtMainNodeId).replaceWith(newHtml);
        } else {
          this.base.find('#' + this.mtMainNodeId).replaceWith(this.mtDefaultHtml);
        }

        MagicScroll.start(this.mtMainNodeId);
      }

    }

    if (this.loadVariantsImagesShade) {
      this.base.find('.product-details-info .single-progress-mark').remove();
    }

    this.mtPreviousData = mtData;
  }
}
