<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicScroll\View;

/**
 * JS options
 *
 * @ListChild (list="jscontainer.js", zone="customer", weight="999999")
 *
 */
class JSOptions extends \XLite\View\AView
{
    /**
     * Method to get MagicScroll options
     *
     * @return string
     */
    public function getHTML()
    {
        $helper = \XLite\Module\MagicToolbox\MagicScroll\Classes\Helper::getInstance();
        $tool = $helper->getPrimaryTool();
        $tool->params->resetProfile();
        $html = $tool->getOptionsTemplate();

        return $html;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/MagicToolbox/MagicScroll/templates/js_options.twig';
    }

    /**
     * Check visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        $tool = \XLite\Module\MagicToolbox\MagicScroll\Classes\Helper::getInstance()->getPrimaryTool();
        $page = static::getCurrentPageType();
        $enabled = $tool->params->checkValue('include-headers-on-all-pages', 'Yes') ||
                   $tool->params->profileExists($page) && $tool->params->checkValue('enable-effect', 'Yes', $page);
        return parent::isVisible() && $enabled;
    }
}
