<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\MagicScroll\Controller\Admin;

/**
 * File upload controller
 */
class MagicscrollFiles extends \XLite\Controller\Admin\Files
{
    /**
     * Return content
     *
     * @param mixed  $file    File
     * @param string $message Message OPTIONAL
     *
     * @return void
     */
    protected function getContent($file, $message = '')
    {
        $headers = $this->getAdditionalHeaders();
        if ($message) {
            $headers['X-Upload-Error'] = $message;
        }
        static::sendHeaders($headers);

        $viewer = new \XLite\Module\MagicToolbox\MagicScroll\View\FileUploader(
            array(
                \XLite\View\FileUploader::PARAM_NAME         => \XLite\Core\Request::getInstance()->name,
                \XLite\View\FileUploader::PARAM_MULTIPLE     => \XLite\Core\Request::getInstance()->multiple,
                \XLite\View\FileUploader::PARAM_OBJECT       => $file,
                \XLite\View\FileUploader::PARAM_OBJECT_ID    => \XLite\Core\Request::getInstance()->object_id,
                \XLite\View\FileUploader::PARAM_MESSAGE      => $message,
                \XLite\View\FileUploader::PARAM_IS_TEMPORARY => true,
                \XLite\View\FileUploader::PARAM_MAX_WIDTH    => \XLite\Core\Request::getInstance()->max_width,
                \XLite\View\FileUploader::PARAM_MAX_HEIGHT   => \XLite\Core\Request::getInstance()->max_height,
                \XLite\View\FileUploader::PARAM_IS_IMAGE     => $file instanceof \XLite\Model\TemporaryFile
                    ? \XLite\Core\Request::getInstance()->is_image
                    : null,
            )
        );

        $this->printAJAXOutput($viewer);
        exit(0);
    }
}
