<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\View\Product\Details\Customer;

/**
 * Magic360
 *
 */
class Magic360 extends \XLite\View\Product\Details\Customer\ACustomer
{
    /**
     * Product unique ID
     *
     * @var   integer
     *
     */
    protected $currentProductId = null;

    /**
     * Rendered HTML
     *
     * @var   string
     */
    protected $renderedHTML = '';

    /**
     * Additional classes
     *
     * @var   string
     *
     */
    protected $additionalClasses = '';

    /**
     * Scroll options
     *
     * @var   string
     *
     */
    protected $scrollOptions = '';

    /**
     * Get JS files list
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        $tool = \XLite\Module\MagicToolbox\Magic360\Classes\Helper::getInstance()->getPrimaryTool();
        if ($tool->params->checkValue('enable-effect', 'Yes', 'product')) {
            if (static::hasProductSpin($this->getProduct())) {
                $list[] = 'modules/MagicToolbox/Magic360/js/controller.js';
            }
        }

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/MagicToolbox/Magic360/templates/magic360.twig';
    }

    /**
     * Check visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible();
    }

    /**
     * Method to get rendered HTML
     *
     * @return string
     */
    public function getHTML()
    {
        return $this->renderedHTML;
    }

    /**
     * Method to get ID
     *
     * @return integer|string
     */
    public function getPid()
    {
        return ($this->currentProductId !== null) ? $this->currentProductId : '';
    }

    /**
     * Method to get additional classes
     *
     * @return string
     */
    public function getAdditionalClasses()
    {
        return $this->additionalClasses;
    }

    /**
     * Method to get scroll options
     *
     * @return string
     */
    public function getScrollOptions()
    {
        return $this->scrollOptions;
    }

    /**
     * Method to get option value
     *
     * @param string $option Option name
     *
     * @return mixed
     */
    public function getOptionValue($option)
    {
        $tool = \XLite\Module\MagicToolbox\Magic360\Classes\Helper::getInstance()->getPrimaryTool();
        $tool->params->setProfile('product');
        return $tool->params->getValue($option);
    }

    /**
     * Method to render Magic360 HTML
     *
     * @return boolean
     */
    public function renderTemplate()
    {
        $helper = \XLite\Module\MagicToolbox\Magic360\Classes\Helper::getInstance();
        $tool = $helper->getPrimaryTool();
        $tool->params->setProfile('product');
        if ($tool->params->checkValue('enable-effect', 'No')) {
            return false;
        }

        $thumbMaxWidth = intval($tool->params->getValue('thumb-max-width', 'product'));
        $thumbMaxHeight = intval($tool->params->getValue('thumb-max-height', 'product'));

        $product = $this->getProduct();
        $this->currentProductId = $product->getId();
        $productName = $product->getName();
        $briefDescription = $product->getBriefDescription();
        $fullDescription = $product->getDescription();
        $images = $product->getSpinImages()->toArray();
        $imagesCount = count($images);
        if ($imagesCount) {
            $tool->params->setValue('columns', $product->getSpinColumns());
        } else {
            //NOTE: old way
            $images = $product->getImages()->toArray();
        }

        $toolData = array();

        foreach ($images as $index => $image) {

            $img = $image->getURL();
            list($width, $height, $thumb) = $image->doResize($thumbMaxWidth, $thumbMaxHeight, false);

            $toolData[] = array(
                'medium' => $thumb,
                'img' => $img,
            );

        }

        $this->renderedHTML = $tool->getMainTemplate($toolData, array('id' => 'productMagic360'));
        $this->renderedHTML = '<div class="MagicToolboxContainer">' . $this->renderedHTML . '</div>';

        return true;
    }

    /**
     * Method to get default image URL
     *
     * @return string
     */
    public function getDefaultImageURL()
    {
        $url = null;

        $url = \XLite::getInstance()->getOptions(['images', 'default_image']);

        if (!\XLite\Core\Converter::isURL($url)) {
            $url = \XLite\Core\Layout::getInstance()->getResourceWebPath(
                $url,
                \XLite\Core\Layout::WEB_PATH_OUTPUT_URL
            );
        }

        $url = str_replace(array('http://', 'https://'), '//', $url);

        return $url;
    }
}
