<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\View\FormField;

/**
 * Form text
 *
 */
class MagicToolboxLicenseText extends MagicToolboxText
{
    /**
     * Check license
     *
     * @return boolean
     */
    public function isLicensed()
    {
        $id = $this->getFieldId();
        $jsPath = 'modules/MagicToolbox/Magic360/js/magic360.js';
        if ($id == 'magicscroll-license-key') {
            $jsPath = 'modules/MagicToolbox/Magic360/js/magicscroll.js';
        }
        $jsPath = \XLite\Core\Layout::getInstance()->getResourceFullPath($jsPath, \XLite::CUSTOMER_INTERFACE, false);
        $contents = \Includes\Utils\FileManager::read($jsPath);
        return $contents ? (strpos($contents, ' DEMO') === false) : false;
    }

    /**
     * Get upgrade text
     *
     * @return string
     */
    public function getUpgradeText()
    {
        return $this->getParam(self::PARAM_HELP);
    }

    /**
     * Return field template
     *
     * @return string
     */
    protected function getFieldTemplate()
    {
        return '../modules/MagicToolbox/Magic360/license.twig';
    }

    /**
     * Check for help present
     *
     * @return boolean
     */
    protected function hasHelp()
    {
        return false;
    }
}
