<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\View;

/**
 * File uploader
 */
class FileUploader extends \XLite\View\FileUploader
{

    /**
     * Register files from common repository
     *
     * @return array
     */
    public function getCommonFiles()
    {
        $list = parent::getCommonFiles();

        if (isset($list[static::RESOURCE_JS])) {
            $key = array_search('file_uploader/controller.js', $list[static::RESOURCE_JS]);
            if ($key !== false) {
                unset($list[static::RESOURCE_JS][$key]);
            }
        }

        return $list;
    }

    /**
     * Get a list of JS files required to display the widget properly
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        $key = array_search('file_uploader/controller.js', $list);
        if ($key !== false) {
            unset($list[$key]);
        }
        $list[] = 'modules/MagicToolbox/Magic360/file_uploader/controller.js';

        return $list;
    }

    /**
     * Get a list of CSS files required to display the widget properly
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/MagicToolbox/Magic360/file_uploader/style.css';
        return $list;
    }

    /**
     * Return preview
     *
     * @return string
     */
    protected function getPreview()
    {
        $result = '';
        if ($this->getMessage()) {
            $result = '<i class="icon fa warning fa-exclamation-triangle"></i>';
        } elseif ($this->isImage() && $this->hasFile()) {
            $viewer = new \XLite\View\Image([
                'image' => $this->getObject(),
                'maxWidth' => $this->getParam(static::PARAM_MAX_WIDTH),
                'maxHeight' => $this->getParam(static::PARAM_MAX_HEIGHT),
                'alt' => '',
                'centerImage' => true
            ]);

            $result = '<div class="preview">'
                . $viewer->getContent()
                . '</div>';
        } elseif ($this->isImage()) {
            $result = '<i class="icon fa fa-camera"></i>';
        }

        return $result;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/MagicToolbox/Magic360/file_uploader/body.twig';
    }
}
