<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\Model;

/**
 * Product
 *
 */
class Product extends \XLite\Model\Product implements \XLite\Base\IDecorator
{
    /**
     * Product spin images
     *
     * @var \Doctrine\Common\Collections\Collection
     *
     * @OneToMany (targetEntity="XLite\Module\MagicToolbox\Magic360\Model\Image", mappedBy="product", cascade={"all"})
     * @JoinColumn(name="product_id", referencedColumnName="product_id")
     * @OrderBy   ({"orderby" = "ASC"})
     */
    protected $spinImages;

    /**
     * Product spin columns
     *
     * @var integer
     *
     */
    protected $spinColumns;

    /**
     * Has product spin
     *
     * @var boolean
     *
     */
    protected $hasSpin = null;

    /**
     * Constructor
     *
     * @param array $data Entity properties OPTIONAL
     */
    public function __construct(array $data = array())
    {
        $this->spinImages = new \Doctrine\Common\Collections\ArrayCollection();
        parent::__construct($data);
    }

    /**
     * Add spin images
     *
     * @param \XLite\Module\MagicToolbox\Magic360\Model\Image $image
     * @return Product
     */
    public function addSpinImages(\XLite\Module\MagicToolbox\Magic360\Model\Image $image)
    {
        $this->spinImages[] = $image;
        return $this;
    }

    /**
     * Get spin images
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSpinImages()
    {
        return $this->spinImages;
    }

    /**
     * Get spin images count
     *
     * @return integer
     */
    public function getSpinImagesCount()
    {
        return $this->spinImages->count();
    }

    /**
     * Check if product has spin
     *
     * @return boolean
     */
    public function hasSpin()
    {
        if ($this->hasSpin === null) {
            $this->hasSpin = ($this->spinImages->count() > 0);
        }
        return $this->hasSpin;
    }

    /**
     * Set spin columns
     *
     * @param integer $columns
     * @return Product
     */
    public function setSpinColumns($columns)
    {
        $repo = \XLite\Core\Database::getRepo('XLite\Module\MagicToolbox\Magic360\Model\Columns');
        if ($repo) {
            $model = $repo->find($this->getProductId());
            if ($model) {
                $model->setColumns($columns);
            } else {
                $model = new \XLite\Module\MagicToolbox\Magic360\Model\Columns;
                $model->setProductId($this->getProductId());
                $model->setColumns($columns);
                \XLite\Core\Database::getEM()->persist($model);
            }
            \XLite\Core\Database::getEM()->flush();
            $this->spinColumns = $columns;
        }
        return $this;
    }

    /**
     * Get spin columns
     *
     * @return integer
     */
    public function getSpinColumns()
    {
        if (!isset($this->spinColumns)) {
            $this->spinColumns = 0;
            $repo = \XLite\Core\Database::getRepo('XLite\Module\MagicToolbox\Magic360\Model\Columns');
            if ($repo) {
                $model = $repo->find($this->getProductId());
                if ($model) {
                    $this->spinColumns = $model->getColumns();
                }
            }
        }
        return $this->spinColumns;
    }
}
